@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.iot.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property roleArn The ARN of a role that has permission to create and attach to elastic network interfaces (ENIs).
 * @property securityGroups The security groups of the VPC destination.
 * @property subnetIds The subnet IDs of the VPC destination.
 * @property vpcId The ID of the VPC.
 */
public data class TopicRuleDestinationVpcConfiguration(
    public val roleArn: String,
    public val securityGroups: List<String>? = null,
    public val subnetIds: List<String>,
    public val vpcId: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.iot.outputs.TopicRuleDestinationVpcConfiguration):
            TopicRuleDestinationVpcConfiguration = TopicRuleDestinationVpcConfiguration(
            roleArn = javaType.roleArn(),
            securityGroups = javaType.securityGroups().map({ args0 -> args0 }),
            subnetIds = javaType.subnetIds().map({ args0 -> args0 }),
            vpcId = javaType.vpcId(),
        )
    }
}
