@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.iot.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property metricName The CloudWatch metric name.
 * @property metricNamespace The CloudWatch metric namespace name.
 * @property metricTimestamp An optional Unix timestamp (http://docs.aws.amazon.com/AmazonCloudWatch/latest/DeveloperGuide/cloudwatch_concepts.html#about_timestamp).
 * @property metricUnit The metric unit (supported units can be found here: http://docs.aws.amazon.com/AmazonCloudWatch/latest/DeveloperGuide/cloudwatch_concepts.html#Unit)
 * @property metricValue The CloudWatch metric value.
 * @property roleArn The IAM role ARN that allows access to the CloudWatch metric.
 */
public data class TopicRuleErrorActionCloudwatchMetric(
    public val metricName: String,
    public val metricNamespace: String,
    public val metricTimestamp: String? = null,
    public val metricUnit: String,
    public val metricValue: String,
    public val roleArn: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.iot.outputs.TopicRuleErrorActionCloudwatchMetric):
            TopicRuleErrorActionCloudwatchMetric = TopicRuleErrorActionCloudwatchMetric(
            metricName = javaType.metricName(),
            metricNamespace = javaType.metricNamespace(),
            metricTimestamp = javaType.metricTimestamp().map({ args0 -> args0 }).orElse(null),
            metricUnit = javaType.metricUnit(),
            metricValue = javaType.metricValue(),
            roleArn = javaType.roleArn(),
        )
    }
}
