@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.iot.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property batchMode The payload that contains a JSON array of records will be sent to IoT Analytics via a batch call.
 * @property channelName Name of AWS IOT Analytics channel.
 * @property roleArn The ARN of the IAM role that grants access.
 */
public data class TopicRuleErrorActionIotAnalytics(
    public val batchMode: Boolean? = null,
    public val channelName: String,
    public val roleArn: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.iot.outputs.TopicRuleErrorActionIotAnalytics):
            TopicRuleErrorActionIotAnalytics = TopicRuleErrorActionIotAnalytics(
            batchMode = javaType.batchMode().map({ args0 -> args0 }).orElse(null),
            channelName = javaType.channelName(),
            roleArn = javaType.roleArn(),
        )
    }
}
