@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.iot.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property bucketName The Amazon S3 bucket name.
 * @property cannedAcl The Amazon S3 canned ACL that controls access to the object identified by the object key. [Valid values](https://docs.aws.amazon.com/AmazonS3/latest/userguide/acl-overview.html#canned-acl).
 * @property key The name of the HTTP header.
 * @property roleArn The IAM role ARN that allows access to the CloudWatch alarm.
 */
public data class TopicRuleErrorActionS3(
    public val bucketName: String,
    public val cannedAcl: String? = null,
    public val key: String,
    public val roleArn: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.iot.outputs.TopicRuleErrorActionS3):
            TopicRuleErrorActionS3 = TopicRuleErrorActionS3(
            bucketName = javaType.bucketName(),
            cannedAcl = javaType.cannedAcl().map({ args0 -> args0 }).orElse(null),
            key = javaType.key(),
            roleArn = javaType.roleArn(),
        )
    }
}
