@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.iot.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property executionNamePrefix The prefix used to generate, along with a UUID, the unique state machine execution name.
 * @property roleArn The ARN of the IAM role that grants access to start execution of the state machine.
 * @property stateMachineName The name of the Step Functions state machine whose execution will be started.
 */
public data class TopicRuleStepFunction(
    public val executionNamePrefix: String? = null,
    public val roleArn: String,
    public val stateMachineName: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.iot.outputs.TopicRuleStepFunction):
            TopicRuleStepFunction = TopicRuleStepFunction(
            executionNamePrefix = javaType.executionNamePrefix().map({ args0 -> args0 }).orElse(null),
            roleArn = javaType.roleArn(),
            stateMachineName = javaType.stateMachineName(),
        )
    }
}
