@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.iot.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property databaseName The name of an Amazon Timestream database.
 * @property dimensions Configuration blocks with metadata attributes of the time series that are written in each measure record. Nested arguments below.
 * @property roleArn The ARN of the role that grants permission to write to the Amazon Timestream database table.
 * @property tableName The name of the database table into which to write the measure records.
 * @property timestamp Configuration block specifying an application-defined value to replace the default value assigned to the Timestream record's timestamp in the time column. Nested arguments below.
 */
public data class TopicRuleTimestream(
    public val databaseName: String,
    public val dimensions: List<TopicRuleTimestreamDimension>,
    public val roleArn: String,
    public val tableName: String,
    public val timestamp: TopicRuleTimestreamTimestamp? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.iot.outputs.TopicRuleTimestream):
            TopicRuleTimestream = TopicRuleTimestream(
            databaseName = javaType.databaseName(),
            dimensions = javaType.dimensions().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.iot.kotlin.outputs.TopicRuleTimestreamDimension.Companion.toKotlin(args0)
                })
            }),
            roleArn = javaType.roleArn(),
            tableName = javaType.tableName(),
            timestamp = javaType.timestamp().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.iot.kotlin.outputs.TopicRuleTimestreamTimestamp.Companion.toKotlin(args0)
                })
            }).orElse(null),
        )
    }
}
