@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ivs.kotlin

import com.pulumi.aws.ivs.IvsFunctions.getStreamKeyPlain
import com.pulumi.aws.ivs.kotlin.inputs.GetStreamKeyPlainArgs
import com.pulumi.aws.ivs.kotlin.inputs.GetStreamKeyPlainArgsBuilder
import com.pulumi.aws.ivs.kotlin.outputs.GetStreamKeyResult
import com.pulumi.aws.ivs.kotlin.outputs.GetStreamKeyResult.Companion.toKotlin
import kotlinx.coroutines.future.await
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map

public object IvsFunctions {
    /**
     * Data source for managing an AWS IVS (Interactive Video) Stream Key.
     * ## Example Usage
     * ### Basic Usage
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.ivs.IvsFunctions;
     * import com.pulumi.aws.ivs.inputs.GetStreamKeyArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var example = IvsFunctions.getStreamKey(GetStreamKeyArgs.builder()
     *             .channelArn("arn:aws:ivs:us-west-2:326937407773:channel/0Y1lcs4U7jk5")
     *             .build());
     *     }
     * }
     * ```
     * @param argument A collection of arguments for invoking getStreamKey.
     * @return A collection of values returned by getStreamKey.
     */
    public suspend fun getStreamKey(argument: GetStreamKeyPlainArgs): GetStreamKeyResult =
        toKotlin(getStreamKeyPlain(argument.toJava()).await())

    /**
     * @see [getStreamKey].
     * @param channelArn ARN of the Channel.
     * @param tags Map of tags assigned to the resource.
     * @return A collection of values returned by getStreamKey.
     */
    public suspend fun getStreamKey(channelArn: String, tags: Map<String, String>? = null):
        GetStreamKeyResult {
        val argument = GetStreamKeyPlainArgs(
            channelArn = channelArn,
            tags = tags,
        )
        return toKotlin(getStreamKeyPlain(argument.toJava()).await())
    }

    /**
     * @see [getStreamKey].
     * @param argument Builder for [com&#46;pulumi&#46;aws&#46;ivs&#46;kotlin&#46;inputs&#46;GetStreamKeyPlainArgs].
     * @return A collection of values returned by getStreamKey.
     */
    public suspend fun getStreamKey(argument: suspend GetStreamKeyPlainArgsBuilder.() -> Unit):
        GetStreamKeyResult {
        val builder = GetStreamKeyPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return toKotlin(getStreamKeyPlain(builtArgument.toJava()).await())
    }
}
