@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ivs.kotlin

import com.pulumi.aws.ivs.PlaybackKeyPairArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Resource for managing an AWS IVS (Interactive Video) Playback Key Pair.
 * ## Example Usage
 * ### Basic Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.ivs.PlaybackKeyPair;
 * import com.pulumi.aws.ivs.PlaybackKeyPairArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new PlaybackKeyPair("example", PlaybackKeyPairArgs.builder()
 *             .publicKey(Files.readString(Paths.get("./public-key.pem")))
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import IVS (Interactive Video) Playback Key Pair using the ARN. For example:
 * ```sh
 *  $ pulumi import aws:ivs/playbackKeyPair:PlaybackKeyPair example arn:aws:ivs:us-west-2:326937407773:playback-key/KDJRJNQhiQzA
 * ```
 * @property name Playback Key Pair name.
 * @property publicKey Public portion of a customer-generated key pair. Must be an ECDSA public key in PEM format.
 * The following arguments are optional:
 * @property tags A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
 */
public data class PlaybackKeyPairArgs(
    public val name: Output<String>? = null,
    public val publicKey: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.aws.ivs.PlaybackKeyPairArgs> {
    override fun toJava(): com.pulumi.aws.ivs.PlaybackKeyPairArgs =
        com.pulumi.aws.ivs.PlaybackKeyPairArgs.builder()
            .name(name?.applyValue({ args0 -> args0 }))
            .publicKey(publicKey?.applyValue({ args0 -> args0 }))
            .tags(
                tags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [PlaybackKeyPairArgs].
 */
@PulumiTagMarker
public class PlaybackKeyPairArgsBuilder internal constructor() {
    private var name: Output<String>? = null

    private var publicKey: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value Playback Key Pair name.
     */
    @JvmName("ccvlqmcbtlgyhxwj")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value Public portion of a customer-generated key pair. Must be an ECDSA public key in PEM format.
     * The following arguments are optional:
     */
    @JvmName("dcqyyhvwvermdksb")
    public suspend fun publicKey(`value`: Output<String>) {
        this.publicKey = value
    }

    /**
     * @param value A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("itigttsntqmkytek")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value Playback Key Pair name.
     */
    @JvmName("hlkgtabohmsnsiik")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value Public portion of a customer-generated key pair. Must be an ECDSA public key in PEM format.
     * The following arguments are optional:
     */
    @JvmName("otlnkxvsendwtjmr")
    public suspend fun publicKey(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.publicKey = mapped
    }

    /**
     * @param value A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("lgjalehitkpgardw")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("xdwhsjhwvukuaewa")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): PlaybackKeyPairArgs = PlaybackKeyPairArgs(
        name = name,
        publicKey = publicKey,
        tags = tags,
    )
}
