@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ivs.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map

/**
 * A collection of values returned by getStreamKey.
 * @property arn ARN of the Stream Key.
 * @property channelArn
 * @property id The provider-assigned unique ID for this managed resource.
 * @property tags Map of tags assigned to the resource.
 * @property value Stream Key value.
 */
public data class GetStreamKeyResult(
    public val arn: String,
    public val channelArn: String,
    public val id: String,
    public val tags: Map<String, String>,
    public val `value`: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.ivs.outputs.GetStreamKeyResult): GetStreamKeyResult =
            GetStreamKeyResult(
                arn = javaType.arn(),
                channelArn = javaType.channelArn(),
                id = javaType.id(),
                tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
                `value` = javaType.`value`(),
            )
    }
}
