@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ivschat.kotlin

import com.pulumi.aws.ivschat.kotlin.outputs.LoggingConfigurationDestinationConfiguration
import com.pulumi.aws.ivschat.kotlin.outputs.LoggingConfigurationDestinationConfiguration.Companion.toKotlin
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map

/**
 * Builder for [LoggingConfiguration].
 */
@PulumiTagMarker
public class LoggingConfigurationResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: LoggingConfigurationArgs = LoggingConfigurationArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend LoggingConfigurationArgsBuilder.() -> Unit) {
        val builder = LoggingConfigurationArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): LoggingConfiguration {
        val builtJavaResource = com.pulumi.aws.ivschat.LoggingConfiguration(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return LoggingConfiguration(builtJavaResource)
    }
}

/**
 * Resource for managing an AWS IVS (Interactive Video) Chat Logging Configuration.
 * ## Example Usage
 * ### Basic Usage - Logging to CloudWatch
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.cloudwatch.LogGroup;
 * import com.pulumi.aws.ivschat.LoggingConfiguration;
 * import com.pulumi.aws.ivschat.LoggingConfigurationArgs;
 * import com.pulumi.aws.ivschat.inputs.LoggingConfigurationDestinationConfigurationArgs;
 * import com.pulumi.aws.ivschat.inputs.LoggingConfigurationDestinationConfigurationCloudwatchLogsArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var exampleLogGroup = new LogGroup("exampleLogGroup");
 *         var exampleLoggingConfiguration = new LoggingConfiguration("exampleLoggingConfiguration", LoggingConfigurationArgs.builder()
 *             .destinationConfiguration(LoggingConfigurationDestinationConfigurationArgs.builder()
 *                 .cloudwatchLogs(LoggingConfigurationDestinationConfigurationCloudwatchLogsArgs.builder()
 *                     .logGroupName(exampleLogGroup.name())
 *                     .build())
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ### Basic Usage - Logging to Kinesis Firehose with Extended S3
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.s3.BucketV2;
 * import com.pulumi.aws.s3.BucketV2Args;
 * import com.pulumi.aws.iam.IamFunctions;
 * import com.pulumi.aws.iam.inputs.GetPolicyDocumentArgs;
 * import com.pulumi.aws.iam.Role;
 * import com.pulumi.aws.iam.RoleArgs;
 * import com.pulumi.aws.kinesis.FirehoseDeliveryStream;
 * import com.pulumi.aws.kinesis.FirehoseDeliveryStreamArgs;
 * import com.pulumi.aws.kinesis.inputs.FirehoseDeliveryStreamExtendedS3ConfigurationArgs;
 * import com.pulumi.aws.s3.BucketAclV2;
 * import com.pulumi.aws.s3.BucketAclV2Args;
 * import com.pulumi.aws.ivschat.LoggingConfiguration;
 * import com.pulumi.aws.ivschat.LoggingConfigurationArgs;
 * import com.pulumi.aws.ivschat.inputs.LoggingConfigurationDestinationConfigurationArgs;
 * import com.pulumi.aws.ivschat.inputs.LoggingConfigurationDestinationConfigurationFirehoseArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var exampleBucketV2 = new BucketV2("exampleBucketV2", BucketV2Args.builder()
 *             .bucketPrefix("tf-ivschat-logging-bucket")
 *             .build());
 *         final var assumeRole = IamFunctions.getPolicyDocument(GetPolicyDocumentArgs.builder()
 *             .statements(GetPolicyDocumentStatementArgs.builder()
 *                 .effect("Allow")
 *                 .principals(GetPolicyDocumentStatementPrincipalArgs.builder()
 *                     .type("Service")
 *                     .identifiers("firehose.amazonaws.com")
 *                     .build())
 *                 .actions("sts:AssumeRole")
 *                 .build())
 *             .build());
 *         var exampleRole = new Role("exampleRole", RoleArgs.builder()
 *             .assumeRolePolicy(assumeRole.applyValue(getPolicyDocumentResult -> getPolicyDocumentResult.json()))
 *             .build());
 *         var exampleFirehoseDeliveryStream = new FirehoseDeliveryStream("exampleFirehoseDeliveryStream", FirehoseDeliveryStreamArgs.builder()
 *             .destination("extended_s3")
 *             .extendedS3Configuration(FirehoseDeliveryStreamExtendedS3ConfigurationArgs.builder()
 *                 .roleArn(exampleRole.arn())
 *                 .bucketArn(exampleBucketV2.arn())
 *                 .build())
 *             .tags(Map.of("LogDeliveryEnabled", "true"))
 *             .build());
 *         var exampleBucketAclV2 = new BucketAclV2("exampleBucketAclV2", BucketAclV2Args.builder()
 *             .bucket(exampleBucketV2.id())
 *             .acl("private")
 *             .build());
 *         var exampleLoggingConfiguration = new LoggingConfiguration("exampleLoggingConfiguration", LoggingConfigurationArgs.builder()
 *             .destinationConfiguration(LoggingConfigurationDestinationConfigurationArgs.builder()
 *                 .firehose(LoggingConfigurationDestinationConfigurationFirehoseArgs.builder()
 *                     .deliveryStreamName(exampleFirehoseDeliveryStream.name())
 *                     .build())
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ### Basic Usage - Logging to S3
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.s3.BucketV2;
 * import com.pulumi.aws.s3.BucketV2Args;
 * import com.pulumi.aws.ivschat.LoggingConfiguration;
 * import com.pulumi.aws.ivschat.LoggingConfigurationArgs;
 * import com.pulumi.aws.ivschat.inputs.LoggingConfigurationDestinationConfigurationArgs;
 * import com.pulumi.aws.ivschat.inputs.LoggingConfigurationDestinationConfigurationS3Args;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var exampleBucketV2 = new BucketV2("exampleBucketV2", BucketV2Args.builder()
 *             .bucketName("tf-ivschat-logging")
 *             .forceDestroy(true)
 *             .build());
 *         var exampleLoggingConfiguration = new LoggingConfiguration("exampleLoggingConfiguration", LoggingConfigurationArgs.builder()
 *             .destinationConfiguration(LoggingConfigurationDestinationConfigurationArgs.builder()
 *                 .s3(LoggingConfigurationDestinationConfigurationS3Args.builder()
 *                     .bucketName(exampleBucketV2.id())
 *                     .build())
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import IVS (Interactive Video) Chat Logging Configuration using the ARN. For example:
 * ```sh
 *  $ pulumi import aws:ivschat/loggingConfiguration:LoggingConfiguration example arn:aws:ivschat:us-west-2:326937407773:logging-configuration/MMUQc8wcqZmC
 * ```
 *
 */
public class LoggingConfiguration internal constructor(
    override val javaResource: com.pulumi.aws.ivschat.LoggingConfiguration,
) : KotlinCustomResource(javaResource, LoggingConfigurationMapper) {
    /**
     * ARN of the Logging Configuration.
     */
    public val arn: Output<String>
        get() = javaResource.arn().applyValue({ args0 -> args0 })

    /**
     * Object containing destination configuration for where chat activity will be logged. This object must contain exactly one of the following children arguments:
     */
    public val destinationConfiguration: Output<LoggingConfigurationDestinationConfiguration>?
        get() = javaResource.destinationConfiguration().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> toKotlin(args0) })
            }).orElse(null)
        })

    /**
     * Logging Configuration name.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * State of the Logging Configuration.
     */
    public val state: Output<String>
        get() = javaResource.state().applyValue({ args0 -> args0 })

    /**
     * A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * Map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
     */
    @Deprecated(
        message = """
  Please use `tags` instead.
  """,
    )
    public val tagsAll: Output<Map<String, String>>
        get() = javaResource.tagsAll().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.key.to(args0.value)
            }).toMap()
        })
}

public object LoggingConfigurationMapper : ResourceMapper<LoggingConfiguration> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.ivschat.LoggingConfiguration::class == javaResource::class

    override fun map(javaResource: Resource): LoggingConfiguration = LoggingConfiguration(
        javaResource
            as com.pulumi.aws.ivschat.LoggingConfiguration,
    )
}

/**
 * @see [LoggingConfiguration].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [LoggingConfiguration].
 */
public suspend fun loggingConfiguration(
    name: String,
    block: suspend LoggingConfigurationResourceBuilder.() -> Unit,
): LoggingConfiguration {
    val builder = LoggingConfigurationResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [LoggingConfiguration].
 * @param name The _unique_ name of the resulting resource.
 */
public fun loggingConfiguration(name: String): LoggingConfiguration {
    val builder = LoggingConfigurationResourceBuilder()
    builder.name(name)
    return builder.build()
}
