@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ivschat.kotlin

import com.pulumi.aws.ivschat.kotlin.outputs.RoomMessageReviewHandler
import com.pulumi.aws.ivschat.kotlin.outputs.RoomMessageReviewHandler.Companion.toKotlin
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map

/**
 * Builder for [Room].
 */
@PulumiTagMarker
public class RoomResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: RoomArgs = RoomArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend RoomArgsBuilder.() -> Unit) {
        val builder = RoomArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): Room {
        val builtJavaResource = com.pulumi.aws.ivschat.Room(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return Room(builtJavaResource)
    }
}

/**
 * Resource for managing an AWS IVS (Interactive Video) Chat Room.
 * ## Example Usage
 * ### Basic Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.ivschat.Room;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new Room("example");
 *     }
 * }
 * ```
 * ## Usage with Logging Configuration to S3 Bucket
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const exampleBucketV2 = new aws.s3.BucketV2("exampleBucketV2", {
 *     bucketPrefix: "tf-ivschat-logging-bucket-",
 *     forceDestroy: true,
 * });
 * const exampleLoggingConfiguration = new aws.ivschat.LoggingConfiguration("exampleLoggingConfiguration", {destinationConfiguration: {
 *     s3: {
 *         bucketName: exampleBucketV2.id,
 *     },
 * }});
 * const exampleRoom = new aws.ivschat.Room("exampleRoom", {loggingConfigurationIdentifiers: [exampleLoggingConfiguration&#46;arn]});
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example_bucket_v2 = aws.s3.BucketV2("exampleBucketV2",
 *     bucket_prefix="tf-ivschat-logging-bucket-",
 *     force_destroy=True)
 * example_logging_configuration = aws.ivschat.LoggingConfiguration("exampleLoggingConfiguration", destination_configuration=aws.ivschat.LoggingConfigurationDestinationConfigurationArgs(
 *     s3=aws.ivschat.LoggingConfigurationDestinationConfigurationS3Args(
 *         bucket_name=example_bucket_v2.id,
 *     ),
 * ))
 * example_room = aws.ivschat.Room("exampleRoom", logging_configuration_identifiers=[example_logging_configuration&#46;arn])
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var exampleBucketV2 = new Aws.S3.BucketV2("exampleBucketV2", new()
 *     {
 *         BucketPrefix = "tf-ivschat-logging-bucket-",
 *         ForceDestroy = true,
 *     });
 *     var exampleLoggingConfiguration = new Aws.IvsChat.LoggingConfiguration("exampleLoggingConfiguration", new()
 *     {
 *         DestinationConfiguration = new Aws.IvsChat.Inputs.LoggingConfigurationDestinationConfigurationArgs
 *         {
 *             S3 = new Aws.IvsChat.Inputs.LoggingConfigurationDestinationConfigurationS3Args
 *             {
 *                 BucketName = exampleBucketV2.Id,
 *             },
 *         },
 *     });
 *     var exampleRoom = new Aws.IvsChat.Room("exampleRoom", new()
 *     {
 *         LoggingConfigurationIdentifiers = new[]
 *         {
 *             exampleLoggingConfiguration.Arn,
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/ivschat"
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/s3"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		exampleBucketV2, err := s3.NewBucketV2(ctx, "exampleBucketV2", &s3.BucketV2Args{
 * 			BucketPrefix: pulumi.String("tf-ivschat-logging-bucket-"),
 * 			ForceDestroy: pulumi.Bool(true),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		exampleLoggingConfiguration, err := ivschat.NewLoggingConfiguration(ctx, "exampleLoggingConfiguration", &ivschat.LoggingConfigurationArgs{
 * 			DestinationConfiguration: &ivschat.LoggingConfigurationDestinationConfigurationArgs{
 * 				S3: &ivschat.LoggingConfigurationDestinationConfigurationS3Args{
 * 					BucketName: exampleBucketV2.ID(),
 * 				},
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = ivschat.NewRoom(ctx, "exampleRoom", &ivschat.RoomArgs{
 * 			LoggingConfigurationIdentifiers: pulumi.StringArray{
 * 				exampleLoggingConfiguration.Arn,
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.s3.BucketV2;
 * import com.pulumi.aws.s3.BucketV2Args;
 * import com.pulumi.aws.ivschat.LoggingConfiguration;
 * import com.pulumi.aws.ivschat.LoggingConfigurationArgs;
 * import com.pulumi.aws.ivschat.inputs.LoggingConfigurationDestinationConfigurationArgs;
 * import com.pulumi.aws.ivschat.inputs.LoggingConfigurationDestinationConfigurationS3Args;
 * import com.pulumi.aws.ivschat.Room;
 * import com.pulumi.aws.ivschat.RoomArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var exampleBucketV2 = new BucketV2("exampleBucketV2", BucketV2Args.builder()
 *             .bucketPrefix("tf-ivschat-logging-bucket-")
 *             .forceDestroy(true)
 *             .build());
 *         var exampleLoggingConfiguration = new LoggingConfiguration("exampleLoggingConfiguration", LoggingConfigurationArgs.builder()
 *             .destinationConfiguration(LoggingConfigurationDestinationConfigurationArgs.builder()
 *                 .s3(LoggingConfigurationDestinationConfigurationS3Args.builder()
 *                     .bucketName(exampleBucketV2.id())
 *                     .build())
 *                 .build())
 *             .build());
 *         var exampleRoom = new Room("exampleRoom", RoomArgs.builder()
 *             .loggingConfigurationIdentifiers(exampleLoggingConfiguration.arn())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   exampleBucketV2:
 *     type: aws:s3:BucketV2
 *     properties:
 *       bucketPrefix: tf-ivschat-logging-bucket-
 *       forceDestroy: true
 *   exampleLoggingConfiguration:
 *     type: aws:ivschat:LoggingConfiguration
 *     properties:
 *       destinationConfiguration:
 *         s3:
 *           bucketName: ${exampleBucketV2.id}
 *   exampleRoom:
 *     type: aws:ivschat:Room
 *     properties:
 *       loggingConfigurationIdentifiers:
 *         - ${exampleLoggingConfiguration.arn}
 * ```
 * ## Import
 * Using `pulumi import`, import IVS (Interactive Video) Chat Room using the ARN. For example:
 * ```sh
 *  $ pulumi import aws:ivschat/room:Room example arn:aws:ivschat:us-west-2:326937407773:room/GoXEXyB4VwHb
 * ```
 *
 */
public class Room internal constructor(
    override val javaResource: com.pulumi.aws.ivschat.Room,
) : KotlinCustomResource(javaResource, RoomMapper) {
    /**
     * ARN of the Room.
     */
    public val arn: Output<String>
        get() = javaResource.arn().applyValue({ args0 -> args0 })

    /**
     * List of Logging Configuration
     * ARNs to attach to the room.
     */
    public val loggingConfigurationIdentifiers: Output<List<String>>?
        get() = javaResource.loggingConfigurationIdentifiers().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 -> args0 })
            }).orElse(null)
        })

    /**
     * Maximum number of characters in a single
     * message. Messages are expected to be UTF-8 encoded and this limit applies
     * specifically to rune/code-point count, not number of bytes.
     */
    public val maximumMessageLength: Output<Int>
        get() = javaResource.maximumMessageLength().applyValue({ args0 -> args0 })

    /**
     * Maximum number of messages per
     * second that can be sent to the room (by all clients).
     */
    public val maximumMessageRatePerSecond: Output<Int>
        get() = javaResource.maximumMessageRatePerSecond().applyValue({ args0 -> args0 })

    /**
     * Configuration information for optional
     * review of messages.
     */
    public val messageReviewHandler: Output<RoomMessageReviewHandler>?
        get() = javaResource.messageReviewHandler().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> toKotlin(args0) })
            }).orElse(null)
        })

    /**
     * Room name.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * Map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
     */
    @Deprecated(
        message = """
  Please use `tags` instead.
  """,
    )
    public val tagsAll: Output<Map<String, String>>
        get() = javaResource.tagsAll().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.key.to(args0.value)
            }).toMap()
        })
}

public object RoomMapper : ResourceMapper<Room> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.ivschat.Room::class == javaResource::class

    override fun map(javaResource: Resource): Room = Room(javaResource as com.pulumi.aws.ivschat.Room)
}

/**
 * @see [Room].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [Room].
 */
public suspend fun room(name: String, block: suspend RoomResourceBuilder.() -> Unit): Room {
    val builder = RoomResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [Room].
 * @param name The _unique_ name of the resulting resource.
 */
public fun room(name: String): Room {
    val builder = RoomResourceBuilder()
    builder.name(name)
    return builder.build()
}
