@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ivschat.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property fallbackResult The fallback behavior (whether the message
 * is allowed or denied) if the handler does not return a valid response,
 * encounters an error, or times out. Valid values: `ALLOW`, `DENY`.
 * @property uri ARN of the lambda message review handler function.
 */
public data class RoomMessageReviewHandler(
    public val fallbackResult: String? = null,
    public val uri: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.ivschat.outputs.RoomMessageReviewHandler):
            RoomMessageReviewHandler = RoomMessageReviewHandler(
            fallbackResult = javaType.fallbackResult().map({ args0 -> args0 }).orElse(null),
            uri = javaType.uri().map({ args0 -> args0 }).orElse(null),
        )
    }
}
