@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.kendra.kotlin

import com.pulumi.aws.kendra.kotlin.outputs.DataSourceConfiguration
import com.pulumi.aws.kendra.kotlin.outputs.DataSourceCustomDocumentEnrichmentConfiguration
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import com.pulumi.aws.kendra.kotlin.outputs.DataSourceConfiguration.Companion.toKotlin as dataSourceConfigurationToKotlin
import com.pulumi.aws.kendra.kotlin.outputs.DataSourceCustomDocumentEnrichmentConfiguration.Companion.toKotlin as dataSourceCustomDocumentEnrichmentConfigurationToKotlin

/**
 * Builder for [DataSource].
 */
@PulumiTagMarker
public class DataSourceResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: DataSourceArgs = DataSourceArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend DataSourceArgsBuilder.() -> Unit) {
        val builder = DataSourceArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): DataSource {
        val builtJavaResource = com.pulumi.aws.kendra.DataSource(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return DataSource(builtJavaResource)
    }
}

/**
 * Resource for managing an AWS Kendra Data Source.
 * ## Example Usage
 * ### Basic Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.kendra.DataSource;
 * import com.pulumi.aws.kendra.DataSourceArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new DataSource("example", DataSourceArgs.builder()
 *             .indexId(aws_kendra_index.example().id())
 *             .description("example")
 *             .languageCode("en")
 *             .type("CUSTOM")
 *             .tags(Map.of("hello", "world"))
 *             .build());
 *     }
 * }
 * ```
 * ### With Schedule
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.kendra.DataSource;
 * import com.pulumi.aws.kendra.DataSourceArgs;
 * import com.pulumi.aws.kendra.inputs.DataSourceConfigurationArgs;
 * import com.pulumi.aws.kendra.inputs.DataSourceConfigurationS3ConfigurationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new DataSource("example", DataSourceArgs.builder()
 *             .indexId(aws_kendra_index.example().id())
 *             .type("S3")
 *             .roleArn(aws_iam_role.example().arn())
 *             .schedule("cron(9 10 1 * ? *)")
 *             .configuration(DataSourceConfigurationArgs.builder()
 *                 .s3Configuration(DataSourceConfigurationS3ConfigurationArgs.builder()
 *                     .bucketName(aws_s3_bucket.example().id())
 *                     .build())
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ### With Access Control List
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.kendra.DataSource;
 * import com.pulumi.aws.kendra.DataSourceArgs;
 * import com.pulumi.aws.kendra.inputs.DataSourceConfigurationArgs;
 * import com.pulumi.aws.kendra.inputs.DataSourceConfigurationS3ConfigurationArgs;
 * import com.pulumi.aws.kendra.inputs.DataSourceConfigurationS3ConfigurationAccessControlListConfigurationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new DataSource("example", DataSourceArgs.builder()
 *             .indexId(aws_kendra_index.example().id())
 *             .type("S3")
 *             .roleArn(aws_iam_role.example().arn())
 *             .configuration(DataSourceConfigurationArgs.builder()
 *                 .s3Configuration(DataSourceConfigurationS3ConfigurationArgs.builder()
 *                     .bucketName(aws_s3_bucket.example().id())
 *                     .accessControlListConfiguration(DataSourceConfigurationS3ConfigurationAccessControlListConfigurationArgs.builder()
 *                         .keyPath(String.format("s3://%s/path-1", aws_s3_bucket.example().id()))
 *                         .build())
 *                     .build())
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ### With Documents Metadata Configuration
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.kendra.DataSource;
 * import com.pulumi.aws.kendra.DataSourceArgs;
 * import com.pulumi.aws.kendra.inputs.DataSourceConfigurationArgs;
 * import com.pulumi.aws.kendra.inputs.DataSourceConfigurationS3ConfigurationArgs;
 * import com.pulumi.aws.kendra.inputs.DataSourceConfigurationS3ConfigurationDocumentsMetadataConfigurationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new DataSource("example", DataSourceArgs.builder()
 *             .indexId(aws_kendra_index.example().id())
 *             .type("S3")
 *             .roleArn(aws_iam_role.example().arn())
 *             .configuration(DataSourceConfigurationArgs.builder()
 *                 .s3Configuration(DataSourceConfigurationS3ConfigurationArgs.builder()
 *                     .bucketName(aws_s3_bucket.example().id())
 *                     .exclusionPatterns("example")
 *                     .inclusionPatterns("hello")
 *                     .inclusionPrefixes("world")
 *                     .documentsMetadataConfiguration(DataSourceConfigurationS3ConfigurationDocumentsMetadataConfigurationArgs.builder()
 *                         .s3Prefix("example")
 *                         .build())
 *                     .build())
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ### With Seed URLs
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.kendra.DataSource;
 * import com.pulumi.aws.kendra.DataSourceArgs;
 * import com.pulumi.aws.kendra.inputs.DataSourceConfigurationArgs;
 * import com.pulumi.aws.kendra.inputs.DataSourceConfigurationWebCrawlerConfigurationArgs;
 * import com.pulumi.aws.kendra.inputs.DataSourceConfigurationWebCrawlerConfigurationUrlsArgs;
 * import com.pulumi.aws.kendra.inputs.DataSourceConfigurationWebCrawlerConfigurationUrlsSeedUrlConfigurationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new DataSource("example", DataSourceArgs.builder()
 *             .indexId(aws_kendra_index.example().id())
 *             .type("WEBCRAWLER")
 *             .roleArn(aws_iam_role.example().arn())
 *             .configuration(DataSourceConfigurationArgs.builder()
 *                 .webCrawlerConfiguration(DataSourceConfigurationWebCrawlerConfigurationArgs.builder()
 *                     .urls(DataSourceConfigurationWebCrawlerConfigurationUrlsArgs.builder()
 *                         .seedUrlConfiguration(DataSourceConfigurationWebCrawlerConfigurationUrlsSeedUrlConfigurationArgs.builder()
 *                             .seedUrls("REPLACE_WITH_YOUR_URL")
 *                             .build())
 *                         .build())
 *                     .build())
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ### With Site Maps
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.kendra.DataSource;
 * import com.pulumi.aws.kendra.DataSourceArgs;
 * import com.pulumi.aws.kendra.inputs.DataSourceConfigurationArgs;
 * import com.pulumi.aws.kendra.inputs.DataSourceConfigurationWebCrawlerConfigurationArgs;
 * import com.pulumi.aws.kendra.inputs.DataSourceConfigurationWebCrawlerConfigurationUrlsArgs;
 * import com.pulumi.aws.kendra.inputs.DataSourceConfigurationWebCrawlerConfigurationUrlsSiteMapsConfigurationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new DataSource("example", DataSourceArgs.builder()
 *             .indexId(aws_kendra_index.example().id())
 *             .type("WEBCRAWLER")
 *             .roleArn(aws_iam_role.example().arn())
 *             .configuration(DataSourceConfigurationArgs.builder()
 *                 .webCrawlerConfiguration(DataSourceConfigurationWebCrawlerConfigurationArgs.builder()
 *                     .urls(DataSourceConfigurationWebCrawlerConfigurationUrlsArgs.builder()
 *                         .siteMapsConfiguration(DataSourceConfigurationWebCrawlerConfigurationUrlsSiteMapsConfigurationArgs.builder()
 *                             .siteMaps("REPLACE_WITH_YOUR_URL")
 *                             .build())
 *                         .build())
 *                     .build())
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ### With Web Crawler Mode
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.kendra.DataSource;
 * import com.pulumi.aws.kendra.DataSourceArgs;
 * import com.pulumi.aws.kendra.inputs.DataSourceConfigurationArgs;
 * import com.pulumi.aws.kendra.inputs.DataSourceConfigurationWebCrawlerConfigurationArgs;
 * import com.pulumi.aws.kendra.inputs.DataSourceConfigurationWebCrawlerConfigurationUrlsArgs;
 * import com.pulumi.aws.kendra.inputs.DataSourceConfigurationWebCrawlerConfigurationUrlsSeedUrlConfigurationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new DataSource("example", DataSourceArgs.builder()
 *             .indexId(aws_kendra_index.example().id())
 *             .type("WEBCRAWLER")
 *             .roleArn(aws_iam_role.example().arn())
 *             .configuration(DataSourceConfigurationArgs.builder()
 *                 .webCrawlerConfiguration(DataSourceConfigurationWebCrawlerConfigurationArgs.builder()
 *                     .urls(DataSourceConfigurationWebCrawlerConfigurationUrlsArgs.builder()
 *                         .seedUrlConfiguration(DataSourceConfigurationWebCrawlerConfigurationUrlsSeedUrlConfigurationArgs.builder()
 *                             .webCrawlerMode("SUBDOMAINS")
 *                             .seedUrls("REPLACE_WITH_YOUR_URL")
 *                             .build())
 *                         .build())
 *                     .build())
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ### With Authentication Configuration
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.kendra.DataSource;
 * import com.pulumi.aws.kendra.DataSourceArgs;
 * import com.pulumi.aws.kendra.inputs.DataSourceConfigurationArgs;
 * import com.pulumi.aws.kendra.inputs.DataSourceConfigurationWebCrawlerConfigurationArgs;
 * import com.pulumi.aws.kendra.inputs.DataSourceConfigurationWebCrawlerConfigurationAuthenticationConfigurationArgs;
 * import com.pulumi.aws.kendra.inputs.DataSourceConfigurationWebCrawlerConfigurationUrlsArgs;
 * import com.pulumi.aws.kendra.inputs.DataSourceConfigurationWebCrawlerConfigurationUrlsSeedUrlConfigurationArgs;
 * import com.pulumi.resources.CustomResourceOptions;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new DataSource("example", DataSourceArgs.builder()
 *             .indexId(aws_kendra_index.example().id())
 *             .type("WEBCRAWLER")
 *             .roleArn(aws_iam_role.example().arn())
 *             .configuration(DataSourceConfigurationArgs.builder()
 *                 .webCrawlerConfiguration(DataSourceConfigurationWebCrawlerConfigurationArgs.builder()
 *                     .authenticationConfiguration(DataSourceConfigurationWebCrawlerConfigurationAuthenticationConfigurationArgs.builder()
 *                         .basicAuthentications(DataSourceConfigurationWebCrawlerConfigurationAuthenticationConfigurationBasicAuthenticationArgs.builder()
 *                             .credentials(aws_secretsmanager_secret.example().arn())
 *                             .host("a.example.com")
 *                             .port("443")
 *                             .build())
 *                         .build())
 *                     .urls(DataSourceConfigurationWebCrawlerConfigurationUrlsArgs.builder()
 *                         .seedUrlConfiguration(DataSourceConfigurationWebCrawlerConfigurationUrlsSeedUrlConfigurationArgs.builder()
 *                             .seedUrls("REPLACE_WITH_YOUR_URL")
 *                             .build())
 *                         .build())
 *                     .build())
 *                 .build())
 *             .build(), CustomResourceOptions.builder()
 *                 .dependsOn(aws_secretsmanager_secret_version.example())
 *                 .build());
 *     }
 * }
 * ```
 * ### With Crawl Depth
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.kendra.DataSource;
 * import com.pulumi.aws.kendra.DataSourceArgs;
 * import com.pulumi.aws.kendra.inputs.DataSourceConfigurationArgs;
 * import com.pulumi.aws.kendra.inputs.DataSourceConfigurationWebCrawlerConfigurationArgs;
 * import com.pulumi.aws.kendra.inputs.DataSourceConfigurationWebCrawlerConfigurationUrlsArgs;
 * import com.pulumi.aws.kendra.inputs.DataSourceConfigurationWebCrawlerConfigurationUrlsSeedUrlConfigurationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new DataSource("example", DataSourceArgs.builder()
 *             .indexId(aws_kendra_index.example().id())
 *             .type("WEBCRAWLER")
 *             .roleArn(aws_iam_role.example().arn())
 *             .configuration(DataSourceConfigurationArgs.builder()
 *                 .webCrawlerConfiguration(DataSourceConfigurationWebCrawlerConfigurationArgs.builder()
 *                     .crawlDepth(3)
 *                     .urls(DataSourceConfigurationWebCrawlerConfigurationUrlsArgs.builder()
 *                         .seedUrlConfiguration(DataSourceConfigurationWebCrawlerConfigurationUrlsSeedUrlConfigurationArgs.builder()
 *                             .seedUrls("REPLACE_WITH_YOUR_URL")
 *                             .build())
 *                         .build())
 *                     .build())
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ### With Max Links Per Page
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.kendra.DataSource;
 * import com.pulumi.aws.kendra.DataSourceArgs;
 * import com.pulumi.aws.kendra.inputs.DataSourceConfigurationArgs;
 * import com.pulumi.aws.kendra.inputs.DataSourceConfigurationWebCrawlerConfigurationArgs;
 * import com.pulumi.aws.kendra.inputs.DataSourceConfigurationWebCrawlerConfigurationUrlsArgs;
 * import com.pulumi.aws.kendra.inputs.DataSourceConfigurationWebCrawlerConfigurationUrlsSeedUrlConfigurationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new DataSource("example", DataSourceArgs.builder()
 *             .indexId(aws_kendra_index.example().id())
 *             .type("WEBCRAWLER")
 *             .roleArn(aws_iam_role.example().arn())
 *             .configuration(DataSourceConfigurationArgs.builder()
 *                 .webCrawlerConfiguration(DataSourceConfigurationWebCrawlerConfigurationArgs.builder()
 *                     .maxLinksPerPage(100)
 *                     .urls(DataSourceConfigurationWebCrawlerConfigurationUrlsArgs.builder()
 *                         .seedUrlConfiguration(DataSourceConfigurationWebCrawlerConfigurationUrlsSeedUrlConfigurationArgs.builder()
 *                             .seedUrls("REPLACE_WITH_YOUR_URL")
 *                             .build())
 *                         .build())
 *                     .build())
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ### With Max Urls Per Minute Crawl Rate
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.kendra.DataSource;
 * import com.pulumi.aws.kendra.DataSourceArgs;
 * import com.pulumi.aws.kendra.inputs.DataSourceConfigurationArgs;
 * import com.pulumi.aws.kendra.inputs.DataSourceConfigurationWebCrawlerConfigurationArgs;
 * import com.pulumi.aws.kendra.inputs.DataSourceConfigurationWebCrawlerConfigurationUrlsArgs;
 * import com.pulumi.aws.kendra.inputs.DataSourceConfigurationWebCrawlerConfigurationUrlsSeedUrlConfigurationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new DataSource("example", DataSourceArgs.builder()
 *             .indexId(aws_kendra_index.example().id())
 *             .type("WEBCRAWLER")
 *             .roleArn(aws_iam_role.example().arn())
 *             .configuration(DataSourceConfigurationArgs.builder()
 *                 .webCrawlerConfiguration(DataSourceConfigurationWebCrawlerConfigurationArgs.builder()
 *                     .maxUrlsPerMinuteCrawlRate(300)
 *                     .urls(DataSourceConfigurationWebCrawlerConfigurationUrlsArgs.builder()
 *                         .seedUrlConfiguration(DataSourceConfigurationWebCrawlerConfigurationUrlsSeedUrlConfigurationArgs.builder()
 *                             .seedUrls("REPLACE_WITH_YOUR_URL")
 *                             .build())
 *                         .build())
 *                     .build())
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ### With Proxy Configuration
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.kendra.DataSource;
 * import com.pulumi.aws.kendra.DataSourceArgs;
 * import com.pulumi.aws.kendra.inputs.DataSourceConfigurationArgs;
 * import com.pulumi.aws.kendra.inputs.DataSourceConfigurationWebCrawlerConfigurationArgs;
 * import com.pulumi.aws.kendra.inputs.DataSourceConfigurationWebCrawlerConfigurationProxyConfigurationArgs;
 * import com.pulumi.aws.kendra.inputs.DataSourceConfigurationWebCrawlerConfigurationUrlsArgs;
 * import com.pulumi.aws.kendra.inputs.DataSourceConfigurationWebCrawlerConfigurationUrlsSeedUrlConfigurationArgs;
 * import com.pulumi.resources.CustomResourceOptions;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new DataSource("example", DataSourceArgs.builder()
 *             .indexId(aws_kendra_index.example().id())
 *             .type("WEBCRAWLER")
 *             .roleArn(aws_iam_role.example().arn())
 *             .configuration(DataSourceConfigurationArgs.builder()
 *                 .webCrawlerConfiguration(DataSourceConfigurationWebCrawlerConfigurationArgs.builder()
 *                     .proxyConfiguration(DataSourceConfigurationWebCrawlerConfigurationProxyConfigurationArgs.builder()
 *                         .credentials(aws_secretsmanager_secret.example().arn())
 *                         .host("a.example.com")
 *                         .port("443")
 *                         .build())
 *                     .urls(DataSourceConfigurationWebCrawlerConfigurationUrlsArgs.builder()
 *                         .seedUrlConfiguration(DataSourceConfigurationWebCrawlerConfigurationUrlsSeedUrlConfigurationArgs.builder()
 *                             .seedUrls("REPLACE_WITH_YOUR_URL")
 *                             .build())
 *                         .build())
 *                     .build())
 *                 .build())
 *             .build(), CustomResourceOptions.builder()
 *                 .dependsOn(aws_secretsmanager_secret_version.example())
 *                 .build());
 *     }
 * }
 * ```
 * ### With URL Exclusion and Inclusion Patterns
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.kendra.DataSource;
 * import com.pulumi.aws.kendra.DataSourceArgs;
 * import com.pulumi.aws.kendra.inputs.DataSourceConfigurationArgs;
 * import com.pulumi.aws.kendra.inputs.DataSourceConfigurationWebCrawlerConfigurationArgs;
 * import com.pulumi.aws.kendra.inputs.DataSourceConfigurationWebCrawlerConfigurationUrlsArgs;
 * import com.pulumi.aws.kendra.inputs.DataSourceConfigurationWebCrawlerConfigurationUrlsSeedUrlConfigurationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new DataSource("example", DataSourceArgs.builder()
 *             .indexId(aws_kendra_index.example().id())
 *             .type("WEBCRAWLER")
 *             .roleArn(aws_iam_role.example().arn())
 *             .configuration(DataSourceConfigurationArgs.builder()
 *                 .webCrawlerConfiguration(DataSourceConfigurationWebCrawlerConfigurationArgs.builder()
 *                     .urlExclusionPatterns("example")
 *                     .urlInclusionPatterns("hello")
 *                     .urls(DataSourceConfigurationWebCrawlerConfigurationUrlsArgs.builder()
 *                         .seedUrlConfiguration(DataSourceConfigurationWebCrawlerConfigurationUrlsSeedUrlConfigurationArgs.builder()
 *                             .seedUrls("REPLACE_WITH_YOUR_URL")
 *                             .build())
 *                         .build())
 *                     .build())
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import Kendra Data Source using the unique identifiers of the data_source and index separated by a slash (`/`). For example:
 * ```sh
 *  $ pulumi import aws:kendra/dataSource:DataSource example 1045d08d-66ef-4882-b3ed-dfb7df183e90/b34dfdf7-1f2b-4704-9581-79e00296845f
 * ```
 *
 */
public class DataSource internal constructor(
    override val javaResource: com.pulumi.aws.kendra.DataSource,
) : KotlinCustomResource(javaResource, DataSourceMapper) {
    /**
     * ARN of the Data Source.
     */
    public val arn: Output<String>
        get() = javaResource.arn().applyValue({ args0 -> args0 })

    /**
     * A block with the configuration information to connect to your Data Source repository. You can't specify the `configuration` block when the `type` parameter is set to `CUSTOM`. Detailed below.
     */
    public val configuration: Output<DataSourceConfiguration>?
        get() = javaResource.configuration().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> dataSourceConfigurationToKotlin(args0) })
            }).orElse(null)
        })

    /**
     * The Unix timestamp of when the Data Source was created.
     */
    public val createdAt: Output<String>
        get() = javaResource.createdAt().applyValue({ args0 -> args0 })

    /**
     * A block with the configuration information for altering document metadata and content during the document ingestion process. For more information on how to create, modify and delete document metadata, or make other content alterations when you ingest documents into Amazon Kendra, see [Customizing document metadata during the ingestion process](https://docs.aws.amazon.com/kendra/latest/dg/custom-document-enrichment.html). Detailed below.
     */
    public val customDocumentEnrichmentConfiguration:
        Output<DataSourceCustomDocumentEnrichmentConfiguration>?
        get() = javaResource.customDocumentEnrichmentConfiguration().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    dataSourceCustomDocumentEnrichmentConfigurationToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * The unique identifiers of the Data Source.
     */
    public val dataSourceId: Output<String>
        get() = javaResource.dataSourceId().applyValue({ args0 -> args0 })

    /**
     * A description for the Data Source connector.
     */
    public val description: Output<String>?
        get() = javaResource.description().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * When the Status field value is `FAILED`, the ErrorMessage field contains a description of the error that caused the Data Source to fail.
     */
    public val errorMessage: Output<String>
        get() = javaResource.errorMessage().applyValue({ args0 -> args0 })

    /**
     * The identifier of the index for your Amazon Kendra data source.
     */
    public val indexId: Output<String>
        get() = javaResource.indexId().applyValue({ args0 -> args0 })

    /**
     * The code for a language. This allows you to support a language for all documents when creating the Data Source connector. English is supported by default. For more information on supported languages, including their codes, see [Adding documents in languages other than English](https://docs.aws.amazon.com/kendra/latest/dg/in-adding-languages.html).
     */
    public val languageCode: Output<String>
        get() = javaResource.languageCode().applyValue({ args0 -> args0 })

    /**
     * A name for your data source connector.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * The Amazon Resource Name (ARN) of a role with permission to access the data source connector. For more information, see [IAM roles for Amazon Kendra](https://docs.aws.amazon.com/kendra/latest/dg/iam-roles.html). You can't specify the `role_arn` parameter when the `type` parameter is set to `CUSTOM`. The `role_arn` parameter is required for all other data sources.
     */
    public val roleArn: Output<String>?
        get() = javaResource.roleArn().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Sets the frequency for Amazon Kendra to check the documents in your Data Source repository and update the index. If you don't set a schedule Amazon Kendra will not periodically update the index. You can call the `StartDataSourceSyncJob` API to update the index.
     */
    public val schedule: Output<String>?
        get() = javaResource.schedule().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The current status of the Data Source. When the status is `ACTIVE` the Data Source is ready to use. When the status is `FAILED`, the `error_message` field contains the reason that the Data Source failed.
     */
    public val status: Output<String>
        get() = javaResource.status().applyValue({ args0 -> args0 })

    /**
     * Key-value map of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
     */
    @Deprecated(
        message = """
  Please use `tags` instead.
  """,
    )
    public val tagsAll: Output<Map<String, String>>
        get() = javaResource.tagsAll().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.key.to(args0.value)
            }).toMap()
        })

    /**
     * The type of data source repository. For an updated list of values, refer to [Valid Values for Type](https://docs.aws.amazon.com/kendra/latest/dg/API_CreateDataSource.html#Kendra-CreateDataSource-request-Type).
     * The following arguments are optional:
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })

    /**
     * The Unix timestamp of when the Data Source was last updated.
     */
    public val updatedAt: Output<String>
        get() = javaResource.updatedAt().applyValue({ args0 -> args0 })
}

public object DataSourceMapper : ResourceMapper<DataSource> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.kendra.DataSource::class == javaResource::class

    override fun map(javaResource: Resource): DataSource = DataSource(
        javaResource as
            com.pulumi.aws.kendra.DataSource,
    )
}

/**
 * @see [DataSource].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [DataSource].
 */
public suspend fun dataSource(name: String, block: suspend DataSourceResourceBuilder.() -> Unit):
    DataSource {
    val builder = DataSourceResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [DataSource].
 * @param name The _unique_ name of the resulting resource.
 */
public fun dataSource(name: String): DataSource {
    val builder = DataSourceResourceBuilder()
    builder.name(name)
    return builder.build()
}
