@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.kendra.kotlin

import com.pulumi.aws.kendra.DataSourceArgs.builder
import com.pulumi.aws.kendra.kotlin.inputs.DataSourceConfigurationArgs
import com.pulumi.aws.kendra.kotlin.inputs.DataSourceConfigurationArgsBuilder
import com.pulumi.aws.kendra.kotlin.inputs.DataSourceCustomDocumentEnrichmentConfigurationArgs
import com.pulumi.aws.kendra.kotlin.inputs.DataSourceCustomDocumentEnrichmentConfigurationArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Resource for managing an AWS Kendra Data Source.
 * ## Example Usage
 * ### Basic Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.kendra.DataSource;
 * import com.pulumi.aws.kendra.DataSourceArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new DataSource("example", DataSourceArgs.builder()
 *             .indexId(aws_kendra_index.example().id())
 *             .description("example")
 *             .languageCode("en")
 *             .type("CUSTOM")
 *             .tags(Map.of("hello", "world"))
 *             .build());
 *     }
 * }
 * ```
 * ### With Schedule
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.kendra.DataSource;
 * import com.pulumi.aws.kendra.DataSourceArgs;
 * import com.pulumi.aws.kendra.inputs.DataSourceConfigurationArgs;
 * import com.pulumi.aws.kendra.inputs.DataSourceConfigurationS3ConfigurationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new DataSource("example", DataSourceArgs.builder()
 *             .indexId(aws_kendra_index.example().id())
 *             .type("S3")
 *             .roleArn(aws_iam_role.example().arn())
 *             .schedule("cron(9 10 1 * ? *)")
 *             .configuration(DataSourceConfigurationArgs.builder()
 *                 .s3Configuration(DataSourceConfigurationS3ConfigurationArgs.builder()
 *                     .bucketName(aws_s3_bucket.example().id())
 *                     .build())
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ### With Access Control List
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.kendra.DataSource;
 * import com.pulumi.aws.kendra.DataSourceArgs;
 * import com.pulumi.aws.kendra.inputs.DataSourceConfigurationArgs;
 * import com.pulumi.aws.kendra.inputs.DataSourceConfigurationS3ConfigurationArgs;
 * import com.pulumi.aws.kendra.inputs.DataSourceConfigurationS3ConfigurationAccessControlListConfigurationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new DataSource("example", DataSourceArgs.builder()
 *             .indexId(aws_kendra_index.example().id())
 *             .type("S3")
 *             .roleArn(aws_iam_role.example().arn())
 *             .configuration(DataSourceConfigurationArgs.builder()
 *                 .s3Configuration(DataSourceConfigurationS3ConfigurationArgs.builder()
 *                     .bucketName(aws_s3_bucket.example().id())
 *                     .accessControlListConfiguration(DataSourceConfigurationS3ConfigurationAccessControlListConfigurationArgs.builder()
 *                         .keyPath(String.format("s3://%s/path-1", aws_s3_bucket.example().id()))
 *                         .build())
 *                     .build())
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ### With Documents Metadata Configuration
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.kendra.DataSource;
 * import com.pulumi.aws.kendra.DataSourceArgs;
 * import com.pulumi.aws.kendra.inputs.DataSourceConfigurationArgs;
 * import com.pulumi.aws.kendra.inputs.DataSourceConfigurationS3ConfigurationArgs;
 * import com.pulumi.aws.kendra.inputs.DataSourceConfigurationS3ConfigurationDocumentsMetadataConfigurationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new DataSource("example", DataSourceArgs.builder()
 *             .indexId(aws_kendra_index.example().id())
 *             .type("S3")
 *             .roleArn(aws_iam_role.example().arn())
 *             .configuration(DataSourceConfigurationArgs.builder()
 *                 .s3Configuration(DataSourceConfigurationS3ConfigurationArgs.builder()
 *                     .bucketName(aws_s3_bucket.example().id())
 *                     .exclusionPatterns("example")
 *                     .inclusionPatterns("hello")
 *                     .inclusionPrefixes("world")
 *                     .documentsMetadataConfiguration(DataSourceConfigurationS3ConfigurationDocumentsMetadataConfigurationArgs.builder()
 *                         .s3Prefix("example")
 *                         .build())
 *                     .build())
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ### With Seed URLs
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.kendra.DataSource;
 * import com.pulumi.aws.kendra.DataSourceArgs;
 * import com.pulumi.aws.kendra.inputs.DataSourceConfigurationArgs;
 * import com.pulumi.aws.kendra.inputs.DataSourceConfigurationWebCrawlerConfigurationArgs;
 * import com.pulumi.aws.kendra.inputs.DataSourceConfigurationWebCrawlerConfigurationUrlsArgs;
 * import com.pulumi.aws.kendra.inputs.DataSourceConfigurationWebCrawlerConfigurationUrlsSeedUrlConfigurationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new DataSource("example", DataSourceArgs.builder()
 *             .indexId(aws_kendra_index.example().id())
 *             .type("WEBCRAWLER")
 *             .roleArn(aws_iam_role.example().arn())
 *             .configuration(DataSourceConfigurationArgs.builder()
 *                 .webCrawlerConfiguration(DataSourceConfigurationWebCrawlerConfigurationArgs.builder()
 *                     .urls(DataSourceConfigurationWebCrawlerConfigurationUrlsArgs.builder()
 *                         .seedUrlConfiguration(DataSourceConfigurationWebCrawlerConfigurationUrlsSeedUrlConfigurationArgs.builder()
 *                             .seedUrls("REPLACE_WITH_YOUR_URL")
 *                             .build())
 *                         .build())
 *                     .build())
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ### With Site Maps
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.kendra.DataSource;
 * import com.pulumi.aws.kendra.DataSourceArgs;
 * import com.pulumi.aws.kendra.inputs.DataSourceConfigurationArgs;
 * import com.pulumi.aws.kendra.inputs.DataSourceConfigurationWebCrawlerConfigurationArgs;
 * import com.pulumi.aws.kendra.inputs.DataSourceConfigurationWebCrawlerConfigurationUrlsArgs;
 * import com.pulumi.aws.kendra.inputs.DataSourceConfigurationWebCrawlerConfigurationUrlsSiteMapsConfigurationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new DataSource("example", DataSourceArgs.builder()
 *             .indexId(aws_kendra_index.example().id())
 *             .type("WEBCRAWLER")
 *             .roleArn(aws_iam_role.example().arn())
 *             .configuration(DataSourceConfigurationArgs.builder()
 *                 .webCrawlerConfiguration(DataSourceConfigurationWebCrawlerConfigurationArgs.builder()
 *                     .urls(DataSourceConfigurationWebCrawlerConfigurationUrlsArgs.builder()
 *                         .siteMapsConfiguration(DataSourceConfigurationWebCrawlerConfigurationUrlsSiteMapsConfigurationArgs.builder()
 *                             .siteMaps("REPLACE_WITH_YOUR_URL")
 *                             .build())
 *                         .build())
 *                     .build())
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ### With Web Crawler Mode
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.kendra.DataSource;
 * import com.pulumi.aws.kendra.DataSourceArgs;
 * import com.pulumi.aws.kendra.inputs.DataSourceConfigurationArgs;
 * import com.pulumi.aws.kendra.inputs.DataSourceConfigurationWebCrawlerConfigurationArgs;
 * import com.pulumi.aws.kendra.inputs.DataSourceConfigurationWebCrawlerConfigurationUrlsArgs;
 * import com.pulumi.aws.kendra.inputs.DataSourceConfigurationWebCrawlerConfigurationUrlsSeedUrlConfigurationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new DataSource("example", DataSourceArgs.builder()
 *             .indexId(aws_kendra_index.example().id())
 *             .type("WEBCRAWLER")
 *             .roleArn(aws_iam_role.example().arn())
 *             .configuration(DataSourceConfigurationArgs.builder()
 *                 .webCrawlerConfiguration(DataSourceConfigurationWebCrawlerConfigurationArgs.builder()
 *                     .urls(DataSourceConfigurationWebCrawlerConfigurationUrlsArgs.builder()
 *                         .seedUrlConfiguration(DataSourceConfigurationWebCrawlerConfigurationUrlsSeedUrlConfigurationArgs.builder()
 *                             .webCrawlerMode("SUBDOMAINS")
 *                             .seedUrls("REPLACE_WITH_YOUR_URL")
 *                             .build())
 *                         .build())
 *                     .build())
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ### With Authentication Configuration
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.kendra.DataSource;
 * import com.pulumi.aws.kendra.DataSourceArgs;
 * import com.pulumi.aws.kendra.inputs.DataSourceConfigurationArgs;
 * import com.pulumi.aws.kendra.inputs.DataSourceConfigurationWebCrawlerConfigurationArgs;
 * import com.pulumi.aws.kendra.inputs.DataSourceConfigurationWebCrawlerConfigurationAuthenticationConfigurationArgs;
 * import com.pulumi.aws.kendra.inputs.DataSourceConfigurationWebCrawlerConfigurationUrlsArgs;
 * import com.pulumi.aws.kendra.inputs.DataSourceConfigurationWebCrawlerConfigurationUrlsSeedUrlConfigurationArgs;
 * import com.pulumi.resources.CustomResourceOptions;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new DataSource("example", DataSourceArgs.builder()
 *             .indexId(aws_kendra_index.example().id())
 *             .type("WEBCRAWLER")
 *             .roleArn(aws_iam_role.example().arn())
 *             .configuration(DataSourceConfigurationArgs.builder()
 *                 .webCrawlerConfiguration(DataSourceConfigurationWebCrawlerConfigurationArgs.builder()
 *                     .authenticationConfiguration(DataSourceConfigurationWebCrawlerConfigurationAuthenticationConfigurationArgs.builder()
 *                         .basicAuthentications(DataSourceConfigurationWebCrawlerConfigurationAuthenticationConfigurationBasicAuthenticationArgs.builder()
 *                             .credentials(aws_secretsmanager_secret.example().arn())
 *                             .host("a.example.com")
 *                             .port("443")
 *                             .build())
 *                         .build())
 *                     .urls(DataSourceConfigurationWebCrawlerConfigurationUrlsArgs.builder()
 *                         .seedUrlConfiguration(DataSourceConfigurationWebCrawlerConfigurationUrlsSeedUrlConfigurationArgs.builder()
 *                             .seedUrls("REPLACE_WITH_YOUR_URL")
 *                             .build())
 *                         .build())
 *                     .build())
 *                 .build())
 *             .build(), CustomResourceOptions.builder()
 *                 .dependsOn(aws_secretsmanager_secret_version.example())
 *                 .build());
 *     }
 * }
 * ```
 * ### With Crawl Depth
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.kendra.DataSource;
 * import com.pulumi.aws.kendra.DataSourceArgs;
 * import com.pulumi.aws.kendra.inputs.DataSourceConfigurationArgs;
 * import com.pulumi.aws.kendra.inputs.DataSourceConfigurationWebCrawlerConfigurationArgs;
 * import com.pulumi.aws.kendra.inputs.DataSourceConfigurationWebCrawlerConfigurationUrlsArgs;
 * import com.pulumi.aws.kendra.inputs.DataSourceConfigurationWebCrawlerConfigurationUrlsSeedUrlConfigurationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new DataSource("example", DataSourceArgs.builder()
 *             .indexId(aws_kendra_index.example().id())
 *             .type("WEBCRAWLER")
 *             .roleArn(aws_iam_role.example().arn())
 *             .configuration(DataSourceConfigurationArgs.builder()
 *                 .webCrawlerConfiguration(DataSourceConfigurationWebCrawlerConfigurationArgs.builder()
 *                     .crawlDepth(3)
 *                     .urls(DataSourceConfigurationWebCrawlerConfigurationUrlsArgs.builder()
 *                         .seedUrlConfiguration(DataSourceConfigurationWebCrawlerConfigurationUrlsSeedUrlConfigurationArgs.builder()
 *                             .seedUrls("REPLACE_WITH_YOUR_URL")
 *                             .build())
 *                         .build())
 *                     .build())
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ### With Max Links Per Page
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.kendra.DataSource;
 * import com.pulumi.aws.kendra.DataSourceArgs;
 * import com.pulumi.aws.kendra.inputs.DataSourceConfigurationArgs;
 * import com.pulumi.aws.kendra.inputs.DataSourceConfigurationWebCrawlerConfigurationArgs;
 * import com.pulumi.aws.kendra.inputs.DataSourceConfigurationWebCrawlerConfigurationUrlsArgs;
 * import com.pulumi.aws.kendra.inputs.DataSourceConfigurationWebCrawlerConfigurationUrlsSeedUrlConfigurationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new DataSource("example", DataSourceArgs.builder()
 *             .indexId(aws_kendra_index.example().id())
 *             .type("WEBCRAWLER")
 *             .roleArn(aws_iam_role.example().arn())
 *             .configuration(DataSourceConfigurationArgs.builder()
 *                 .webCrawlerConfiguration(DataSourceConfigurationWebCrawlerConfigurationArgs.builder()
 *                     .maxLinksPerPage(100)
 *                     .urls(DataSourceConfigurationWebCrawlerConfigurationUrlsArgs.builder()
 *                         .seedUrlConfiguration(DataSourceConfigurationWebCrawlerConfigurationUrlsSeedUrlConfigurationArgs.builder()
 *                             .seedUrls("REPLACE_WITH_YOUR_URL")
 *                             .build())
 *                         .build())
 *                     .build())
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ### With Max Urls Per Minute Crawl Rate
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.kendra.DataSource;
 * import com.pulumi.aws.kendra.DataSourceArgs;
 * import com.pulumi.aws.kendra.inputs.DataSourceConfigurationArgs;
 * import com.pulumi.aws.kendra.inputs.DataSourceConfigurationWebCrawlerConfigurationArgs;
 * import com.pulumi.aws.kendra.inputs.DataSourceConfigurationWebCrawlerConfigurationUrlsArgs;
 * import com.pulumi.aws.kendra.inputs.DataSourceConfigurationWebCrawlerConfigurationUrlsSeedUrlConfigurationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new DataSource("example", DataSourceArgs.builder()
 *             .indexId(aws_kendra_index.example().id())
 *             .type("WEBCRAWLER")
 *             .roleArn(aws_iam_role.example().arn())
 *             .configuration(DataSourceConfigurationArgs.builder()
 *                 .webCrawlerConfiguration(DataSourceConfigurationWebCrawlerConfigurationArgs.builder()
 *                     .maxUrlsPerMinuteCrawlRate(300)
 *                     .urls(DataSourceConfigurationWebCrawlerConfigurationUrlsArgs.builder()
 *                         .seedUrlConfiguration(DataSourceConfigurationWebCrawlerConfigurationUrlsSeedUrlConfigurationArgs.builder()
 *                             .seedUrls("REPLACE_WITH_YOUR_URL")
 *                             .build())
 *                         .build())
 *                     .build())
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ### With Proxy Configuration
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.kendra.DataSource;
 * import com.pulumi.aws.kendra.DataSourceArgs;
 * import com.pulumi.aws.kendra.inputs.DataSourceConfigurationArgs;
 * import com.pulumi.aws.kendra.inputs.DataSourceConfigurationWebCrawlerConfigurationArgs;
 * import com.pulumi.aws.kendra.inputs.DataSourceConfigurationWebCrawlerConfigurationProxyConfigurationArgs;
 * import com.pulumi.aws.kendra.inputs.DataSourceConfigurationWebCrawlerConfigurationUrlsArgs;
 * import com.pulumi.aws.kendra.inputs.DataSourceConfigurationWebCrawlerConfigurationUrlsSeedUrlConfigurationArgs;
 * import com.pulumi.resources.CustomResourceOptions;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new DataSource("example", DataSourceArgs.builder()
 *             .indexId(aws_kendra_index.example().id())
 *             .type("WEBCRAWLER")
 *             .roleArn(aws_iam_role.example().arn())
 *             .configuration(DataSourceConfigurationArgs.builder()
 *                 .webCrawlerConfiguration(DataSourceConfigurationWebCrawlerConfigurationArgs.builder()
 *                     .proxyConfiguration(DataSourceConfigurationWebCrawlerConfigurationProxyConfigurationArgs.builder()
 *                         .credentials(aws_secretsmanager_secret.example().arn())
 *                         .host("a.example.com")
 *                         .port("443")
 *                         .build())
 *                     .urls(DataSourceConfigurationWebCrawlerConfigurationUrlsArgs.builder()
 *                         .seedUrlConfiguration(DataSourceConfigurationWebCrawlerConfigurationUrlsSeedUrlConfigurationArgs.builder()
 *                             .seedUrls("REPLACE_WITH_YOUR_URL")
 *                             .build())
 *                         .build())
 *                     .build())
 *                 .build())
 *             .build(), CustomResourceOptions.builder()
 *                 .dependsOn(aws_secretsmanager_secret_version.example())
 *                 .build());
 *     }
 * }
 * ```
 * ### With URL Exclusion and Inclusion Patterns
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.kendra.DataSource;
 * import com.pulumi.aws.kendra.DataSourceArgs;
 * import com.pulumi.aws.kendra.inputs.DataSourceConfigurationArgs;
 * import com.pulumi.aws.kendra.inputs.DataSourceConfigurationWebCrawlerConfigurationArgs;
 * import com.pulumi.aws.kendra.inputs.DataSourceConfigurationWebCrawlerConfigurationUrlsArgs;
 * import com.pulumi.aws.kendra.inputs.DataSourceConfigurationWebCrawlerConfigurationUrlsSeedUrlConfigurationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new DataSource("example", DataSourceArgs.builder()
 *             .indexId(aws_kendra_index.example().id())
 *             .type("WEBCRAWLER")
 *             .roleArn(aws_iam_role.example().arn())
 *             .configuration(DataSourceConfigurationArgs.builder()
 *                 .webCrawlerConfiguration(DataSourceConfigurationWebCrawlerConfigurationArgs.builder()
 *                     .urlExclusionPatterns("example")
 *                     .urlInclusionPatterns("hello")
 *                     .urls(DataSourceConfigurationWebCrawlerConfigurationUrlsArgs.builder()
 *                         .seedUrlConfiguration(DataSourceConfigurationWebCrawlerConfigurationUrlsSeedUrlConfigurationArgs.builder()
 *                             .seedUrls("REPLACE_WITH_YOUR_URL")
 *                             .build())
 *                         .build())
 *                     .build())
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import Kendra Data Source using the unique identifiers of the data_source and index separated by a slash (`/`). For example:
 * ```sh
 *  $ pulumi import aws:kendra/dataSource:DataSource example 1045d08d-66ef-4882-b3ed-dfb7df183e90/b34dfdf7-1f2b-4704-9581-79e00296845f
 * ```
 * @property configuration A block with the configuration information to connect to your Data Source repository. You can't specify the `configuration` block when the `type` parameter is set to `CUSTOM`. Detailed below.
 * @property customDocumentEnrichmentConfiguration A block with the configuration information for altering document metadata and content during the document ingestion process. For more information on how to create, modify and delete document metadata, or make other content alterations when you ingest documents into Amazon Kendra, see [Customizing document metadata during the ingestion process](https://docs.aws.amazon.com/kendra/latest/dg/custom-document-enrichment.html). Detailed below.
 * @property description A description for the Data Source connector.
 * @property indexId The identifier of the index for your Amazon Kendra data source.
 * @property languageCode The code for a language. This allows you to support a language for all documents when creating the Data Source connector. English is supported by default. For more information on supported languages, including their codes, see [Adding documents in languages other than English](https://docs.aws.amazon.com/kendra/latest/dg/in-adding-languages.html).
 * @property name A name for your data source connector.
 * @property roleArn The Amazon Resource Name (ARN) of a role with permission to access the data source connector. For more information, see [IAM roles for Amazon Kendra](https://docs.aws.amazon.com/kendra/latest/dg/iam-roles.html). You can't specify the `role_arn` parameter when the `type` parameter is set to `CUSTOM`. The `role_arn` parameter is required for all other data sources.
 * @property schedule Sets the frequency for Amazon Kendra to check the documents in your Data Source repository and update the index. If you don't set a schedule Amazon Kendra will not periodically update the index. You can call the `StartDataSourceSyncJob` API to update the index.
 * @property tags Key-value map of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
 * @property type The type of data source repository. For an updated list of values, refer to [Valid Values for Type](https://docs.aws.amazon.com/kendra/latest/dg/API_CreateDataSource.html#Kendra-CreateDataSource-request-Type).
 * The following arguments are optional:
 */
public data class DataSourceArgs(
    public val configuration: Output<DataSourceConfigurationArgs>? = null,
    public val customDocumentEnrichmentConfiguration:
    Output<DataSourceCustomDocumentEnrichmentConfigurationArgs>? = null,
    public val description: Output<String>? = null,
    public val indexId: Output<String>? = null,
    public val languageCode: Output<String>? = null,
    public val name: Output<String>? = null,
    public val roleArn: Output<String>? = null,
    public val schedule: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
    public val type: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.kendra.DataSourceArgs> {
    override fun toJava(): com.pulumi.aws.kendra.DataSourceArgs =
        com.pulumi.aws.kendra.DataSourceArgs.builder()
            .configuration(configuration?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .customDocumentEnrichmentConfiguration(
                customDocumentEnrichmentConfiguration?.applyValue({ args0 ->
                    args0.let({ args0 -> args0.toJava() })
                }),
            )
            .description(description?.applyValue({ args0 -> args0 }))
            .indexId(indexId?.applyValue({ args0 -> args0 }))
            .languageCode(languageCode?.applyValue({ args0 -> args0 }))
            .name(name?.applyValue({ args0 -> args0 }))
            .roleArn(roleArn?.applyValue({ args0 -> args0 }))
            .schedule(schedule?.applyValue({ args0 -> args0 }))
            .tags(tags?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .type(type?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [DataSourceArgs].
 */
@PulumiTagMarker
public class DataSourceArgsBuilder internal constructor() {
    private var configuration: Output<DataSourceConfigurationArgs>? = null

    private var customDocumentEnrichmentConfiguration:
        Output<DataSourceCustomDocumentEnrichmentConfigurationArgs>? = null

    private var description: Output<String>? = null

    private var indexId: Output<String>? = null

    private var languageCode: Output<String>? = null

    private var name: Output<String>? = null

    private var roleArn: Output<String>? = null

    private var schedule: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    private var type: Output<String>? = null

    /**
     * @param value A block with the configuration information to connect to your Data Source repository. You can't specify the `configuration` block when the `type` parameter is set to `CUSTOM`. Detailed below.
     */
    @JvmName("wvaytvooribkljmr")
    public suspend fun configuration(`value`: Output<DataSourceConfigurationArgs>) {
        this.configuration = value
    }

    /**
     * @param value A block with the configuration information for altering document metadata and content during the document ingestion process. For more information on how to create, modify and delete document metadata, or make other content alterations when you ingest documents into Amazon Kendra, see [Customizing document metadata during the ingestion process](https://docs.aws.amazon.com/kendra/latest/dg/custom-document-enrichment.html). Detailed below.
     */
    @JvmName("copybxwqunyhkcxs")
    public suspend
    fun customDocumentEnrichmentConfiguration(`value`: Output<DataSourceCustomDocumentEnrichmentConfigurationArgs>) {
        this.customDocumentEnrichmentConfiguration = value
    }

    /**
     * @param value A description for the Data Source connector.
     */
    @JvmName("ewewnscmcaplsyrb")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value The identifier of the index for your Amazon Kendra data source.
     */
    @JvmName("chfuligjltclgdxq")
    public suspend fun indexId(`value`: Output<String>) {
        this.indexId = value
    }

    /**
     * @param value The code for a language. This allows you to support a language for all documents when creating the Data Source connector. English is supported by default. For more information on supported languages, including their codes, see [Adding documents in languages other than English](https://docs.aws.amazon.com/kendra/latest/dg/in-adding-languages.html).
     */
    @JvmName("rrudfgxmjfsydqkb")
    public suspend fun languageCode(`value`: Output<String>) {
        this.languageCode = value
    }

    /**
     * @param value A name for your data source connector.
     */
    @JvmName("ofvovotebajbfghq")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value The Amazon Resource Name (ARN) of a role with permission to access the data source connector. For more information, see [IAM roles for Amazon Kendra](https://docs.aws.amazon.com/kendra/latest/dg/iam-roles.html). You can't specify the `role_arn` parameter when the `type` parameter is set to `CUSTOM`. The `role_arn` parameter is required for all other data sources.
     */
    @JvmName("smfraxctxnwtftox")
    public suspend fun roleArn(`value`: Output<String>) {
        this.roleArn = value
    }

    /**
     * @param value Sets the frequency for Amazon Kendra to check the documents in your Data Source repository and update the index. If you don't set a schedule Amazon Kendra will not periodically update the index. You can call the `StartDataSourceSyncJob` API to update the index.
     */
    @JvmName("vjtibgarvjgncyva")
    public suspend fun schedule(`value`: Output<String>) {
        this.schedule = value
    }

    /**
     * @param value Key-value map of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("pubahcjtgqfbtqyp")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value The type of data source repository. For an updated list of values, refer to [Valid Values for Type](https://docs.aws.amazon.com/kendra/latest/dg/API_CreateDataSource.html#Kendra-CreateDataSource-request-Type).
     * The following arguments are optional:
     */
    @JvmName("esrufjfsaofivljl")
    public suspend fun type(`value`: Output<String>) {
        this.type = value
    }

    /**
     * @param value A block with the configuration information to connect to your Data Source repository. You can't specify the `configuration` block when the `type` parameter is set to `CUSTOM`. Detailed below.
     */
    @JvmName("nfmoltcujqslsjet")
    public suspend fun configuration(`value`: DataSourceConfigurationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.configuration = mapped
    }

    /**
     * @param argument A block with the configuration information to connect to your Data Source repository. You can't specify the `configuration` block when the `type` parameter is set to `CUSTOM`. Detailed below.
     */
    @JvmName("xffvruppvegmvxeg")
    public suspend
    fun configuration(argument: suspend DataSourceConfigurationArgsBuilder.() -> Unit) {
        val toBeMapped = DataSourceConfigurationArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.configuration = mapped
    }

    /**
     * @param value A block with the configuration information for altering document metadata and content during the document ingestion process. For more information on how to create, modify and delete document metadata, or make other content alterations when you ingest documents into Amazon Kendra, see [Customizing document metadata during the ingestion process](https://docs.aws.amazon.com/kendra/latest/dg/custom-document-enrichment.html). Detailed below.
     */
    @JvmName("xcmmajtgtofoqfps")
    public suspend
    fun customDocumentEnrichmentConfiguration(`value`: DataSourceCustomDocumentEnrichmentConfigurationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.customDocumentEnrichmentConfiguration = mapped
    }

    /**
     * @param argument A block with the configuration information for altering document metadata and content during the document ingestion process. For more information on how to create, modify and delete document metadata, or make other content alterations when you ingest documents into Amazon Kendra, see [Customizing document metadata during the ingestion process](https://docs.aws.amazon.com/kendra/latest/dg/custom-document-enrichment.html). Detailed below.
     */
    @JvmName("icpdrsnfajljgqmw")
    public suspend
    fun customDocumentEnrichmentConfiguration(argument: suspend DataSourceCustomDocumentEnrichmentConfigurationArgsBuilder.() -> Unit) {
        val toBeMapped = DataSourceCustomDocumentEnrichmentConfigurationArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.customDocumentEnrichmentConfiguration = mapped
    }

    /**
     * @param value A description for the Data Source connector.
     */
    @JvmName("aclrqjtoujbsdydm")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value The identifier of the index for your Amazon Kendra data source.
     */
    @JvmName("djrmsaxkyqluugra")
    public suspend fun indexId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.indexId = mapped
    }

    /**
     * @param value The code for a language. This allows you to support a language for all documents when creating the Data Source connector. English is supported by default. For more information on supported languages, including their codes, see [Adding documents in languages other than English](https://docs.aws.amazon.com/kendra/latest/dg/in-adding-languages.html).
     */
    @JvmName("xerkrufqpubceuod")
    public suspend fun languageCode(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.languageCode = mapped
    }

    /**
     * @param value A name for your data source connector.
     */
    @JvmName("bfkxaoivdsssepjd")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value The Amazon Resource Name (ARN) of a role with permission to access the data source connector. For more information, see [IAM roles for Amazon Kendra](https://docs.aws.amazon.com/kendra/latest/dg/iam-roles.html). You can't specify the `role_arn` parameter when the `type` parameter is set to `CUSTOM`. The `role_arn` parameter is required for all other data sources.
     */
    @JvmName("vedgbknhkpddyaay")
    public suspend fun roleArn(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.roleArn = mapped
    }

    /**
     * @param value Sets the frequency for Amazon Kendra to check the documents in your Data Source repository and update the index. If you don't set a schedule Amazon Kendra will not periodically update the index. You can call the `StartDataSourceSyncJob` API to update the index.
     */
    @JvmName("exnnjxgjcwrqiomp")
    public suspend fun schedule(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.schedule = mapped
    }

    /**
     * @param value Key-value map of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("ucxxkfntomuskfcl")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Key-value map of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("wtfdhydflbxfgsqq")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param value The type of data source repository. For an updated list of values, refer to [Valid Values for Type](https://docs.aws.amazon.com/kendra/latest/dg/API_CreateDataSource.html#Kendra-CreateDataSource-request-Type).
     * The following arguments are optional:
     */
    @JvmName("bkpxlnwwlhdpugxs")
    public suspend fun type(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.type = mapped
    }

    internal fun build(): DataSourceArgs = DataSourceArgs(
        configuration = configuration,
        customDocumentEnrichmentConfiguration = customDocumentEnrichmentConfiguration,
        description = description,
        indexId = indexId,
        languageCode = languageCode,
        name = name,
        roleArn = roleArn,
        schedule = schedule,
        tags = tags,
        type = type,
    )
}
