@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.kendra.kotlin

import com.pulumi.aws.kendra.ExperienceArgs.builder
import com.pulumi.aws.kendra.kotlin.inputs.ExperienceConfigurationArgs
import com.pulumi.aws.kendra.kotlin.inputs.ExperienceConfigurationArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Resource for managing an AWS Kendra Experience.
 * ## Example Usage
 * ### Basic Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.kendra.Experience;
 * import com.pulumi.aws.kendra.ExperienceArgs;
 * import com.pulumi.aws.kendra.inputs.ExperienceConfigurationArgs;
 * import com.pulumi.aws.kendra.inputs.ExperienceConfigurationContentSourceConfigurationArgs;
 * import com.pulumi.aws.kendra.inputs.ExperienceConfigurationUserIdentityConfigurationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new Experience("example", ExperienceArgs.builder()
 *             .indexId(aws_kendra_index.example().id())
 *             .description("My Kendra Experience")
 *             .roleArn(aws_iam_role.example().arn())
 *             .configuration(ExperienceConfigurationArgs.builder()
 *                 .contentSourceConfiguration(ExperienceConfigurationContentSourceConfigurationArgs.builder()
 *                     .directPutContent(true)
 *                     .faqIds(aws_kendra_faq.example().faq_id())
 *                     .build())
 *                 .userIdentityConfiguration(ExperienceConfigurationUserIdentityConfigurationArgs.builder()
 *                     .identityAttributeName("12345ec453-1546651e-79c4-4554-91fa-00b43ccfa245")
 *                     .build())
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import Kendra Experience using the unique identifiers of the experience and index separated by a slash (`/`). For example:
 * ```sh
 *  $ pulumi import aws:kendra/experience:Experience example 1045d08d-66ef-4882-b3ed-dfb7df183e90/b34dfdf7-1f2b-4704-9581-79e00296845f
 * ```
 * @property configuration Configuration information for your Amazon Kendra experience. The provider will only perform drift detection of its value when present in a configuration. Detailed below.
 * @property description A description for your Amazon Kendra experience.
 * @property indexId The identifier of the index for your Amazon Kendra experience.
 * @property name A name for your Amazon Kendra experience.
 * @property roleArn The Amazon Resource Name (ARN) of a role with permission to access `Query API`, `QuerySuggestions API`, `SubmitFeedback API`, and `AWS SSO` that stores your user and group information. For more information, see [IAM roles for Amazon Kendra](https://docs.aws.amazon.com/kendra/latest/dg/iam-roles.html).
 * The following arguments are optional:
 */
public data class ExperienceArgs(
    public val configuration: Output<ExperienceConfigurationArgs>? = null,
    public val description: Output<String>? = null,
    public val indexId: Output<String>? = null,
    public val name: Output<String>? = null,
    public val roleArn: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.kendra.ExperienceArgs> {
    override fun toJava(): com.pulumi.aws.kendra.ExperienceArgs =
        com.pulumi.aws.kendra.ExperienceArgs.builder()
            .configuration(configuration?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .description(description?.applyValue({ args0 -> args0 }))
            .indexId(indexId?.applyValue({ args0 -> args0 }))
            .name(name?.applyValue({ args0 -> args0 }))
            .roleArn(roleArn?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ExperienceArgs].
 */
@PulumiTagMarker
public class ExperienceArgsBuilder internal constructor() {
    private var configuration: Output<ExperienceConfigurationArgs>? = null

    private var description: Output<String>? = null

    private var indexId: Output<String>? = null

    private var name: Output<String>? = null

    private var roleArn: Output<String>? = null

    /**
     * @param value Configuration information for your Amazon Kendra experience. The provider will only perform drift detection of its value when present in a configuration. Detailed below.
     */
    @JvmName("wpxptcebkrombvlp")
    public suspend fun configuration(`value`: Output<ExperienceConfigurationArgs>) {
        this.configuration = value
    }

    /**
     * @param value A description for your Amazon Kendra experience.
     */
    @JvmName("wphgrahbqasyrcnw")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value The identifier of the index for your Amazon Kendra experience.
     */
    @JvmName("yifvtgxuakukrtvf")
    public suspend fun indexId(`value`: Output<String>) {
        this.indexId = value
    }

    /**
     * @param value A name for your Amazon Kendra experience.
     */
    @JvmName("kxxvwjeuofkjjbob")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value The Amazon Resource Name (ARN) of a role with permission to access `Query API`, `QuerySuggestions API`, `SubmitFeedback API`, and `AWS SSO` that stores your user and group information. For more information, see [IAM roles for Amazon Kendra](https://docs.aws.amazon.com/kendra/latest/dg/iam-roles.html).
     * The following arguments are optional:
     */
    @JvmName("xqgxcfcljpiusllj")
    public suspend fun roleArn(`value`: Output<String>) {
        this.roleArn = value
    }

    /**
     * @param value Configuration information for your Amazon Kendra experience. The provider will only perform drift detection of its value when present in a configuration. Detailed below.
     */
    @JvmName("onconubwjpgxdhst")
    public suspend fun configuration(`value`: ExperienceConfigurationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.configuration = mapped
    }

    /**
     * @param argument Configuration information for your Amazon Kendra experience. The provider will only perform drift detection of its value when present in a configuration. Detailed below.
     */
    @JvmName("nvvwgvkewaveaukb")
    public suspend
    fun configuration(argument: suspend ExperienceConfigurationArgsBuilder.() -> Unit) {
        val toBeMapped = ExperienceConfigurationArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.configuration = mapped
    }

    /**
     * @param value A description for your Amazon Kendra experience.
     */
    @JvmName("wtowlsskndsrnmkr")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value The identifier of the index for your Amazon Kendra experience.
     */
    @JvmName("ywmifjiqgfxbbkce")
    public suspend fun indexId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.indexId = mapped
    }

    /**
     * @param value A name for your Amazon Kendra experience.
     */
    @JvmName("lgbydgvttuepmqur")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value The Amazon Resource Name (ARN) of a role with permission to access `Query API`, `QuerySuggestions API`, `SubmitFeedback API`, and `AWS SSO` that stores your user and group information. For more information, see [IAM roles for Amazon Kendra](https://docs.aws.amazon.com/kendra/latest/dg/iam-roles.html).
     * The following arguments are optional:
     */
    @JvmName("nfogrhfhdgaxcusw")
    public suspend fun roleArn(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.roleArn = mapped
    }

    internal fun build(): ExperienceArgs = ExperienceArgs(
        configuration = configuration,
        description = description,
        indexId = indexId,
        name = name,
        roleArn = roleArn,
    )
}
