@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.kendra.kotlin

import com.pulumi.aws.kendra.kotlin.outputs.FaqS3Path
import com.pulumi.aws.kendra.kotlin.outputs.FaqS3Path.Companion.toKotlin
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map

/**
 * Builder for [Faq].
 */
@PulumiTagMarker
public class FaqResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: FaqArgs = FaqArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend FaqArgsBuilder.() -> Unit) {
        val builder = FaqArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): Faq {
        val builtJavaResource = com.pulumi.aws.kendra.Faq(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return Faq(builtJavaResource)
    }
}

/**
 * Resource for managing an AWS Kendra FAQ.
 * ## Example Usage
 * ### Basic
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.kendra.Faq;
 * import com.pulumi.aws.kendra.FaqArgs;
 * import com.pulumi.aws.kendra.inputs.FaqS3PathArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new Faq("example", FaqArgs.builder()
 *             .indexId(aws_kendra_index.example().id())
 *             .roleArn(aws_iam_role.example().arn())
 *             .s3Path(FaqS3PathArgs.builder()
 *                 .bucket(aws_s3_bucket.example().id())
 *                 .key(aws_s3_object.example().key())
 *                 .build())
 *             .tags(Map.of("Name", "Example Kendra Faq"))
 *             .build());
 *     }
 * }
 * ```
 * ### With File Format
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.kendra.Faq;
 * import com.pulumi.aws.kendra.FaqArgs;
 * import com.pulumi.aws.kendra.inputs.FaqS3PathArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new Faq("example", FaqArgs.builder()
 *             .indexId(aws_kendra_index.example().id())
 *             .fileFormat("CSV")
 *             .roleArn(aws_iam_role.example().arn())
 *             .s3Path(FaqS3PathArgs.builder()
 *                 .bucket(aws_s3_bucket.example().id())
 *                 .key(aws_s3_object.example().key())
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ### With Language Code
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.kendra.Faq;
 * import com.pulumi.aws.kendra.FaqArgs;
 * import com.pulumi.aws.kendra.inputs.FaqS3PathArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new Faq("example", FaqArgs.builder()
 *             .indexId(aws_kendra_index.example().id())
 *             .languageCode("en")
 *             .roleArn(aws_iam_role.example().arn())
 *             .s3Path(FaqS3PathArgs.builder()
 *                 .bucket(aws_s3_bucket.example().id())
 *                 .key(aws_s3_object.example().key())
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import `aws_kendra_faq` using the unique identifiers of the FAQ and index separated by a slash (`/`). For example:
 * ```sh
 *  $ pulumi import aws:kendra/faq:Faq example faq-123456780/idx-8012925589
 * ```
 *
 */
public class Faq internal constructor(
    override val javaResource: com.pulumi.aws.kendra.Faq,
) : KotlinCustomResource(javaResource, FaqMapper) {
    /**
     * ARN of the FAQ.
     */
    public val arn: Output<String>
        get() = javaResource.arn().applyValue({ args0 -> args0 })

    /**
     * The Unix datetime that the FAQ was created.
     */
    public val createdAt: Output<String>
        get() = javaResource.createdAt().applyValue({ args0 -> args0 })

    /**
     * The description for a FAQ.
     */
    public val description: Output<String>?
        get() = javaResource.description().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * When the Status field value is `FAILED`, this contains a message that explains why.
     */
    public val errorMessage: Output<String>
        get() = javaResource.errorMessage().applyValue({ args0 -> args0 })

    /**
     * The identifier of the FAQ.
     */
    public val faqId: Output<String>
        get() = javaResource.faqId().applyValue({ args0 -> args0 })

    /**
     * The file format used by the input files for the FAQ. Valid Values are `CSV`, `CSV_WITH_HEADER`, `JSON`.
     */
    public val fileFormat: Output<String>?
        get() = javaResource.fileFormat().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The identifier of the index for a FAQ.
     */
    public val indexId: Output<String>
        get() = javaResource.indexId().applyValue({ args0 -> args0 })

    /**
     * The code for a language. This shows a supported language for the FAQ document. English is supported by default. For more information on supported languages, including their codes, see [Adding documents in languages other than English](https://docs.aws.amazon.com/kendra/latest/dg/in-adding-languages.html).
     */
    public val languageCode: Output<String>
        get() = javaResource.languageCode().applyValue({ args0 -> args0 })

    /**
     * The name that should be associated with the FAQ.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * The Amazon Resource Name (ARN) of a role with permission to access the S3 bucket that contains the FAQs. For more information, see [IAM Roles for Amazon Kendra](https://docs.aws.amazon.com/kendra/latest/dg/iam-roles.html).
     */
    public val roleArn: Output<String>
        get() = javaResource.roleArn().applyValue({ args0 -> args0 })

    /**
     * The S3 location of the FAQ input data. Detailed below.
     * The `s3_path` configuration block supports the following arguments:
     */
    public val s3Path: Output<FaqS3Path>
        get() = javaResource.s3Path().applyValue({ args0 -> args0.let({ args0 -> toKotlin(args0) }) })

    /**
     * The status of the FAQ. It is ready to use when the status is ACTIVE.
     */
    public val status: Output<String>
        get() = javaResource.status().applyValue({ args0 -> args0 })

    /**
     * Key-value map of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
     */
    @Deprecated(
        message = """
  Please use `tags` instead.
  """,
    )
    public val tagsAll: Output<Map<String, String>>
        get() = javaResource.tagsAll().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.key.to(args0.value)
            }).toMap()
        })

    /**
     * The date and time that the FAQ was last updated.
     */
    public val updatedAt: Output<String>
        get() = javaResource.updatedAt().applyValue({ args0 -> args0 })
}

public object FaqMapper : ResourceMapper<Faq> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.kendra.Faq::class == javaResource::class

    override fun map(javaResource: Resource): Faq = Faq(javaResource as com.pulumi.aws.kendra.Faq)
}

/**
 * @see [Faq].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [Faq].
 */
public suspend fun faq(name: String, block: suspend FaqResourceBuilder.() -> Unit): Faq {
    val builder = FaqResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [Faq].
 * @param name The _unique_ name of the resulting resource.
 */
public fun faq(name: String): Faq {
    val builder = FaqResourceBuilder()
    builder.name(name)
    return builder.build()
}
