@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.kendra.kotlin

import com.pulumi.aws.kendra.FaqArgs.builder
import com.pulumi.aws.kendra.kotlin.inputs.FaqS3PathArgs
import com.pulumi.aws.kendra.kotlin.inputs.FaqS3PathArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Resource for managing an AWS Kendra FAQ.
 * ## Example Usage
 * ### Basic
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.kendra.Faq;
 * import com.pulumi.aws.kendra.FaqArgs;
 * import com.pulumi.aws.kendra.inputs.FaqS3PathArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new Faq("example", FaqArgs.builder()
 *             .indexId(aws_kendra_index.example().id())
 *             .roleArn(aws_iam_role.example().arn())
 *             .s3Path(FaqS3PathArgs.builder()
 *                 .bucket(aws_s3_bucket.example().id())
 *                 .key(aws_s3_object.example().key())
 *                 .build())
 *             .tags(Map.of("Name", "Example Kendra Faq"))
 *             .build());
 *     }
 * }
 * ```
 * ### With File Format
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.kendra.Faq;
 * import com.pulumi.aws.kendra.FaqArgs;
 * import com.pulumi.aws.kendra.inputs.FaqS3PathArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new Faq("example", FaqArgs.builder()
 *             .indexId(aws_kendra_index.example().id())
 *             .fileFormat("CSV")
 *             .roleArn(aws_iam_role.example().arn())
 *             .s3Path(FaqS3PathArgs.builder()
 *                 .bucket(aws_s3_bucket.example().id())
 *                 .key(aws_s3_object.example().key())
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ### With Language Code
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.kendra.Faq;
 * import com.pulumi.aws.kendra.FaqArgs;
 * import com.pulumi.aws.kendra.inputs.FaqS3PathArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new Faq("example", FaqArgs.builder()
 *             .indexId(aws_kendra_index.example().id())
 *             .languageCode("en")
 *             .roleArn(aws_iam_role.example().arn())
 *             .s3Path(FaqS3PathArgs.builder()
 *                 .bucket(aws_s3_bucket.example().id())
 *                 .key(aws_s3_object.example().key())
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import `aws_kendra_faq` using the unique identifiers of the FAQ and index separated by a slash (`/`). For example:
 * ```sh
 *  $ pulumi import aws:kendra/faq:Faq example faq-123456780/idx-8012925589
 * ```
 * @property description The description for a FAQ.
 * @property fileFormat The file format used by the input files for the FAQ. Valid Values are `CSV`, `CSV_WITH_HEADER`, `JSON`.
 * @property indexId The identifier of the index for a FAQ.
 * @property languageCode The code for a language. This shows a supported language for the FAQ document. English is supported by default. For more information on supported languages, including their codes, see [Adding documents in languages other than English](https://docs.aws.amazon.com/kendra/latest/dg/in-adding-languages.html).
 * @property name The name that should be associated with the FAQ.
 * @property roleArn The Amazon Resource Name (ARN) of a role with permission to access the S3 bucket that contains the FAQs. For more information, see [IAM Roles for Amazon Kendra](https://docs.aws.amazon.com/kendra/latest/dg/iam-roles.html).
 * @property s3Path The S3 location of the FAQ input data. Detailed below.
 * The `s3_path` configuration block supports the following arguments:
 * @property tags Key-value map of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
 */
public data class FaqArgs(
    public val description: Output<String>? = null,
    public val fileFormat: Output<String>? = null,
    public val indexId: Output<String>? = null,
    public val languageCode: Output<String>? = null,
    public val name: Output<String>? = null,
    public val roleArn: Output<String>? = null,
    public val s3Path: Output<FaqS3PathArgs>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.aws.kendra.FaqArgs> {
    override fun toJava(): com.pulumi.aws.kendra.FaqArgs = com.pulumi.aws.kendra.FaqArgs.builder()
        .description(description?.applyValue({ args0 -> args0 }))
        .fileFormat(fileFormat?.applyValue({ args0 -> args0 }))
        .indexId(indexId?.applyValue({ args0 -> args0 }))
        .languageCode(languageCode?.applyValue({ args0 -> args0 }))
        .name(name?.applyValue({ args0 -> args0 }))
        .roleArn(roleArn?.applyValue({ args0 -> args0 }))
        .s3Path(s3Path?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
        .tags(
            tags?.applyValue({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }),
        ).build()
}

/**
 * Builder for [FaqArgs].
 */
@PulumiTagMarker
public class FaqArgsBuilder internal constructor() {
    private var description: Output<String>? = null

    private var fileFormat: Output<String>? = null

    private var indexId: Output<String>? = null

    private var languageCode: Output<String>? = null

    private var name: Output<String>? = null

    private var roleArn: Output<String>? = null

    private var s3Path: Output<FaqS3PathArgs>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value The description for a FAQ.
     */
    @JvmName("wbsbijkqbsgbmorg")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value The file format used by the input files for the FAQ. Valid Values are `CSV`, `CSV_WITH_HEADER`, `JSON`.
     */
    @JvmName("jakdxmwosdcgaflc")
    public suspend fun fileFormat(`value`: Output<String>) {
        this.fileFormat = value
    }

    /**
     * @param value The identifier of the index for a FAQ.
     */
    @JvmName("ismeaexwogkhkbno")
    public suspend fun indexId(`value`: Output<String>) {
        this.indexId = value
    }

    /**
     * @param value The code for a language. This shows a supported language for the FAQ document. English is supported by default. For more information on supported languages, including their codes, see [Adding documents in languages other than English](https://docs.aws.amazon.com/kendra/latest/dg/in-adding-languages.html).
     */
    @JvmName("lkcrwnyidybuopey")
    public suspend fun languageCode(`value`: Output<String>) {
        this.languageCode = value
    }

    /**
     * @param value The name that should be associated with the FAQ.
     */
    @JvmName("gsehktglrbtrgrda")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value The Amazon Resource Name (ARN) of a role with permission to access the S3 bucket that contains the FAQs. For more information, see [IAM Roles for Amazon Kendra](https://docs.aws.amazon.com/kendra/latest/dg/iam-roles.html).
     */
    @JvmName("kgwbkgmsqpfmvtgw")
    public suspend fun roleArn(`value`: Output<String>) {
        this.roleArn = value
    }

    /**
     * @param value The S3 location of the FAQ input data. Detailed below.
     * The `s3_path` configuration block supports the following arguments:
     */
    @JvmName("lcsoponsqewvfmbc")
    public suspend fun s3Path(`value`: Output<FaqS3PathArgs>) {
        this.s3Path = value
    }

    /**
     * @param value Key-value map of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("kuoduowohwqrljkj")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value The description for a FAQ.
     */
    @JvmName("qyhrgklktqsxomhl")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value The file format used by the input files for the FAQ. Valid Values are `CSV`, `CSV_WITH_HEADER`, `JSON`.
     */
    @JvmName("kkjrjtqvkaeccnig")
    public suspend fun fileFormat(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.fileFormat = mapped
    }

    /**
     * @param value The identifier of the index for a FAQ.
     */
    @JvmName("uwfwrydbwjtxehvd")
    public suspend fun indexId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.indexId = mapped
    }

    /**
     * @param value The code for a language. This shows a supported language for the FAQ document. English is supported by default. For more information on supported languages, including their codes, see [Adding documents in languages other than English](https://docs.aws.amazon.com/kendra/latest/dg/in-adding-languages.html).
     */
    @JvmName("uxihjfkbupuqcdty")
    public suspend fun languageCode(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.languageCode = mapped
    }

    /**
     * @param value The name that should be associated with the FAQ.
     */
    @JvmName("obisesunhphlfoub")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value The Amazon Resource Name (ARN) of a role with permission to access the S3 bucket that contains the FAQs. For more information, see [IAM Roles for Amazon Kendra](https://docs.aws.amazon.com/kendra/latest/dg/iam-roles.html).
     */
    @JvmName("nmefejetuyjotebg")
    public suspend fun roleArn(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.roleArn = mapped
    }

    /**
     * @param value The S3 location of the FAQ input data. Detailed below.
     * The `s3_path` configuration block supports the following arguments:
     */
    @JvmName("gxcloibvuftkvyom")
    public suspend fun s3Path(`value`: FaqS3PathArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.s3Path = mapped
    }

    /**
     * @param argument The S3 location of the FAQ input data. Detailed below.
     * The `s3_path` configuration block supports the following arguments:
     */
    @JvmName("qcuskufubtfiqhij")
    public suspend fun s3Path(argument: suspend FaqS3PathArgsBuilder.() -> Unit) {
        val toBeMapped = FaqS3PathArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.s3Path = mapped
    }

    /**
     * @param value Key-value map of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("difqnhqtdaexfhjn")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Key-value map of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("ikhdyaaaguqwwonq")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): FaqArgs = FaqArgs(
        description = description,
        fileFormat = fileFormat,
        indexId = indexId,
        languageCode = languageCode,
        name = name,
        roleArn = roleArn,
        s3Path = s3Path,
        tags = tags,
    )
}
