@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.kendra.kotlin

import com.pulumi.aws.kendra.kotlin.outputs.IndexCapacityUnits
import com.pulumi.aws.kendra.kotlin.outputs.IndexDocumentMetadataConfigurationUpdate
import com.pulumi.aws.kendra.kotlin.outputs.IndexIndexStatistic
import com.pulumi.aws.kendra.kotlin.outputs.IndexServerSideEncryptionConfiguration
import com.pulumi.aws.kendra.kotlin.outputs.IndexUserGroupResolutionConfiguration
import com.pulumi.aws.kendra.kotlin.outputs.IndexUserTokenConfigurations
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import com.pulumi.aws.kendra.kotlin.outputs.IndexCapacityUnits.Companion.toKotlin as indexCapacityUnitsToKotlin
import com.pulumi.aws.kendra.kotlin.outputs.IndexDocumentMetadataConfigurationUpdate.Companion.toKotlin as indexDocumentMetadataConfigurationUpdateToKotlin
import com.pulumi.aws.kendra.kotlin.outputs.IndexIndexStatistic.Companion.toKotlin as indexIndexStatisticToKotlin
import com.pulumi.aws.kendra.kotlin.outputs.IndexServerSideEncryptionConfiguration.Companion.toKotlin as indexServerSideEncryptionConfigurationToKotlin
import com.pulumi.aws.kendra.kotlin.outputs.IndexUserGroupResolutionConfiguration.Companion.toKotlin as indexUserGroupResolutionConfigurationToKotlin
import com.pulumi.aws.kendra.kotlin.outputs.IndexUserTokenConfigurations.Companion.toKotlin as indexUserTokenConfigurationsToKotlin

/**
 * Builder for [Index].
 */
@PulumiTagMarker
public class IndexResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: IndexArgs = IndexArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend IndexArgsBuilder.() -> Unit) {
        val builder = IndexArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): Index {
        val builtJavaResource = com.pulumi.aws.kendra.Index(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return Index(builtJavaResource)
    }
}

/**
 * Provides an Amazon Kendra Index resource.
 * ## Example Usage
 * ### Basic
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.kendra.Index;
 * import com.pulumi.aws.kendra.IndexArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new Index("example", IndexArgs.builder()
 *             .description("example")
 *             .edition("DEVELOPER_EDITION")
 *             .roleArn(aws_iam_role.this().arn())
 *             .tags(Map.of("Key1", "Value1"))
 *             .build());
 *     }
 * }
 * ```
 * ### With capacity units
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.kendra.Index;
 * import com.pulumi.aws.kendra.IndexArgs;
 * import com.pulumi.aws.kendra.inputs.IndexCapacityUnitsArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new Index("example", IndexArgs.builder()
 *             .edition("DEVELOPER_EDITION")
 *             .roleArn(aws_iam_role.this().arn())
 *             .capacityUnits(IndexCapacityUnitsArgs.builder()
 *                 .queryCapacityUnits(2)
 *                 .storageCapacityUnits(2)
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ### With server side encryption configuration
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.kendra.Index;
 * import com.pulumi.aws.kendra.IndexArgs;
 * import com.pulumi.aws.kendra.inputs.IndexServerSideEncryptionConfigurationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new Index("example", IndexArgs.builder()
 *             .roleArn(aws_iam_role.this().arn())
 *             .serverSideEncryptionConfiguration(IndexServerSideEncryptionConfigurationArgs.builder()
 *                 .kmsKeyId(data.aws_kms_key().this().arn())
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ### With user group resolution configuration
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.kendra.Index;
 * import com.pulumi.aws.kendra.IndexArgs;
 * import com.pulumi.aws.kendra.inputs.IndexUserGroupResolutionConfigurationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new Index("example", IndexArgs.builder()
 *             .roleArn(aws_iam_role.this().arn())
 *             .userGroupResolutionConfiguration(IndexUserGroupResolutionConfigurationArgs.builder()
 *                 .userGroupResolutionMode("AWS_SSO")
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ### Specifying the predefined elements
 * Refer to [Amazon Kendra documentation on built-in document fields](https://docs.aws.amazon.com/kendra/latest/dg/hiw-index.html#index-reserved-fields) for more information.
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.kendra.Index;
 * import com.pulumi.aws.kendra.IndexArgs;
 * import com.pulumi.aws.kendra.inputs.IndexDocumentMetadataConfigurationUpdateArgs;
 * import com.pulumi.aws.kendra.inputs.IndexDocumentMetadataConfigurationUpdateSearchArgs;
 * import com.pulumi.aws.kendra.inputs.IndexDocumentMetadataConfigurationUpdateRelevanceArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new Index("example", IndexArgs.builder()
 *             .roleArn(aws_iam_role.this().arn())
 *             .documentMetadataConfigurationUpdates(
 *                 IndexDocumentMetadataConfigurationUpdateArgs.builder()
 *                     .name("_authors")
 *                     .type("STRING_LIST_VALUE")
 *                     .search(IndexDocumentMetadataConfigurationUpdateSearchArgs.builder()
 *                         .displayable(false)
 *                         .facetable(false)
 *                         .searchable(false)
 *                         .sortable(false)
 *                         .build())
 *                     .relevance(IndexDocumentMetadataConfigurationUpdateRelevanceArgs.builder()
 *                         .importance(1)
 *                         .build())
 *                     .build(),
 *                 IndexDocumentMetadataConfigurationUpdateArgs.builder()
 *                     .name("_category")
 *                     .type("STRING_VALUE")
 *                     .search(IndexDocumentMetadataConfigurationUpdateSearchArgs.builder()
 *                         .displayable(false)
 *                         .facetable(false)
 *                         .searchable(false)
 *                         .sortable(true)
 *                         .build())
 *                     .relevance(IndexDocumentMetadataConfigurationUpdateRelevanceArgs.builder()
 *                         .importance(1)
 *                         .valuesImportanceMap()
 *                         .build())
 *                     .build(),
 *                 IndexDocumentMetadataConfigurationUpdateArgs.builder()
 *                     .name("_created_at")
 *                     .type("DATE_VALUE")
 *                     .search(IndexDocumentMetadataConfigurationUpdateSearchArgs.builder()
 *                         .displayable(false)
 *                         .facetable(false)
 *                         .searchable(false)
 *                         .sortable(true)
 *                         .build())
 *                     .relevance(IndexDocumentMetadataConfigurationUpdateRelevanceArgs.builder()
 *                         .freshness(false)
 *                         .importance(1)
 *                         .duration("25920000s")
 *                         .rankOrder("ASCENDING")
 *                         .build())
 *                     .build(),
 *                 IndexDocumentMetadataConfigurationUpdateArgs.builder()
 *                     .name("_data_source_id")
 *                     .type("STRING_VALUE")
 *                     .search(IndexDocumentMetadataConfigurationUpdateSearchArgs.builder()
 *                         .displayable(false)
 *                         .facetable(false)
 *                         .searchable(false)
 *                         .sortable(true)
 *                         .build())
 *                     .relevance(IndexDocumentMetadataConfigurationUpdateRelevanceArgs.builder()
 *                         .importance(1)
 *                         .valuesImportanceMap()
 *                         .build())
 *                     .build(),
 *                 IndexDocumentMetadataConfigurationUpdateArgs.builder()
 *                     .name("_document_title")
 *                     .type("STRING_VALUE")
 *                     .search(IndexDocumentMetadataConfigurationUpdateSearchArgs.builder()
 *                         .displayable(true)
 *                         .facetable(false)
 *                         .searchable(true)
 *                         .sortable(true)
 *                         .build())
 *                     .relevance(IndexDocumentMetadataConfigurationUpdateRelevanceArgs.builder()
 *                         .importance(2)
 *                         .valuesImportanceMap()
 *                         .build())
 *                     .build(),
 *                 IndexDocumentMetadataConfigurationUpdateArgs.builder()
 *                     .name("_excerpt_page_number")
 *                     .type("LONG_VALUE")
 *                     .search(IndexDocumentMetadataConfigurationUpdateSearchArgs.builder()
 *                         .displayable(false)
 *                         .facetable(false)
 *                         .searchable(false)
 *                         .sortable(false)
 *                         .build())
 *                     .relevance(IndexDocumentMetadataConfigurationUpdateRelevanceArgs.builder()
 *                         .importance(2)
 *                         .rankOrder("ASCENDING")
 *                         .build())
 *                     .build(),
 *                 IndexDocumentMetadataConfigurationUpdateArgs.builder()
 *                     .name("_faq_id")
 *                     .type("STRING_VALUE")
 *                     .search(IndexDocumentMetadataConfigurationUpdateSearchArgs.builder()
 *                         .displayable(false)
 *                         .facetable(false)
 *                         .searchable(false)
 *                         .sortable(true)
 *                         .build())
 *                     .relevance(IndexDocumentMetadataConfigurationUpdateRelevanceArgs.builder()
 *                         .importance(1)
 *                         .valuesImportanceMap()
 *                         .build())
 *                     .build(),
 *                 IndexDocumentMetadataConfigurationUpdateArgs.builder()
 *                     .name("_file_type")
 *                     .type("STRING_VALUE")
 *                     .search(IndexDocumentMetadataConfigurationUpdateSearchArgs.builder()
 *                         .displayable(false)
 *                         .facetable(false)
 *                         .searchable(false)
 *                         .sortable(true)
 *                         .build())
 *                     .relevance(IndexDocumentMetadataConfigurationUpdateRelevanceArgs.builder()
 *                         .importance(1)
 *                         .valuesImportanceMap()
 *                         .build())
 *                     .build(),
 *                 IndexDocumentMetadataConfigurationUpdateArgs.builder()
 *                     .name("_language_code")
 *                     .type("STRING_VALUE")
 *                     .search(IndexDocumentMetadataConfigurationUpdateSearchArgs.builder()
 *                         .displayable(false)
 *                         .facetable(false)
 *                         .searchable(false)
 *                         .sortable(true)
 *                         .build())
 *                     .relevance(IndexDocumentMetadataConfigurationUpdateRelevanceArgs.builder()
 *                         .importance(1)
 *                         .valuesImportanceMap()
 *                         .build())
 *                     .build(),
 *                 IndexDocumentMetadataConfigurationUpdateArgs.builder()
 *                     .name("_last_updated_at")
 *                     .type("DATE_VALUE")
 *                     .search(IndexDocumentMetadataConfigurationUpdateSearchArgs.builder()
 *                         .displayable(false)
 *                         .facetable(false)
 *                         .searchable(false)
 *                         .sortable(true)
 *                         .build())
 *                     .relevance(IndexDocumentMetadataConfigurationUpdateRelevanceArgs.builder()
 *                         .freshness(false)
 *                         .importance(1)
 *                         .duration("25920000s")
 *                         .rankOrder("ASCENDING")
 *                         .build())
 *                     .build(),
 *                 IndexDocumentMetadataConfigurationUpdateArgs.builder()
 *                     .name("_source_uri")
 *                     .type("STRING_VALUE")
 *                     .search(IndexDocumentMetadataConfigurationUpdateSearchArgs.builder()
 *                         .displayable(true)
 *                         .facetable(false)
 *                         .searchable(false)
 *                         .sortable(false)
 *                         .build())
 *                     .relevance(IndexDocumentMetadataConfigurationUpdateRelevanceArgs.builder()
 *                         .importance(1)
 *                         .valuesImportanceMap()
 *                         .build())
 *                     .build(),
 *                 IndexDocumentMetadataConfigurationUpdateArgs.builder()
 *                     .name("_tenant_id")
 *                     .type("STRING_VALUE")
 *                     .search(IndexDocumentMetadataConfigurationUpdateSearchArgs.builder()
 *                         .displayable(false)
 *                         .facetable(false)
 *                         .searchable(false)
 *                         .sortable(true)
 *                         .build())
 *                     .relevance(IndexDocumentMetadataConfigurationUpdateRelevanceArgs.builder()
 *                         .importance(1)
 *                         .valuesImportanceMap()
 *                         .build())
 *                     .build(),
 *                 IndexDocumentMetadataConfigurationUpdateArgs.builder()
 *                     .name("_version")
 *                     .type("STRING_VALUE")
 *                     .search(IndexDocumentMetadataConfigurationUpdateSearchArgs.builder()
 *                         .displayable(false)
 *                         .facetable(false)
 *                         .searchable(false)
 *                         .sortable(true)
 *                         .build())
 *                     .relevance(IndexDocumentMetadataConfigurationUpdateRelevanceArgs.builder()
 *                         .importance(1)
 *                         .valuesImportanceMap()
 *                         .build())
 *                     .build(),
 *                 IndexDocumentMetadataConfigurationUpdateArgs.builder()
 *                     .name("_view_count")
 *                     .type("LONG_VALUE")
 *                     .search(IndexDocumentMetadataConfigurationUpdateSearchArgs.builder()
 *                         .displayable(false)
 *                         .facetable(false)
 *                         .searchable(false)
 *                         .sortable(true)
 *                         .build())
 *                     .relevance(IndexDocumentMetadataConfigurationUpdateRelevanceArgs.builder()
 *                         .importance(1)
 *                         .rankOrder("ASCENDING")
 *                         .build())
 *                     .build())
 *             .build());
 *     }
 * }
 * ```
 * ### Appending additional elements
 * The example below shows additional elements with names, `example-string-value`, `example-long-value`, `example-string-list-value`, `example-date-value` representing the 4 types of `STRING_VALUE`, `LONG_VALUE`, `STRING_LIST_VALUE`, `DATE_VALUE` respectively.
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.kendra.Index;
 * import com.pulumi.aws.kendra.IndexArgs;
 * import com.pulumi.aws.kendra.inputs.IndexDocumentMetadataConfigurationUpdateArgs;
 * import com.pulumi.aws.kendra.inputs.IndexDocumentMetadataConfigurationUpdateSearchArgs;
 * import com.pulumi.aws.kendra.inputs.IndexDocumentMetadataConfigurationUpdateRelevanceArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new Index("example", IndexArgs.builder()
 *             .roleArn(aws_iam_role.this().arn())
 *             .documentMetadataConfigurationUpdates(
 *                 IndexDocumentMetadataConfigurationUpdateArgs.builder()
 *                     .name("_authors")
 *                     .type("STRING_LIST_VALUE")
 *                     .search(IndexDocumentMetadataConfigurationUpdateSearchArgs.builder()
 *                         .displayable(false)
 *                         .facetable(false)
 *                         .searchable(false)
 *                         .sortable(false)
 *                         .build())
 *                     .relevance(IndexDocumentMetadataConfigurationUpdateRelevanceArgs.builder()
 *                         .importance(1)
 *                         .build())
 *                     .build(),
 *                 IndexDocumentMetadataConfigurationUpdateArgs.builder()
 *                     .name("_category")
 *                     .type("STRING_VALUE")
 *                     .search(IndexDocumentMetadataConfigurationUpdateSearchArgs.builder()
 *                         .displayable(false)
 *                         .facetable(false)
 *                         .searchable(false)
 *                         .sortable(true)
 *                         .build())
 *                     .relevance(IndexDocumentMetadataConfigurationUpdateRelevanceArgs.builder()
 *                         .importance(1)
 *                         .valuesImportanceMap()
 *                         .build())
 *                     .build(),
 *                 IndexDocumentMetadataConfigurationUpdateArgs.builder()
 *                     .name("_created_at")
 *                     .type("DATE_VALUE")
 *                     .search(IndexDocumentMetadataConfigurationUpdateSearchArgs.builder()
 *                         .displayable(false)
 *                         .facetable(false)
 *                         .searchable(false)
 *                         .sortable(true)
 *                         .build())
 *                     .relevance(IndexDocumentMetadataConfigurationUpdateRelevanceArgs.builder()
 *                         .freshness(false)
 *                         .importance(1)
 *                         .duration("25920000s")
 *                         .rankOrder("ASCENDING")
 *                         .build())
 *                     .build(),
 *                 IndexDocumentMetadataConfigurationUpdateArgs.builder()
 *                     .name("_data_source_id")
 *                     .type("STRING_VALUE")
 *                     .search(IndexDocumentMetadataConfigurationUpdateSearchArgs.builder()
 *                         .displayable(false)
 *                         .facetable(false)
 *                         .searchable(false)
 *                         .sortable(true)
 *                         .build())
 *                     .relevance(IndexDocumentMetadataConfigurationUpdateRelevanceArgs.builder()
 *                         .importance(1)
 *                         .valuesImportanceMap()
 *                         .build())
 *                     .build(),
 *                 IndexDocumentMetadataConfigurationUpdateArgs.builder()
 *                     .name("_document_title")
 *                     .type("STRING_VALUE")
 *                     .search(IndexDocumentMetadataConfigurationUpdateSearchArgs.builder()
 *                         .displayable(true)
 *                         .facetable(false)
 *                         .searchable(true)
 *                         .sortable(true)
 *                         .build())
 *                     .relevance(IndexDocumentMetadataConfigurationUpdateRelevanceArgs.builder()
 *                         .importance(2)
 *                         .valuesImportanceMap()
 *                         .build())
 *                     .build(),
 *                 IndexDocumentMetadataConfigurationUpdateArgs.builder()
 *                     .name("_excerpt_page_number")
 *                     .type("LONG_VALUE")
 *                     .search(IndexDocumentMetadataConfigurationUpdateSearchArgs.builder()
 *                         .displayable(false)
 *                         .facetable(false)
 *                         .searchable(false)
 *                         .sortable(false)
 *                         .build())
 *                     .relevance(IndexDocumentMetadataConfigurationUpdateRelevanceArgs.builder()
 *                         .importance(2)
 *                         .rankOrder("ASCENDING")
 *                         .build())
 *                     .build(),
 *                 IndexDocumentMetadataConfigurationUpdateArgs.builder()
 *                     .name("_faq_id")
 *                     .type("STRING_VALUE")
 *                     .search(IndexDocumentMetadataConfigurationUpdateSearchArgs.builder()
 *                         .displayable(false)
 *                         .facetable(false)
 *                         .searchable(false)
 *                         .sortable(true)
 *                         .build())
 *                     .relevance(IndexDocumentMetadataConfigurationUpdateRelevanceArgs.builder()
 *                         .importance(1)
 *                         .valuesImportanceMap()
 *                         .build())
 *                     .build(),
 *                 IndexDocumentMetadataConfigurationUpdateArgs.builder()
 *                     .name("_file_type")
 *                     .type("STRING_VALUE")
 *                     .search(IndexDocumentMetadataConfigurationUpdateSearchArgs.builder()
 *                         .displayable(false)
 *                         .facetable(false)
 *                         .searchable(false)
 *                         .sortable(true)
 *                         .build())
 *                     .relevance(IndexDocumentMetadataConfigurationUpdateRelevanceArgs.builder()
 *                         .importance(1)
 *                         .valuesImportanceMap()
 *                         .build())
 *                     .build(),
 *                 IndexDocumentMetadataConfigurationUpdateArgs.builder()
 *                     .name("_language_code")
 *                     .type("STRING_VALUE")
 *                     .search(IndexDocumentMetadataConfigurationUpdateSearchArgs.builder()
 *                         .displayable(false)
 *                         .facetable(false)
 *                         .searchable(false)
 *                         .sortable(true)
 *                         .build())
 *                     .relevance(IndexDocumentMetadataConfigurationUpdateRelevanceArgs.builder()
 *                         .importance(1)
 *                         .valuesImportanceMap()
 *                         .build())
 *                     .build(),
 *                 IndexDocumentMetadataConfigurationUpdateArgs.builder()
 *                     .name("_last_updated_at")
 *                     .type("DATE_VALUE")
 *                     .search(IndexDocumentMetadataConfigurationUpdateSearchArgs.builder()
 *                         .displayable(false)
 *                         .facetable(false)
 *                         .searchable(false)
 *                         .sortable(true)
 *                         .build())
 *                     .relevance(IndexDocumentMetadataConfigurationUpdateRelevanceArgs.builder()
 *                         .freshness(false)
 *                         .importance(1)
 *                         .duration("25920000s")
 *                         .rankOrder("ASCENDING")
 *                         .build())
 *                     .build(),
 *                 IndexDocumentMetadataConfigurationUpdateArgs.builder()
 *                     .name("_source_uri")
 *                     .type("STRING_VALUE")
 *                     .search(IndexDocumentMetadataConfigurationUpdateSearchArgs.builder()
 *                         .displayable(true)
 *                         .facetable(false)
 *                         .searchable(false)
 *                         .sortable(false)
 *                         .build())
 *                     .relevance(IndexDocumentMetadataConfigurationUpdateRelevanceArgs.builder()
 *                         .importance(1)
 *                         .valuesImportanceMap()
 *                         .build())
 *                     .build(),
 *                 IndexDocumentMetadataConfigurationUpdateArgs.builder()
 *                     .name("_tenant_id")
 *                     .type("STRING_VALUE")
 *                     .search(IndexDocumentMetadataConfigurationUpdateSearchArgs.builder()
 *                         .displayable(false)
 *                         .facetable(false)
 *                         .searchable(false)
 *                         .sortable(true)
 *                         .build())
 *                     .relevance(IndexDocumentMetadataConfigurationUpdateRelevanceArgs.builder()
 *                         .importance(1)
 *                         .valuesImportanceMap()
 *                         .build())
 *                     .build(),
 *                 IndexDocumentMetadataConfigurationUpdateArgs.builder()
 *                     .name("_version")
 *                     .type("STRING_VALUE")
 *                     .search(IndexDocumentMetadataConfigurationUpdateSearchArgs.builder()
 *                         .displayable(false)
 *                         .facetable(false)
 *                         .searchable(false)
 *                         .sortable(true)
 *                         .build())
 *                     .relevance(IndexDocumentMetadataConfigurationUpdateRelevanceArgs.builder()
 *                         .importance(1)
 *                         .valuesImportanceMap()
 *                         .build())
 *                     .build(),
 *                 IndexDocumentMetadataConfigurationUpdateArgs.builder()
 *                     .name("_view_count")
 *                     .type("LONG_VALUE")
 *                     .search(IndexDocumentMetadataConfigurationUpdateSearchArgs.builder()
 *                         .displayable(false)
 *                         .facetable(false)
 *                         .searchable(false)
 *                         .sortable(true)
 *                         .build())
 *                     .relevance(IndexDocumentMetadataConfigurationUpdateRelevanceArgs.builder()
 *                         .importance(1)
 *                         .rankOrder("ASCENDING")
 *                         .build())
 *                     .build(),
 *                 IndexDocumentMetadataConfigurationUpdateArgs.builder()
 *                     .name("example-string-value")
 *                     .type("STRING_VALUE")
 *                     .search(IndexDocumentMetadataConfigurationUpdateSearchArgs.builder()
 *                         .displayable(true)
 *                         .facetable(true)
 *                         .searchable(true)
 *                         .sortable(true)
 *                         .build())
 *                     .relevance(IndexDocumentMetadataConfigurationUpdateRelevanceArgs.builder()
 *                         .importance(1)
 *                         .valuesImportanceMap()
 *                         .build())
 *                     .build(),
 *                 IndexDocumentMetadataConfigurationUpdateArgs.builder()
 *                     .name("example-long-value")
 *                     .type("LONG_VALUE")
 *                     .search(IndexDocumentMetadataConfigurationUpdateSearchArgs.builder()
 *                         .displayable(true)
 *                         .facetable(true)
 *                         .searchable(false)
 *                         .sortable(true)
 *                         .build())
 *                     .relevance(IndexDocumentMetadataConfigurationUpdateRelevanceArgs.builder()
 *                         .importance(1)
 *                         .rankOrder("ASCENDING")
 *                         .build())
 *                     .build(),
 *                 IndexDocumentMetadataConfigurationUpdateArgs.builder()
 *                     .name("example-string-list-value")
 *                     .type("STRING_LIST_VALUE")
 *                     .search(IndexDocumentMetadataConfigurationUpdateSearchArgs.builder()
 *                         .displayable(true)
 *                         .facetable(true)
 *                         .searchable(true)
 *                         .sortable(false)
 *                         .build())
 *                     .relevance(IndexDocumentMetadataConfigurationUpdateRelevanceArgs.builder()
 *                         .importance(1)
 *                         .build())
 *                     .build(),
 *                 IndexDocumentMetadataConfigurationUpdateArgs.builder()
 *                     .name("example-date-value")
 *                     .type("DATE_VALUE")
 *                     .search(IndexDocumentMetadataConfigurationUpdateSearchArgs.builder()
 *                         .displayable(true)
 *                         .facetable(true)
 *                         .searchable(false)
 *                         .sortable(false)
 *                         .build())
 *                     .relevance(IndexDocumentMetadataConfigurationUpdateRelevanceArgs.builder()
 *                         .freshness(false)
 *                         .importance(1)
 *                         .duration("25920000s")
 *                         .rankOrder("ASCENDING")
 *                         .build())
 *                     .build())
 *             .build());
 *     }
 * }
 * ```
 * ### With JSON token type configuration
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.kendra.Index;
 * import com.pulumi.aws.kendra.IndexArgs;
 * import com.pulumi.aws.kendra.inputs.IndexUserTokenConfigurationsArgs;
 * import com.pulumi.aws.kendra.inputs.IndexUserTokenConfigurationsJsonTokenTypeConfigurationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new Index("example", IndexArgs.builder()
 *             .roleArn(aws_iam_role.this().arn())
 *             .userTokenConfigurations(IndexUserTokenConfigurationsArgs.builder()
 *                 .jsonTokenTypeConfiguration(IndexUserTokenConfigurationsJsonTokenTypeConfigurationArgs.builder()
 *                     .groupAttributeField("groups")
 *                     .userNameAttributeField("username")
 *                     .build())
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import Amazon Kendra Indexes using its `id`. For example:
 * ```sh
 *  $ pulumi import aws:kendra/index:Index example 12345678-1234-5678-9123-123456789123
 * ```
 *
 */
public class Index internal constructor(
    override val javaResource: com.pulumi.aws.kendra.Index,
) : KotlinCustomResource(javaResource, IndexMapper) {
    /**
     * The Amazon Resource Name (ARN) of the Index.
     */
    public val arn: Output<String>
        get() = javaResource.arn().applyValue({ args0 -> args0 })

    /**
     * A block that sets the number of additional document storage and query capacity units that should be used by the index. Detailed below.
     */
    public val capacityUnits: Output<IndexCapacityUnits>
        get() = javaResource.capacityUnits().applyValue({ args0 ->
            args0.let({ args0 ->
                indexCapacityUnitsToKotlin(args0)
            })
        })

    /**
     * The Unix datetime that the index was created.
     */
    public val createdAt: Output<String>
        get() = javaResource.createdAt().applyValue({ args0 -> args0 })

    /**
     * The description of the Index.
     */
    public val description: Output<String>?
        get() = javaResource.description().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * One or more blocks that specify the configuration settings for any metadata applied to the documents in the index. Minimum number of 0 items. Maximum number of 500 items. If specified, you must define all elements, including those that are provided by default. These index fields are documented at [Amazon Kendra Index documentation](https://docs.aws.amazon.com/kendra/latest/dg/hiw-index.html). For an example resource that defines these default index fields, refer to the default example above. For an example resource that appends additional index fields, refer to the append example above. All arguments for each block must be specified. Note that blocks cannot be removed since index fields cannot be deleted. This argument is detailed below.
     */
    public val documentMetadataConfigurationUpdates:
        Output<List<IndexDocumentMetadataConfigurationUpdate>>
        get() = javaResource.documentMetadataConfigurationUpdates().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    indexDocumentMetadataConfigurationUpdateToKotlin(args0)
                })
            })
        })

    /**
     * The Amazon Kendra edition to use for the index. Choose `DEVELOPER_EDITION` for indexes intended for development, testing, or proof of concept. Use `ENTERPRISE_EDITION` for your production databases. Once you set the edition for an index, it can't be changed. Defaults to `ENTERPRISE_EDITION`
     */
    public val edition: Output<String>?
        get() = javaResource.edition().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * When the Status field value is `FAILED`, this contains a message that explains why.
     */
    public val errorMessage: Output<String>
        get() = javaResource.errorMessage().applyValue({ args0 -> args0 })

    /**
     * A block that provides information about the number of FAQ questions and answers and the number of text documents indexed. Detailed below.
     */
    public val indexStatistics: Output<List<IndexIndexStatistic>>
        get() = javaResource.indexStatistics().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> indexIndexStatisticToKotlin(args0) })
            })
        })

    /**
     * Specifies the name of the Index.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * An AWS Identity and Access Management (IAM) role that gives Amazon Kendra permissions to access your Amazon CloudWatch logs and metrics. This is also the role you use when you call the `BatchPutDocument` API to index documents from an Amazon S3 bucket.
     */
    public val roleArn: Output<String>
        get() = javaResource.roleArn().applyValue({ args0 -> args0 })

    /**
     * A block that specifies the identifier of the AWS KMS customer managed key (CMK) that's used to encrypt data indexed by Amazon Kendra. Amazon Kendra doesn't support asymmetric CMKs. Detailed below.
     */
    public val serverSideEncryptionConfiguration: Output<IndexServerSideEncryptionConfiguration>?
        get() = javaResource.serverSideEncryptionConfiguration().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    indexServerSideEncryptionConfigurationToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * The current status of the index. When the value is `ACTIVE`, the index is ready for use. If the Status field value is `FAILED`, the `error_message` field contains a message that explains why.
     */
    public val status: Output<String>
        get() = javaResource.status().applyValue({ args0 -> args0 })

    /**
     * Tags to apply to the Index. If configured with a provider
     * `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
     */
    @Deprecated(
        message = """
  Please use `tags` instead.
  """,
    )
    public val tagsAll: Output<Map<String, String>>
        get() = javaResource.tagsAll().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.key.to(args0.value)
            }).toMap()
        })

    /**
     * The Unix datetime that the index was last updated.
     */
    public val updatedAt: Output<String>
        get() = javaResource.updatedAt().applyValue({ args0 -> args0 })

    /**
     * The user context policy. Valid values are `ATTRIBUTE_FILTER` or `USER_TOKEN`. For more information, refer to [UserContextPolicy](https://docs.aws.amazon.com/kendra/latest/APIReference/API_CreateIndex.html#kendra-CreateIndex-request-UserContextPolicy). Defaults to `ATTRIBUTE_FILTER`.
     */
    public val userContextPolicy: Output<String>?
        get() = javaResource.userContextPolicy().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * A block that enables fetching access levels of groups and users from an AWS Single Sign-On identity source. To configure this, see [UserGroupResolutionConfiguration](https://docs.aws.amazon.com/kendra/latest/dg/API_UserGroupResolutionConfiguration.html). Detailed below.
     */
    public val userGroupResolutionConfiguration: Output<IndexUserGroupResolutionConfiguration>?
        get() = javaResource.userGroupResolutionConfiguration().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> indexUserGroupResolutionConfigurationToKotlin(args0) })
            }).orElse(null)
        })

    /**
     * A block that specifies the user token configuration. Detailed below.
     */
    public val userTokenConfigurations: Output<IndexUserTokenConfigurations>?
        get() = javaResource.userTokenConfigurations().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> indexUserTokenConfigurationsToKotlin(args0) })
            }).orElse(null)
        })
}

public object IndexMapper : ResourceMapper<Index> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.kendra.Index::class == javaResource::class

    override fun map(javaResource: Resource): Index = Index(
        javaResource as
            com.pulumi.aws.kendra.Index,
    )
}

/**
 * @see [Index].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [Index].
 */
public suspend fun index(name: String, block: suspend IndexResourceBuilder.() -> Unit): Index {
    val builder = IndexResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [Index].
 * @param name The _unique_ name of the resulting resource.
 */
public fun index(name: String): Index {
    val builder = IndexResourceBuilder()
    builder.name(name)
    return builder.build()
}
