@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.kendra.kotlin

import com.pulumi.aws.kendra.IndexArgs.builder
import com.pulumi.aws.kendra.kotlin.inputs.IndexCapacityUnitsArgs
import com.pulumi.aws.kendra.kotlin.inputs.IndexCapacityUnitsArgsBuilder
import com.pulumi.aws.kendra.kotlin.inputs.IndexDocumentMetadataConfigurationUpdateArgs
import com.pulumi.aws.kendra.kotlin.inputs.IndexDocumentMetadataConfigurationUpdateArgsBuilder
import com.pulumi.aws.kendra.kotlin.inputs.IndexServerSideEncryptionConfigurationArgs
import com.pulumi.aws.kendra.kotlin.inputs.IndexServerSideEncryptionConfigurationArgsBuilder
import com.pulumi.aws.kendra.kotlin.inputs.IndexUserGroupResolutionConfigurationArgs
import com.pulumi.aws.kendra.kotlin.inputs.IndexUserGroupResolutionConfigurationArgsBuilder
import com.pulumi.aws.kendra.kotlin.inputs.IndexUserTokenConfigurationsArgs
import com.pulumi.aws.kendra.kotlin.inputs.IndexUserTokenConfigurationsArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Provides an Amazon Kendra Index resource.
 * ## Example Usage
 * ### Basic
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.kendra.Index;
 * import com.pulumi.aws.kendra.IndexArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new Index("example", IndexArgs.builder()
 *             .description("example")
 *             .edition("DEVELOPER_EDITION")
 *             .roleArn(aws_iam_role.this().arn())
 *             .tags(Map.of("Key1", "Value1"))
 *             .build());
 *     }
 * }
 * ```
 * ### With capacity units
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.kendra.Index;
 * import com.pulumi.aws.kendra.IndexArgs;
 * import com.pulumi.aws.kendra.inputs.IndexCapacityUnitsArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new Index("example", IndexArgs.builder()
 *             .edition("DEVELOPER_EDITION")
 *             .roleArn(aws_iam_role.this().arn())
 *             .capacityUnits(IndexCapacityUnitsArgs.builder()
 *                 .queryCapacityUnits(2)
 *                 .storageCapacityUnits(2)
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ### With server side encryption configuration
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.kendra.Index;
 * import com.pulumi.aws.kendra.IndexArgs;
 * import com.pulumi.aws.kendra.inputs.IndexServerSideEncryptionConfigurationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new Index("example", IndexArgs.builder()
 *             .roleArn(aws_iam_role.this().arn())
 *             .serverSideEncryptionConfiguration(IndexServerSideEncryptionConfigurationArgs.builder()
 *                 .kmsKeyId(data.aws_kms_key().this().arn())
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ### With user group resolution configuration
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.kendra.Index;
 * import com.pulumi.aws.kendra.IndexArgs;
 * import com.pulumi.aws.kendra.inputs.IndexUserGroupResolutionConfigurationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new Index("example", IndexArgs.builder()
 *             .roleArn(aws_iam_role.this().arn())
 *             .userGroupResolutionConfiguration(IndexUserGroupResolutionConfigurationArgs.builder()
 *                 .userGroupResolutionMode("AWS_SSO")
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ### Specifying the predefined elements
 * Refer to [Amazon Kendra documentation on built-in document fields](https://docs.aws.amazon.com/kendra/latest/dg/hiw-index.html#index-reserved-fields) for more information.
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.kendra.Index;
 * import com.pulumi.aws.kendra.IndexArgs;
 * import com.pulumi.aws.kendra.inputs.IndexDocumentMetadataConfigurationUpdateArgs;
 * import com.pulumi.aws.kendra.inputs.IndexDocumentMetadataConfigurationUpdateSearchArgs;
 * import com.pulumi.aws.kendra.inputs.IndexDocumentMetadataConfigurationUpdateRelevanceArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new Index("example", IndexArgs.builder()
 *             .roleArn(aws_iam_role.this().arn())
 *             .documentMetadataConfigurationUpdates(
 *                 IndexDocumentMetadataConfigurationUpdateArgs.builder()
 *                     .name("_authors")
 *                     .type("STRING_LIST_VALUE")
 *                     .search(IndexDocumentMetadataConfigurationUpdateSearchArgs.builder()
 *                         .displayable(false)
 *                         .facetable(false)
 *                         .searchable(false)
 *                         .sortable(false)
 *                         .build())
 *                     .relevance(IndexDocumentMetadataConfigurationUpdateRelevanceArgs.builder()
 *                         .importance(1)
 *                         .build())
 *                     .build(),
 *                 IndexDocumentMetadataConfigurationUpdateArgs.builder()
 *                     .name("_category")
 *                     .type("STRING_VALUE")
 *                     .search(IndexDocumentMetadataConfigurationUpdateSearchArgs.builder()
 *                         .displayable(false)
 *                         .facetable(false)
 *                         .searchable(false)
 *                         .sortable(true)
 *                         .build())
 *                     .relevance(IndexDocumentMetadataConfigurationUpdateRelevanceArgs.builder()
 *                         .importance(1)
 *                         .valuesImportanceMap()
 *                         .build())
 *                     .build(),
 *                 IndexDocumentMetadataConfigurationUpdateArgs.builder()
 *                     .name("_created_at")
 *                     .type("DATE_VALUE")
 *                     .search(IndexDocumentMetadataConfigurationUpdateSearchArgs.builder()
 *                         .displayable(false)
 *                         .facetable(false)
 *                         .searchable(false)
 *                         .sortable(true)
 *                         .build())
 *                     .relevance(IndexDocumentMetadataConfigurationUpdateRelevanceArgs.builder()
 *                         .freshness(false)
 *                         .importance(1)
 *                         .duration("25920000s")
 *                         .rankOrder("ASCENDING")
 *                         .build())
 *                     .build(),
 *                 IndexDocumentMetadataConfigurationUpdateArgs.builder()
 *                     .name("_data_source_id")
 *                     .type("STRING_VALUE")
 *                     .search(IndexDocumentMetadataConfigurationUpdateSearchArgs.builder()
 *                         .displayable(false)
 *                         .facetable(false)
 *                         .searchable(false)
 *                         .sortable(true)
 *                         .build())
 *                     .relevance(IndexDocumentMetadataConfigurationUpdateRelevanceArgs.builder()
 *                         .importance(1)
 *                         .valuesImportanceMap()
 *                         .build())
 *                     .build(),
 *                 IndexDocumentMetadataConfigurationUpdateArgs.builder()
 *                     .name("_document_title")
 *                     .type("STRING_VALUE")
 *                     .search(IndexDocumentMetadataConfigurationUpdateSearchArgs.builder()
 *                         .displayable(true)
 *                         .facetable(false)
 *                         .searchable(true)
 *                         .sortable(true)
 *                         .build())
 *                     .relevance(IndexDocumentMetadataConfigurationUpdateRelevanceArgs.builder()
 *                         .importance(2)
 *                         .valuesImportanceMap()
 *                         .build())
 *                     .build(),
 *                 IndexDocumentMetadataConfigurationUpdateArgs.builder()
 *                     .name("_excerpt_page_number")
 *                     .type("LONG_VALUE")
 *                     .search(IndexDocumentMetadataConfigurationUpdateSearchArgs.builder()
 *                         .displayable(false)
 *                         .facetable(false)
 *                         .searchable(false)
 *                         .sortable(false)
 *                         .build())
 *                     .relevance(IndexDocumentMetadataConfigurationUpdateRelevanceArgs.builder()
 *                         .importance(2)
 *                         .rankOrder("ASCENDING")
 *                         .build())
 *                     .build(),
 *                 IndexDocumentMetadataConfigurationUpdateArgs.builder()
 *                     .name("_faq_id")
 *                     .type("STRING_VALUE")
 *                     .search(IndexDocumentMetadataConfigurationUpdateSearchArgs.builder()
 *                         .displayable(false)
 *                         .facetable(false)
 *                         .searchable(false)
 *                         .sortable(true)
 *                         .build())
 *                     .relevance(IndexDocumentMetadataConfigurationUpdateRelevanceArgs.builder()
 *                         .importance(1)
 *                         .valuesImportanceMap()
 *                         .build())
 *                     .build(),
 *                 IndexDocumentMetadataConfigurationUpdateArgs.builder()
 *                     .name("_file_type")
 *                     .type("STRING_VALUE")
 *                     .search(IndexDocumentMetadataConfigurationUpdateSearchArgs.builder()
 *                         .displayable(false)
 *                         .facetable(false)
 *                         .searchable(false)
 *                         .sortable(true)
 *                         .build())
 *                     .relevance(IndexDocumentMetadataConfigurationUpdateRelevanceArgs.builder()
 *                         .importance(1)
 *                         .valuesImportanceMap()
 *                         .build())
 *                     .build(),
 *                 IndexDocumentMetadataConfigurationUpdateArgs.builder()
 *                     .name("_language_code")
 *                     .type("STRING_VALUE")
 *                     .search(IndexDocumentMetadataConfigurationUpdateSearchArgs.builder()
 *                         .displayable(false)
 *                         .facetable(false)
 *                         .searchable(false)
 *                         .sortable(true)
 *                         .build())
 *                     .relevance(IndexDocumentMetadataConfigurationUpdateRelevanceArgs.builder()
 *                         .importance(1)
 *                         .valuesImportanceMap()
 *                         .build())
 *                     .build(),
 *                 IndexDocumentMetadataConfigurationUpdateArgs.builder()
 *                     .name("_last_updated_at")
 *                     .type("DATE_VALUE")
 *                     .search(IndexDocumentMetadataConfigurationUpdateSearchArgs.builder()
 *                         .displayable(false)
 *                         .facetable(false)
 *                         .searchable(false)
 *                         .sortable(true)
 *                         .build())
 *                     .relevance(IndexDocumentMetadataConfigurationUpdateRelevanceArgs.builder()
 *                         .freshness(false)
 *                         .importance(1)
 *                         .duration("25920000s")
 *                         .rankOrder("ASCENDING")
 *                         .build())
 *                     .build(),
 *                 IndexDocumentMetadataConfigurationUpdateArgs.builder()
 *                     .name("_source_uri")
 *                     .type("STRING_VALUE")
 *                     .search(IndexDocumentMetadataConfigurationUpdateSearchArgs.builder()
 *                         .displayable(true)
 *                         .facetable(false)
 *                         .searchable(false)
 *                         .sortable(false)
 *                         .build())
 *                     .relevance(IndexDocumentMetadataConfigurationUpdateRelevanceArgs.builder()
 *                         .importance(1)
 *                         .valuesImportanceMap()
 *                         .build())
 *                     .build(),
 *                 IndexDocumentMetadataConfigurationUpdateArgs.builder()
 *                     .name("_tenant_id")
 *                     .type("STRING_VALUE")
 *                     .search(IndexDocumentMetadataConfigurationUpdateSearchArgs.builder()
 *                         .displayable(false)
 *                         .facetable(false)
 *                         .searchable(false)
 *                         .sortable(true)
 *                         .build())
 *                     .relevance(IndexDocumentMetadataConfigurationUpdateRelevanceArgs.builder()
 *                         .importance(1)
 *                         .valuesImportanceMap()
 *                         .build())
 *                     .build(),
 *                 IndexDocumentMetadataConfigurationUpdateArgs.builder()
 *                     .name("_version")
 *                     .type("STRING_VALUE")
 *                     .search(IndexDocumentMetadataConfigurationUpdateSearchArgs.builder()
 *                         .displayable(false)
 *                         .facetable(false)
 *                         .searchable(false)
 *                         .sortable(true)
 *                         .build())
 *                     .relevance(IndexDocumentMetadataConfigurationUpdateRelevanceArgs.builder()
 *                         .importance(1)
 *                         .valuesImportanceMap()
 *                         .build())
 *                     .build(),
 *                 IndexDocumentMetadataConfigurationUpdateArgs.builder()
 *                     .name("_view_count")
 *                     .type("LONG_VALUE")
 *                     .search(IndexDocumentMetadataConfigurationUpdateSearchArgs.builder()
 *                         .displayable(false)
 *                         .facetable(false)
 *                         .searchable(false)
 *                         .sortable(true)
 *                         .build())
 *                     .relevance(IndexDocumentMetadataConfigurationUpdateRelevanceArgs.builder()
 *                         .importance(1)
 *                         .rankOrder("ASCENDING")
 *                         .build())
 *                     .build())
 *             .build());
 *     }
 * }
 * ```
 * ### Appending additional elements
 * The example below shows additional elements with names, `example-string-value`, `example-long-value`, `example-string-list-value`, `example-date-value` representing the 4 types of `STRING_VALUE`, `LONG_VALUE`, `STRING_LIST_VALUE`, `DATE_VALUE` respectively.
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.kendra.Index;
 * import com.pulumi.aws.kendra.IndexArgs;
 * import com.pulumi.aws.kendra.inputs.IndexDocumentMetadataConfigurationUpdateArgs;
 * import com.pulumi.aws.kendra.inputs.IndexDocumentMetadataConfigurationUpdateSearchArgs;
 * import com.pulumi.aws.kendra.inputs.IndexDocumentMetadataConfigurationUpdateRelevanceArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new Index("example", IndexArgs.builder()
 *             .roleArn(aws_iam_role.this().arn())
 *             .documentMetadataConfigurationUpdates(
 *                 IndexDocumentMetadataConfigurationUpdateArgs.builder()
 *                     .name("_authors")
 *                     .type("STRING_LIST_VALUE")
 *                     .search(IndexDocumentMetadataConfigurationUpdateSearchArgs.builder()
 *                         .displayable(false)
 *                         .facetable(false)
 *                         .searchable(false)
 *                         .sortable(false)
 *                         .build())
 *                     .relevance(IndexDocumentMetadataConfigurationUpdateRelevanceArgs.builder()
 *                         .importance(1)
 *                         .build())
 *                     .build(),
 *                 IndexDocumentMetadataConfigurationUpdateArgs.builder()
 *                     .name("_category")
 *                     .type("STRING_VALUE")
 *                     .search(IndexDocumentMetadataConfigurationUpdateSearchArgs.builder()
 *                         .displayable(false)
 *                         .facetable(false)
 *                         .searchable(false)
 *                         .sortable(true)
 *                         .build())
 *                     .relevance(IndexDocumentMetadataConfigurationUpdateRelevanceArgs.builder()
 *                         .importance(1)
 *                         .valuesImportanceMap()
 *                         .build())
 *                     .build(),
 *                 IndexDocumentMetadataConfigurationUpdateArgs.builder()
 *                     .name("_created_at")
 *                     .type("DATE_VALUE")
 *                     .search(IndexDocumentMetadataConfigurationUpdateSearchArgs.builder()
 *                         .displayable(false)
 *                         .facetable(false)
 *                         .searchable(false)
 *                         .sortable(true)
 *                         .build())
 *                     .relevance(IndexDocumentMetadataConfigurationUpdateRelevanceArgs.builder()
 *                         .freshness(false)
 *                         .importance(1)
 *                         .duration("25920000s")
 *                         .rankOrder("ASCENDING")
 *                         .build())
 *                     .build(),
 *                 IndexDocumentMetadataConfigurationUpdateArgs.builder()
 *                     .name("_data_source_id")
 *                     .type("STRING_VALUE")
 *                     .search(IndexDocumentMetadataConfigurationUpdateSearchArgs.builder()
 *                         .displayable(false)
 *                         .facetable(false)
 *                         .searchable(false)
 *                         .sortable(true)
 *                         .build())
 *                     .relevance(IndexDocumentMetadataConfigurationUpdateRelevanceArgs.builder()
 *                         .importance(1)
 *                         .valuesImportanceMap()
 *                         .build())
 *                     .build(),
 *                 IndexDocumentMetadataConfigurationUpdateArgs.builder()
 *                     .name("_document_title")
 *                     .type("STRING_VALUE")
 *                     .search(IndexDocumentMetadataConfigurationUpdateSearchArgs.builder()
 *                         .displayable(true)
 *                         .facetable(false)
 *                         .searchable(true)
 *                         .sortable(true)
 *                         .build())
 *                     .relevance(IndexDocumentMetadataConfigurationUpdateRelevanceArgs.builder()
 *                         .importance(2)
 *                         .valuesImportanceMap()
 *                         .build())
 *                     .build(),
 *                 IndexDocumentMetadataConfigurationUpdateArgs.builder()
 *                     .name("_excerpt_page_number")
 *                     .type("LONG_VALUE")
 *                     .search(IndexDocumentMetadataConfigurationUpdateSearchArgs.builder()
 *                         .displayable(false)
 *                         .facetable(false)
 *                         .searchable(false)
 *                         .sortable(false)
 *                         .build())
 *                     .relevance(IndexDocumentMetadataConfigurationUpdateRelevanceArgs.builder()
 *                         .importance(2)
 *                         .rankOrder("ASCENDING")
 *                         .build())
 *                     .build(),
 *                 IndexDocumentMetadataConfigurationUpdateArgs.builder()
 *                     .name("_faq_id")
 *                     .type("STRING_VALUE")
 *                     .search(IndexDocumentMetadataConfigurationUpdateSearchArgs.builder()
 *                         .displayable(false)
 *                         .facetable(false)
 *                         .searchable(false)
 *                         .sortable(true)
 *                         .build())
 *                     .relevance(IndexDocumentMetadataConfigurationUpdateRelevanceArgs.builder()
 *                         .importance(1)
 *                         .valuesImportanceMap()
 *                         .build())
 *                     .build(),
 *                 IndexDocumentMetadataConfigurationUpdateArgs.builder()
 *                     .name("_file_type")
 *                     .type("STRING_VALUE")
 *                     .search(IndexDocumentMetadataConfigurationUpdateSearchArgs.builder()
 *                         .displayable(false)
 *                         .facetable(false)
 *                         .searchable(false)
 *                         .sortable(true)
 *                         .build())
 *                     .relevance(IndexDocumentMetadataConfigurationUpdateRelevanceArgs.builder()
 *                         .importance(1)
 *                         .valuesImportanceMap()
 *                         .build())
 *                     .build(),
 *                 IndexDocumentMetadataConfigurationUpdateArgs.builder()
 *                     .name("_language_code")
 *                     .type("STRING_VALUE")
 *                     .search(IndexDocumentMetadataConfigurationUpdateSearchArgs.builder()
 *                         .displayable(false)
 *                         .facetable(false)
 *                         .searchable(false)
 *                         .sortable(true)
 *                         .build())
 *                     .relevance(IndexDocumentMetadataConfigurationUpdateRelevanceArgs.builder()
 *                         .importance(1)
 *                         .valuesImportanceMap()
 *                         .build())
 *                     .build(),
 *                 IndexDocumentMetadataConfigurationUpdateArgs.builder()
 *                     .name("_last_updated_at")
 *                     .type("DATE_VALUE")
 *                     .search(IndexDocumentMetadataConfigurationUpdateSearchArgs.builder()
 *                         .displayable(false)
 *                         .facetable(false)
 *                         .searchable(false)
 *                         .sortable(true)
 *                         .build())
 *                     .relevance(IndexDocumentMetadataConfigurationUpdateRelevanceArgs.builder()
 *                         .freshness(false)
 *                         .importance(1)
 *                         .duration("25920000s")
 *                         .rankOrder("ASCENDING")
 *                         .build())
 *                     .build(),
 *                 IndexDocumentMetadataConfigurationUpdateArgs.builder()
 *                     .name("_source_uri")
 *                     .type("STRING_VALUE")
 *                     .search(IndexDocumentMetadataConfigurationUpdateSearchArgs.builder()
 *                         .displayable(true)
 *                         .facetable(false)
 *                         .searchable(false)
 *                         .sortable(false)
 *                         .build())
 *                     .relevance(IndexDocumentMetadataConfigurationUpdateRelevanceArgs.builder()
 *                         .importance(1)
 *                         .valuesImportanceMap()
 *                         .build())
 *                     .build(),
 *                 IndexDocumentMetadataConfigurationUpdateArgs.builder()
 *                     .name("_tenant_id")
 *                     .type("STRING_VALUE")
 *                     .search(IndexDocumentMetadataConfigurationUpdateSearchArgs.builder()
 *                         .displayable(false)
 *                         .facetable(false)
 *                         .searchable(false)
 *                         .sortable(true)
 *                         .build())
 *                     .relevance(IndexDocumentMetadataConfigurationUpdateRelevanceArgs.builder()
 *                         .importance(1)
 *                         .valuesImportanceMap()
 *                         .build())
 *                     .build(),
 *                 IndexDocumentMetadataConfigurationUpdateArgs.builder()
 *                     .name("_version")
 *                     .type("STRING_VALUE")
 *                     .search(IndexDocumentMetadataConfigurationUpdateSearchArgs.builder()
 *                         .displayable(false)
 *                         .facetable(false)
 *                         .searchable(false)
 *                         .sortable(true)
 *                         .build())
 *                     .relevance(IndexDocumentMetadataConfigurationUpdateRelevanceArgs.builder()
 *                         .importance(1)
 *                         .valuesImportanceMap()
 *                         .build())
 *                     .build(),
 *                 IndexDocumentMetadataConfigurationUpdateArgs.builder()
 *                     .name("_view_count")
 *                     .type("LONG_VALUE")
 *                     .search(IndexDocumentMetadataConfigurationUpdateSearchArgs.builder()
 *                         .displayable(false)
 *                         .facetable(false)
 *                         .searchable(false)
 *                         .sortable(true)
 *                         .build())
 *                     .relevance(IndexDocumentMetadataConfigurationUpdateRelevanceArgs.builder()
 *                         .importance(1)
 *                         .rankOrder("ASCENDING")
 *                         .build())
 *                     .build(),
 *                 IndexDocumentMetadataConfigurationUpdateArgs.builder()
 *                     .name("example-string-value")
 *                     .type("STRING_VALUE")
 *                     .search(IndexDocumentMetadataConfigurationUpdateSearchArgs.builder()
 *                         .displayable(true)
 *                         .facetable(true)
 *                         .searchable(true)
 *                         .sortable(true)
 *                         .build())
 *                     .relevance(IndexDocumentMetadataConfigurationUpdateRelevanceArgs.builder()
 *                         .importance(1)
 *                         .valuesImportanceMap()
 *                         .build())
 *                     .build(),
 *                 IndexDocumentMetadataConfigurationUpdateArgs.builder()
 *                     .name("example-long-value")
 *                     .type("LONG_VALUE")
 *                     .search(IndexDocumentMetadataConfigurationUpdateSearchArgs.builder()
 *                         .displayable(true)
 *                         .facetable(true)
 *                         .searchable(false)
 *                         .sortable(true)
 *                         .build())
 *                     .relevance(IndexDocumentMetadataConfigurationUpdateRelevanceArgs.builder()
 *                         .importance(1)
 *                         .rankOrder("ASCENDING")
 *                         .build())
 *                     .build(),
 *                 IndexDocumentMetadataConfigurationUpdateArgs.builder()
 *                     .name("example-string-list-value")
 *                     .type("STRING_LIST_VALUE")
 *                     .search(IndexDocumentMetadataConfigurationUpdateSearchArgs.builder()
 *                         .displayable(true)
 *                         .facetable(true)
 *                         .searchable(true)
 *                         .sortable(false)
 *                         .build())
 *                     .relevance(IndexDocumentMetadataConfigurationUpdateRelevanceArgs.builder()
 *                         .importance(1)
 *                         .build())
 *                     .build(),
 *                 IndexDocumentMetadataConfigurationUpdateArgs.builder()
 *                     .name("example-date-value")
 *                     .type("DATE_VALUE")
 *                     .search(IndexDocumentMetadataConfigurationUpdateSearchArgs.builder()
 *                         .displayable(true)
 *                         .facetable(true)
 *                         .searchable(false)
 *                         .sortable(false)
 *                         .build())
 *                     .relevance(IndexDocumentMetadataConfigurationUpdateRelevanceArgs.builder()
 *                         .freshness(false)
 *                         .importance(1)
 *                         .duration("25920000s")
 *                         .rankOrder("ASCENDING")
 *                         .build())
 *                     .build())
 *             .build());
 *     }
 * }
 * ```
 * ### With JSON token type configuration
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.kendra.Index;
 * import com.pulumi.aws.kendra.IndexArgs;
 * import com.pulumi.aws.kendra.inputs.IndexUserTokenConfigurationsArgs;
 * import com.pulumi.aws.kendra.inputs.IndexUserTokenConfigurationsJsonTokenTypeConfigurationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new Index("example", IndexArgs.builder()
 *             .roleArn(aws_iam_role.this().arn())
 *             .userTokenConfigurations(IndexUserTokenConfigurationsArgs.builder()
 *                 .jsonTokenTypeConfiguration(IndexUserTokenConfigurationsJsonTokenTypeConfigurationArgs.builder()
 *                     .groupAttributeField("groups")
 *                     .userNameAttributeField("username")
 *                     .build())
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import Amazon Kendra Indexes using its `id`. For example:
 * ```sh
 *  $ pulumi import aws:kendra/index:Index example 12345678-1234-5678-9123-123456789123
 * ```
 * @property capacityUnits A block that sets the number of additional document storage and query capacity units that should be used by the index. Detailed below.
 * @property description The description of the Index.
 * @property documentMetadataConfigurationUpdates One or more blocks that specify the configuration settings for any metadata applied to the documents in the index. Minimum number of 0 items. Maximum number of 500 items. If specified, you must define all elements, including those that are provided by default. These index fields are documented at [Amazon Kendra Index documentation](https://docs.aws.amazon.com/kendra/latest/dg/hiw-index.html). For an example resource that defines these default index fields, refer to the default example above. For an example resource that appends additional index fields, refer to the append example above. All arguments for each block must be specified. Note that blocks cannot be removed since index fields cannot be deleted. This argument is detailed below.
 * @property edition The Amazon Kendra edition to use for the index. Choose `DEVELOPER_EDITION` for indexes intended for development, testing, or proof of concept. Use `ENTERPRISE_EDITION` for your production databases. Once you set the edition for an index, it can't be changed. Defaults to `ENTERPRISE_EDITION`
 * @property name Specifies the name of the Index.
 * @property roleArn An AWS Identity and Access Management (IAM) role that gives Amazon Kendra permissions to access your Amazon CloudWatch logs and metrics. This is also the role you use when you call the `BatchPutDocument` API to index documents from an Amazon S3 bucket.
 * @property serverSideEncryptionConfiguration A block that specifies the identifier of the AWS KMS customer managed key (CMK) that's used to encrypt data indexed by Amazon Kendra. Amazon Kendra doesn't support asymmetric CMKs. Detailed below.
 * @property tags Tags to apply to the Index. If configured with a provider
 * `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
 * @property userContextPolicy The user context policy. Valid values are `ATTRIBUTE_FILTER` or `USER_TOKEN`. For more information, refer to [UserContextPolicy](https://docs.aws.amazon.com/kendra/latest/APIReference/API_CreateIndex.html#kendra-CreateIndex-request-UserContextPolicy). Defaults to `ATTRIBUTE_FILTER`.
 * @property userGroupResolutionConfiguration A block that enables fetching access levels of groups and users from an AWS Single Sign-On identity source. To configure this, see [UserGroupResolutionConfiguration](https://docs.aws.amazon.com/kendra/latest/dg/API_UserGroupResolutionConfiguration.html). Detailed below.
 * @property userTokenConfigurations A block that specifies the user token configuration. Detailed below.
 */
public data class IndexArgs(
    public val capacityUnits: Output<IndexCapacityUnitsArgs>? = null,
    public val description: Output<String>? = null,
    public val documentMetadataConfigurationUpdates:
    Output<List<IndexDocumentMetadataConfigurationUpdateArgs>>? = null,
    public val edition: Output<String>? = null,
    public val name: Output<String>? = null,
    public val roleArn: Output<String>? = null,
    public val serverSideEncryptionConfiguration: Output<IndexServerSideEncryptionConfigurationArgs>? =
        null,
    public val tags: Output<Map<String, String>>? = null,
    public val userContextPolicy: Output<String>? = null,
    public val userGroupResolutionConfiguration: Output<IndexUserGroupResolutionConfigurationArgs>? =
        null,
    public val userTokenConfigurations: Output<IndexUserTokenConfigurationsArgs>? = null,
) : ConvertibleToJava<com.pulumi.aws.kendra.IndexArgs> {
    override fun toJava(): com.pulumi.aws.kendra.IndexArgs = com.pulumi.aws.kendra.IndexArgs.builder()
        .capacityUnits(capacityUnits?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
        .description(description?.applyValue({ args0 -> args0 }))
        .documentMetadataConfigurationUpdates(
            documentMetadataConfigurationUpdates?.applyValue({ args0 ->
                args0.map({ args0 -> args0.let({ args0 -> args0.toJava() }) })
            }),
        )
        .edition(edition?.applyValue({ args0 -> args0 }))
        .name(name?.applyValue({ args0 -> args0 }))
        .roleArn(roleArn?.applyValue({ args0 -> args0 }))
        .serverSideEncryptionConfiguration(
            serverSideEncryptionConfiguration?.applyValue({ args0 ->
                args0.let({ args0 -> args0.toJava() })
            }),
        )
        .tags(tags?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
        .userContextPolicy(userContextPolicy?.applyValue({ args0 -> args0 }))
        .userGroupResolutionConfiguration(
            userGroupResolutionConfiguration?.applyValue({ args0 ->
                args0.let({ args0 -> args0.toJava() })
            }),
        )
        .userTokenConfigurations(
            userTokenConfigurations?.applyValue({ args0 ->
                args0.let({ args0 ->
                    args0.toJava()
                })
            }),
        ).build()
}

/**
 * Builder for [IndexArgs].
 */
@PulumiTagMarker
public class IndexArgsBuilder internal constructor() {
    private var capacityUnits: Output<IndexCapacityUnitsArgs>? = null

    private var description: Output<String>? = null

    private var documentMetadataConfigurationUpdates:
        Output<List<IndexDocumentMetadataConfigurationUpdateArgs>>? = null

    private var edition: Output<String>? = null

    private var name: Output<String>? = null

    private var roleArn: Output<String>? = null

    private var serverSideEncryptionConfiguration: Output<IndexServerSideEncryptionConfigurationArgs>? =
        null

    private var tags: Output<Map<String, String>>? = null

    private var userContextPolicy: Output<String>? = null

    private var userGroupResolutionConfiguration: Output<IndexUserGroupResolutionConfigurationArgs>? =
        null

    private var userTokenConfigurations: Output<IndexUserTokenConfigurationsArgs>? = null

    /**
     * @param value A block that sets the number of additional document storage and query capacity units that should be used by the index. Detailed below.
     */
    @JvmName("wjcvunhdyonjcjop")
    public suspend fun capacityUnits(`value`: Output<IndexCapacityUnitsArgs>) {
        this.capacityUnits = value
    }

    /**
     * @param value The description of the Index.
     */
    @JvmName("sufoauiqvjflnkmk")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value One or more blocks that specify the configuration settings for any metadata applied to the documents in the index. Minimum number of 0 items. Maximum number of 500 items. If specified, you must define all elements, including those that are provided by default. These index fields are documented at [Amazon Kendra Index documentation](https://docs.aws.amazon.com/kendra/latest/dg/hiw-index.html). For an example resource that defines these default index fields, refer to the default example above. For an example resource that appends additional index fields, refer to the append example above. All arguments for each block must be specified. Note that blocks cannot be removed since index fields cannot be deleted. This argument is detailed below.
     */
    @JvmName("fyiuhthmlmsdfvym")
    public suspend
    fun documentMetadataConfigurationUpdates(`value`: Output<List<IndexDocumentMetadataConfigurationUpdateArgs>>) {
        this.documentMetadataConfigurationUpdates = value
    }

    @JvmName("yimkcdudkbnlfbed")
    public suspend fun documentMetadataConfigurationUpdates(
        vararg
        values: Output<IndexDocumentMetadataConfigurationUpdateArgs>,
    ) {
        this.documentMetadataConfigurationUpdates = Output.all(values.asList())
    }

    /**
     * @param values One or more blocks that specify the configuration settings for any metadata applied to the documents in the index. Minimum number of 0 items. Maximum number of 500 items. If specified, you must define all elements, including those that are provided by default. These index fields are documented at [Amazon Kendra Index documentation](https://docs.aws.amazon.com/kendra/latest/dg/hiw-index.html). For an example resource that defines these default index fields, refer to the default example above. For an example resource that appends additional index fields, refer to the append example above. All arguments for each block must be specified. Note that blocks cannot be removed since index fields cannot be deleted. This argument is detailed below.
     */
    @JvmName("ohrkdsxjvdvmkskk")
    public suspend
    fun documentMetadataConfigurationUpdates(values: List<Output<IndexDocumentMetadataConfigurationUpdateArgs>>) {
        this.documentMetadataConfigurationUpdates = Output.all(values)
    }

    /**
     * @param value The Amazon Kendra edition to use for the index. Choose `DEVELOPER_EDITION` for indexes intended for development, testing, or proof of concept. Use `ENTERPRISE_EDITION` for your production databases. Once you set the edition for an index, it can't be changed. Defaults to `ENTERPRISE_EDITION`
     */
    @JvmName("flcbqtocdtocajnd")
    public suspend fun edition(`value`: Output<String>) {
        this.edition = value
    }

    /**
     * @param value Specifies the name of the Index.
     */
    @JvmName("fkjwuaoshkatywal")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value An AWS Identity and Access Management (IAM) role that gives Amazon Kendra permissions to access your Amazon CloudWatch logs and metrics. This is also the role you use when you call the `BatchPutDocument` API to index documents from an Amazon S3 bucket.
     */
    @JvmName("ecoajdgyjfjwyxda")
    public suspend fun roleArn(`value`: Output<String>) {
        this.roleArn = value
    }

    /**
     * @param value A block that specifies the identifier of the AWS KMS customer managed key (CMK) that's used to encrypt data indexed by Amazon Kendra. Amazon Kendra doesn't support asymmetric CMKs. Detailed below.
     */
    @JvmName("wckmbgpgekahyksr")
    public suspend
    fun serverSideEncryptionConfiguration(`value`: Output<IndexServerSideEncryptionConfigurationArgs>) {
        this.serverSideEncryptionConfiguration = value
    }

    /**
     * @param value Tags to apply to the Index. If configured with a provider
     * `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("lrusjkyaeetrvwca")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value The user context policy. Valid values are `ATTRIBUTE_FILTER` or `USER_TOKEN`. For more information, refer to [UserContextPolicy](https://docs.aws.amazon.com/kendra/latest/APIReference/API_CreateIndex.html#kendra-CreateIndex-request-UserContextPolicy). Defaults to `ATTRIBUTE_FILTER`.
     */
    @JvmName("mcutuaswlyabnnra")
    public suspend fun userContextPolicy(`value`: Output<String>) {
        this.userContextPolicy = value
    }

    /**
     * @param value A block that enables fetching access levels of groups and users from an AWS Single Sign-On identity source. To configure this, see [UserGroupResolutionConfiguration](https://docs.aws.amazon.com/kendra/latest/dg/API_UserGroupResolutionConfiguration.html). Detailed below.
     */
    @JvmName("cburmclynktlxglc")
    public suspend
    fun userGroupResolutionConfiguration(`value`: Output<IndexUserGroupResolutionConfigurationArgs>) {
        this.userGroupResolutionConfiguration = value
    }

    /**
     * @param value A block that specifies the user token configuration. Detailed below.
     */
    @JvmName("urunhmgfuakjtojk")
    public suspend fun userTokenConfigurations(`value`: Output<IndexUserTokenConfigurationsArgs>) {
        this.userTokenConfigurations = value
    }

    /**
     * @param value A block that sets the number of additional document storage and query capacity units that should be used by the index. Detailed below.
     */
    @JvmName("oadyhhxijicqvymp")
    public suspend fun capacityUnits(`value`: IndexCapacityUnitsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.capacityUnits = mapped
    }

    /**
     * @param argument A block that sets the number of additional document storage and query capacity units that should be used by the index. Detailed below.
     */
    @JvmName("thvpsajryjygvahg")
    public suspend fun capacityUnits(argument: suspend IndexCapacityUnitsArgsBuilder.() -> Unit) {
        val toBeMapped = IndexCapacityUnitsArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.capacityUnits = mapped
    }

    /**
     * @param value The description of the Index.
     */
    @JvmName("vfdppathardoxbkf")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value One or more blocks that specify the configuration settings for any metadata applied to the documents in the index. Minimum number of 0 items. Maximum number of 500 items. If specified, you must define all elements, including those that are provided by default. These index fields are documented at [Amazon Kendra Index documentation](https://docs.aws.amazon.com/kendra/latest/dg/hiw-index.html). For an example resource that defines these default index fields, refer to the default example above. For an example resource that appends additional index fields, refer to the append example above. All arguments for each block must be specified. Note that blocks cannot be removed since index fields cannot be deleted. This argument is detailed below.
     */
    @JvmName("efxagebhunpryvtc")
    public suspend
    fun documentMetadataConfigurationUpdates(`value`: List<IndexDocumentMetadataConfigurationUpdateArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.documentMetadataConfigurationUpdates = mapped
    }

    /**
     * @param argument One or more blocks that specify the configuration settings for any metadata applied to the documents in the index. Minimum number of 0 items. Maximum number of 500 items. If specified, you must define all elements, including those that are provided by default. These index fields are documented at [Amazon Kendra Index documentation](https://docs.aws.amazon.com/kendra/latest/dg/hiw-index.html). For an example resource that defines these default index fields, refer to the default example above. For an example resource that appends additional index fields, refer to the append example above. All arguments for each block must be specified. Note that blocks cannot be removed since index fields cannot be deleted. This argument is detailed below.
     */
    @JvmName("monkohooxgemfyao")
    public suspend
    fun documentMetadataConfigurationUpdates(argument: List<suspend IndexDocumentMetadataConfigurationUpdateArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            IndexDocumentMetadataConfigurationUpdateArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.documentMetadataConfigurationUpdates = mapped
    }

    /**
     * @param argument One or more blocks that specify the configuration settings for any metadata applied to the documents in the index. Minimum number of 0 items. Maximum number of 500 items. If specified, you must define all elements, including those that are provided by default. These index fields are documented at [Amazon Kendra Index documentation](https://docs.aws.amazon.com/kendra/latest/dg/hiw-index.html). For an example resource that defines these default index fields, refer to the default example above. For an example resource that appends additional index fields, refer to the append example above. All arguments for each block must be specified. Note that blocks cannot be removed since index fields cannot be deleted. This argument is detailed below.
     */
    @JvmName("xydbewljmjwqlavj")
    public suspend fun documentMetadataConfigurationUpdates(
        vararg
        argument: suspend IndexDocumentMetadataConfigurationUpdateArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            IndexDocumentMetadataConfigurationUpdateArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.documentMetadataConfigurationUpdates = mapped
    }

    /**
     * @param argument One or more blocks that specify the configuration settings for any metadata applied to the documents in the index. Minimum number of 0 items. Maximum number of 500 items. If specified, you must define all elements, including those that are provided by default. These index fields are documented at [Amazon Kendra Index documentation](https://docs.aws.amazon.com/kendra/latest/dg/hiw-index.html). For an example resource that defines these default index fields, refer to the default example above. For an example resource that appends additional index fields, refer to the append example above. All arguments for each block must be specified. Note that blocks cannot be removed since index fields cannot be deleted. This argument is detailed below.
     */
    @JvmName("gprjnaqndlqkhcxm")
    public suspend
    fun documentMetadataConfigurationUpdates(argument: suspend IndexDocumentMetadataConfigurationUpdateArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            IndexDocumentMetadataConfigurationUpdateArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.documentMetadataConfigurationUpdates = mapped
    }

    /**
     * @param values One or more blocks that specify the configuration settings for any metadata applied to the documents in the index. Minimum number of 0 items. Maximum number of 500 items. If specified, you must define all elements, including those that are provided by default. These index fields are documented at [Amazon Kendra Index documentation](https://docs.aws.amazon.com/kendra/latest/dg/hiw-index.html). For an example resource that defines these default index fields, refer to the default example above. For an example resource that appends additional index fields, refer to the append example above. All arguments for each block must be specified. Note that blocks cannot be removed since index fields cannot be deleted. This argument is detailed below.
     */
    @JvmName("cvekhntywyenvefp")
    public suspend fun documentMetadataConfigurationUpdates(
        vararg
        values: IndexDocumentMetadataConfigurationUpdateArgs,
    ) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.documentMetadataConfigurationUpdates = mapped
    }

    /**
     * @param value The Amazon Kendra edition to use for the index. Choose `DEVELOPER_EDITION` for indexes intended for development, testing, or proof of concept. Use `ENTERPRISE_EDITION` for your production databases. Once you set the edition for an index, it can't be changed. Defaults to `ENTERPRISE_EDITION`
     */
    @JvmName("wdajdpqmoblfketa")
    public suspend fun edition(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.edition = mapped
    }

    /**
     * @param value Specifies the name of the Index.
     */
    @JvmName("piqwkqernpcieqhr")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value An AWS Identity and Access Management (IAM) role that gives Amazon Kendra permissions to access your Amazon CloudWatch logs and metrics. This is also the role you use when you call the `BatchPutDocument` API to index documents from an Amazon S3 bucket.
     */
    @JvmName("gsdgfafitgyeharv")
    public suspend fun roleArn(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.roleArn = mapped
    }

    /**
     * @param value A block that specifies the identifier of the AWS KMS customer managed key (CMK) that's used to encrypt data indexed by Amazon Kendra. Amazon Kendra doesn't support asymmetric CMKs. Detailed below.
     */
    @JvmName("jxmtnbaiyxauthdb")
    public suspend
    fun serverSideEncryptionConfiguration(`value`: IndexServerSideEncryptionConfigurationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.serverSideEncryptionConfiguration = mapped
    }

    /**
     * @param argument A block that specifies the identifier of the AWS KMS customer managed key (CMK) that's used to encrypt data indexed by Amazon Kendra. Amazon Kendra doesn't support asymmetric CMKs. Detailed below.
     */
    @JvmName("axeghvgqkruungnc")
    public suspend
    fun serverSideEncryptionConfiguration(argument: suspend IndexServerSideEncryptionConfigurationArgsBuilder.() -> Unit) {
        val toBeMapped = IndexServerSideEncryptionConfigurationArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.serverSideEncryptionConfiguration = mapped
    }

    /**
     * @param value Tags to apply to the Index. If configured with a provider
     * `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("opcqrmhmbsrnrtea")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Tags to apply to the Index. If configured with a provider
     * `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("ugfrmrqobnkfqhnd")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param value The user context policy. Valid values are `ATTRIBUTE_FILTER` or `USER_TOKEN`. For more information, refer to [UserContextPolicy](https://docs.aws.amazon.com/kendra/latest/APIReference/API_CreateIndex.html#kendra-CreateIndex-request-UserContextPolicy). Defaults to `ATTRIBUTE_FILTER`.
     */
    @JvmName("bxsuheqeaqdvfsdi")
    public suspend fun userContextPolicy(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.userContextPolicy = mapped
    }

    /**
     * @param value A block that enables fetching access levels of groups and users from an AWS Single Sign-On identity source. To configure this, see [UserGroupResolutionConfiguration](https://docs.aws.amazon.com/kendra/latest/dg/API_UserGroupResolutionConfiguration.html). Detailed below.
     */
    @JvmName("mofbhwltomnkoiuy")
    public suspend
    fun userGroupResolutionConfiguration(`value`: IndexUserGroupResolutionConfigurationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.userGroupResolutionConfiguration = mapped
    }

    /**
     * @param argument A block that enables fetching access levels of groups and users from an AWS Single Sign-On identity source. To configure this, see [UserGroupResolutionConfiguration](https://docs.aws.amazon.com/kendra/latest/dg/API_UserGroupResolutionConfiguration.html). Detailed below.
     */
    @JvmName("frjcbdfuufytikkj")
    public suspend
    fun userGroupResolutionConfiguration(argument: suspend IndexUserGroupResolutionConfigurationArgsBuilder.() -> Unit) {
        val toBeMapped = IndexUserGroupResolutionConfigurationArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.userGroupResolutionConfiguration = mapped
    }

    /**
     * @param value A block that specifies the user token configuration. Detailed below.
     */
    @JvmName("mrkttoqvcnhvnrwq")
    public suspend fun userTokenConfigurations(`value`: IndexUserTokenConfigurationsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.userTokenConfigurations = mapped
    }

    /**
     * @param argument A block that specifies the user token configuration. Detailed below.
     */
    @JvmName("mrgbhvwrpwxrwuop")
    public suspend
    fun userTokenConfigurations(argument: suspend IndexUserTokenConfigurationsArgsBuilder.() -> Unit) {
        val toBeMapped = IndexUserTokenConfigurationsArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.userTokenConfigurations = mapped
    }

    internal fun build(): IndexArgs = IndexArgs(
        capacityUnits = capacityUnits,
        description = description,
        documentMetadataConfigurationUpdates = documentMetadataConfigurationUpdates,
        edition = edition,
        name = name,
        roleArn = roleArn,
        serverSideEncryptionConfiguration = serverSideEncryptionConfiguration,
        tags = tags,
        userContextPolicy = userContextPolicy,
        userGroupResolutionConfiguration = userGroupResolutionConfiguration,
        userTokenConfigurations = userTokenConfigurations,
    )
}
