@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.kendra.kotlin

import com.pulumi.aws.kendra.kotlin.outputs.QuerySuggestionsBlockListSourceS3Path
import com.pulumi.aws.kendra.kotlin.outputs.QuerySuggestionsBlockListSourceS3Path.Companion.toKotlin
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map

/**
 * Builder for [QuerySuggestionsBlockList].
 */
@PulumiTagMarker
public class QuerySuggestionsBlockListResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: QuerySuggestionsBlockListArgs = QuerySuggestionsBlockListArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend QuerySuggestionsBlockListArgsBuilder.() -> Unit) {
        val builder = QuerySuggestionsBlockListArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): QuerySuggestionsBlockList {
        val builtJavaResource = com.pulumi.aws.kendra.QuerySuggestionsBlockList(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return QuerySuggestionsBlockList(builtJavaResource)
    }
}

/**
 * Use the `aws_kendra_index_block_list` resource to manage an AWS Kendra block list used for query suggestions for an index.
 * ## Example Usage
 * ### Basic Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.kendra.QuerySuggestionsBlockList;
 * import com.pulumi.aws.kendra.QuerySuggestionsBlockListArgs;
 * import com.pulumi.aws.kendra.inputs.QuerySuggestionsBlockListSourceS3PathArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new QuerySuggestionsBlockList("example", QuerySuggestionsBlockListArgs.builder()
 *             .indexId(aws_kendra_index.example().id())
 *             .roleArn(aws_iam_role.example().arn())
 *             .sourceS3Path(QuerySuggestionsBlockListSourceS3PathArgs.builder()
 *                 .bucket(aws_s3_bucket.example().id())
 *                 .key("example/suggestions.txt")
 *                 .build())
 *             .tags(Map.of("Name", "Example Kendra Index"))
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import the `aws_kendra_query_suggestions_block_list` resource using the unique identifiers of the block list and index separated by a slash (`/`). For example:
 * ```sh
 *  $ pulumi import aws:kendra/querySuggestionsBlockList:QuerySuggestionsBlockList example blocklist-123456780/idx-8012925589
 * ```
 *
 */
public class QuerySuggestionsBlockList internal constructor(
    override val javaResource: com.pulumi.aws.kendra.QuerySuggestionsBlockList,
) : KotlinCustomResource(javaResource, QuerySuggestionsBlockListMapper) {
    /**
     * ARN of the block list.
     */
    public val arn: Output<String>
        get() = javaResource.arn().applyValue({ args0 -> args0 })

    /**
     * Description for a block list.
     */
    public val description: Output<String>?
        get() = javaResource.description().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Identifier of the index for a block list.
     */
    public val indexId: Output<String>
        get() = javaResource.indexId().applyValue({ args0 -> args0 })

    /**
     * Name for the block list.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Unique identifier of the block list.
     */
    public val querySuggestionsBlockListId: Output<String>
        get() = javaResource.querySuggestionsBlockListId().applyValue({ args0 -> args0 })

    /**
     * IAM (Identity and Access Management) role used to access the block list text file in S3.
     */
    public val roleArn: Output<String>
        get() = javaResource.roleArn().applyValue({ args0 -> args0 })

    /**
     * S3 path where your block list text file is located. See details below.
     * The `source_s3_path` configuration block supports the following arguments:
     */
    public val sourceS3Path: Output<QuerySuggestionsBlockListSourceS3Path>
        get() = javaResource.sourceS3Path().applyValue({ args0 -> args0.let({ args0 -> toKotlin(args0) }) })

    public val status: Output<String>
        get() = javaResource.status().applyValue({ args0 -> args0 })

    /**
     * Key-value map of resource tags. If configured with a provider `default_tags` configuration block, tags with matching keys will overwrite those defined at the provider-level.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * Map of tags assigned to the resource, including those inherited from the provider's default_tags configuration block.
     */
    @Deprecated(
        message = """
  Please use `tags` instead.
  """,
    )
    public val tagsAll: Output<Map<String, String>>
        get() = javaResource.tagsAll().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.key.to(args0.value)
            }).toMap()
        })
}

public object QuerySuggestionsBlockListMapper : ResourceMapper<QuerySuggestionsBlockList> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.kendra.QuerySuggestionsBlockList::class == javaResource::class

    override fun map(javaResource: Resource): QuerySuggestionsBlockList =
        QuerySuggestionsBlockList(javaResource as com.pulumi.aws.kendra.QuerySuggestionsBlockList)
}

/**
 * @see [QuerySuggestionsBlockList].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [QuerySuggestionsBlockList].
 */
public suspend fun querySuggestionsBlockList(
    name: String,
    block: suspend QuerySuggestionsBlockListResourceBuilder.() -> Unit,
): QuerySuggestionsBlockList {
    val builder = QuerySuggestionsBlockListResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [QuerySuggestionsBlockList].
 * @param name The _unique_ name of the resulting resource.
 */
public fun querySuggestionsBlockList(name: String): QuerySuggestionsBlockList {
    val builder = QuerySuggestionsBlockListResourceBuilder()
    builder.name(name)
    return builder.build()
}
