@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.kendra.kotlin

import com.pulumi.aws.kendra.QuerySuggestionsBlockListArgs.builder
import com.pulumi.aws.kendra.kotlin.inputs.QuerySuggestionsBlockListSourceS3PathArgs
import com.pulumi.aws.kendra.kotlin.inputs.QuerySuggestionsBlockListSourceS3PathArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Use the `aws_kendra_index_block_list` resource to manage an AWS Kendra block list used for query suggestions for an index.
 * ## Example Usage
 * ### Basic Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.kendra.QuerySuggestionsBlockList;
 * import com.pulumi.aws.kendra.QuerySuggestionsBlockListArgs;
 * import com.pulumi.aws.kendra.inputs.QuerySuggestionsBlockListSourceS3PathArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new QuerySuggestionsBlockList("example", QuerySuggestionsBlockListArgs.builder()
 *             .indexId(aws_kendra_index.example().id())
 *             .roleArn(aws_iam_role.example().arn())
 *             .sourceS3Path(QuerySuggestionsBlockListSourceS3PathArgs.builder()
 *                 .bucket(aws_s3_bucket.example().id())
 *                 .key("example/suggestions.txt")
 *                 .build())
 *             .tags(Map.of("Name", "Example Kendra Index"))
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import the `aws_kendra_query_suggestions_block_list` resource using the unique identifiers of the block list and index separated by a slash (`/`). For example:
 * ```sh
 *  $ pulumi import aws:kendra/querySuggestionsBlockList:QuerySuggestionsBlockList example blocklist-123456780/idx-8012925589
 * ```
 * @property description Description for a block list.
 * @property indexId Identifier of the index for a block list.
 * @property name Name for the block list.
 * @property roleArn IAM (Identity and Access Management) role used to access the block list text file in S3.
 * @property sourceS3Path S3 path where your block list text file is located. See details below.
 * The `source_s3_path` configuration block supports the following arguments:
 * @property tags Key-value map of resource tags. If configured with a provider `default_tags` configuration block, tags with matching keys will overwrite those defined at the provider-level.
 */
public data class QuerySuggestionsBlockListArgs(
    public val description: Output<String>? = null,
    public val indexId: Output<String>? = null,
    public val name: Output<String>? = null,
    public val roleArn: Output<String>? = null,
    public val sourceS3Path: Output<QuerySuggestionsBlockListSourceS3PathArgs>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.aws.kendra.QuerySuggestionsBlockListArgs> {
    override fun toJava(): com.pulumi.aws.kendra.QuerySuggestionsBlockListArgs =
        com.pulumi.aws.kendra.QuerySuggestionsBlockListArgs.builder()
            .description(description?.applyValue({ args0 -> args0 }))
            .indexId(indexId?.applyValue({ args0 -> args0 }))
            .name(name?.applyValue({ args0 -> args0 }))
            .roleArn(roleArn?.applyValue({ args0 -> args0 }))
            .sourceS3Path(sourceS3Path?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .tags(
                tags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [QuerySuggestionsBlockListArgs].
 */
@PulumiTagMarker
public class QuerySuggestionsBlockListArgsBuilder internal constructor() {
    private var description: Output<String>? = null

    private var indexId: Output<String>? = null

    private var name: Output<String>? = null

    private var roleArn: Output<String>? = null

    private var sourceS3Path: Output<QuerySuggestionsBlockListSourceS3PathArgs>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value Description for a block list.
     */
    @JvmName("nqukdkosnapupter")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value Identifier of the index for a block list.
     */
    @JvmName("ylpbjphljcnxdrmm")
    public suspend fun indexId(`value`: Output<String>) {
        this.indexId = value
    }

    /**
     * @param value Name for the block list.
     */
    @JvmName("owdfxssgfmrlvisl")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value IAM (Identity and Access Management) role used to access the block list text file in S3.
     */
    @JvmName("vqyxsgussiymehgx")
    public suspend fun roleArn(`value`: Output<String>) {
        this.roleArn = value
    }

    /**
     * @param value S3 path where your block list text file is located. See details below.
     * The `source_s3_path` configuration block supports the following arguments:
     */
    @JvmName("yctahhvilorqtidr")
    public suspend fun sourceS3Path(`value`: Output<QuerySuggestionsBlockListSourceS3PathArgs>) {
        this.sourceS3Path = value
    }

    /**
     * @param value Key-value map of resource tags. If configured with a provider `default_tags` configuration block, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("yprrsgegrguyjfxe")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value Description for a block list.
     */
    @JvmName("cqlfhofoslluaana")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value Identifier of the index for a block list.
     */
    @JvmName("qndntnbbvpshepyt")
    public suspend fun indexId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.indexId = mapped
    }

    /**
     * @param value Name for the block list.
     */
    @JvmName("xggitojqfirxmwcu")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value IAM (Identity and Access Management) role used to access the block list text file in S3.
     */
    @JvmName("ewaewenirtaqiiwa")
    public suspend fun roleArn(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.roleArn = mapped
    }

    /**
     * @param value S3 path where your block list text file is located. See details below.
     * The `source_s3_path` configuration block supports the following arguments:
     */
    @JvmName("yourukpsyivdbmtm")
    public suspend fun sourceS3Path(`value`: QuerySuggestionsBlockListSourceS3PathArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sourceS3Path = mapped
    }

    /**
     * @param argument S3 path where your block list text file is located. See details below.
     * The `source_s3_path` configuration block supports the following arguments:
     */
    @JvmName("fgsqdddbrpnobuqs")
    public suspend
    fun sourceS3Path(argument: suspend QuerySuggestionsBlockListSourceS3PathArgsBuilder.() -> Unit) {
        val toBeMapped = QuerySuggestionsBlockListSourceS3PathArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.sourceS3Path = mapped
    }

    /**
     * @param value Key-value map of resource tags. If configured with a provider `default_tags` configuration block, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("nfcbdvkmxjajmvkt")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Key-value map of resource tags. If configured with a provider `default_tags` configuration block, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("ajhufvshptiyicrh")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): QuerySuggestionsBlockListArgs = QuerySuggestionsBlockListArgs(
        description = description,
        indexId = indexId,
        name = name,
        roleArn = roleArn,
        sourceS3Path = sourceS3Path,
        tags = tags,
    )
}
