@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.kendra.kotlin

import com.pulumi.aws.kendra.kotlin.outputs.ThesaurusSourceS3Path
import com.pulumi.aws.kendra.kotlin.outputs.ThesaurusSourceS3Path.Companion.toKotlin
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map

/**
 * Builder for [Thesaurus].
 */
@PulumiTagMarker
public class ThesaurusResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: ThesaurusArgs = ThesaurusArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend ThesaurusArgsBuilder.() -> Unit) {
        val builder = ThesaurusArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): Thesaurus {
        val builtJavaResource = com.pulumi.aws.kendra.Thesaurus(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return Thesaurus(builtJavaResource)
    }
}

/**
 * Resource for managing an AWS Kendra Thesaurus.
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.kendra.Thesaurus;
 * import com.pulumi.aws.kendra.ThesaurusArgs;
 * import com.pulumi.aws.kendra.inputs.ThesaurusSourceS3PathArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new Thesaurus("example", ThesaurusArgs.builder()
 *             .indexId(aws_kendra_index.example().id())
 *             .roleArn(aws_iam_role.example().arn())
 *             .sourceS3Path(ThesaurusSourceS3PathArgs.builder()
 *                 .bucket(aws_s3_bucket.example().id())
 *                 .key(aws_s3_object.example().key())
 *                 .build())
 *             .tags(Map.of("Name", "Example Kendra Thesaurus"))
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import `aws_kendra_thesaurus` using the unique identifiers of the thesaurus and index separated by a slash (`/`). For example:
 * ```sh
 *  $ pulumi import aws:kendra/thesaurus:Thesaurus example thesaurus-123456780/idx-8012925589
 * ```
 *
 */
public class Thesaurus internal constructor(
    override val javaResource: com.pulumi.aws.kendra.Thesaurus,
) : KotlinCustomResource(javaResource, ThesaurusMapper) {
    /**
     * ARN of the thesaurus.
     */
    public val arn: Output<String>
        get() = javaResource.arn().applyValue({ args0 -> args0 })

    /**
     * The description for a thesaurus.
     */
    public val description: Output<String>?
        get() = javaResource.description().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The identifier of the index for a thesaurus.
     */
    public val indexId: Output<String>
        get() = javaResource.indexId().applyValue({ args0 -> args0 })

    /**
     * The name for the thesaurus.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * The IAM (Identity and Access Management) role used to access the thesaurus file in S3.
     */
    public val roleArn: Output<String>
        get() = javaResource.roleArn().applyValue({ args0 -> args0 })

    /**
     * The S3 path where your thesaurus file sits in S3. Detailed below.
     * The `source_s3_path` configuration block supports the following arguments:
     */
    public val sourceS3Path: Output<ThesaurusSourceS3Path>
        get() = javaResource.sourceS3Path().applyValue({ args0 -> args0.let({ args0 -> toKotlin(args0) }) })

    /**
     * The current status of the thesaurus.
     */
    public val status: Output<String>
        get() = javaResource.status().applyValue({ args0 -> args0 })

    /**
     * Key-value map of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
     */
    @Deprecated(
        message = """
  Please use `tags` instead.
  """,
    )
    public val tagsAll: Output<Map<String, String>>
        get() = javaResource.tagsAll().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.key.to(args0.value)
            }).toMap()
        })

    public val thesaurusId: Output<String>
        get() = javaResource.thesaurusId().applyValue({ args0 -> args0 })
}

public object ThesaurusMapper : ResourceMapper<Thesaurus> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.kendra.Thesaurus::class == javaResource::class

    override fun map(javaResource: Resource): Thesaurus = Thesaurus(
        javaResource as
            com.pulumi.aws.kendra.Thesaurus,
    )
}

/**
 * @see [Thesaurus].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [Thesaurus].
 */
public suspend fun thesaurus(name: String, block: suspend ThesaurusResourceBuilder.() -> Unit):
    Thesaurus {
    val builder = ThesaurusResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [Thesaurus].
 * @param name The _unique_ name of the resulting resource.
 */
public fun thesaurus(name: String): Thesaurus {
    val builder = ThesaurusResourceBuilder()
    builder.name(name)
    return builder.build()
}
