@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.kendra.kotlin

import com.pulumi.aws.kendra.ThesaurusArgs.builder
import com.pulumi.aws.kendra.kotlin.inputs.ThesaurusSourceS3PathArgs
import com.pulumi.aws.kendra.kotlin.inputs.ThesaurusSourceS3PathArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Resource for managing an AWS Kendra Thesaurus.
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.kendra.Thesaurus;
 * import com.pulumi.aws.kendra.ThesaurusArgs;
 * import com.pulumi.aws.kendra.inputs.ThesaurusSourceS3PathArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new Thesaurus("example", ThesaurusArgs.builder()
 *             .indexId(aws_kendra_index.example().id())
 *             .roleArn(aws_iam_role.example().arn())
 *             .sourceS3Path(ThesaurusSourceS3PathArgs.builder()
 *                 .bucket(aws_s3_bucket.example().id())
 *                 .key(aws_s3_object.example().key())
 *                 .build())
 *             .tags(Map.of("Name", "Example Kendra Thesaurus"))
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import `aws_kendra_thesaurus` using the unique identifiers of the thesaurus and index separated by a slash (`/`). For example:
 * ```sh
 *  $ pulumi import aws:kendra/thesaurus:Thesaurus example thesaurus-123456780/idx-8012925589
 * ```
 * @property description The description for a thesaurus.
 * @property indexId The identifier of the index for a thesaurus.
 * @property name The name for the thesaurus.
 * @property roleArn The IAM (Identity and Access Management) role used to access the thesaurus file in S3.
 * @property sourceS3Path The S3 path where your thesaurus file sits in S3. Detailed below.
 * The `source_s3_path` configuration block supports the following arguments:
 * @property tags Key-value map of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
 */
public data class ThesaurusArgs(
    public val description: Output<String>? = null,
    public val indexId: Output<String>? = null,
    public val name: Output<String>? = null,
    public val roleArn: Output<String>? = null,
    public val sourceS3Path: Output<ThesaurusSourceS3PathArgs>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.aws.kendra.ThesaurusArgs> {
    override fun toJava(): com.pulumi.aws.kendra.ThesaurusArgs =
        com.pulumi.aws.kendra.ThesaurusArgs.builder()
            .description(description?.applyValue({ args0 -> args0 }))
            .indexId(indexId?.applyValue({ args0 -> args0 }))
            .name(name?.applyValue({ args0 -> args0 }))
            .roleArn(roleArn?.applyValue({ args0 -> args0 }))
            .sourceS3Path(sourceS3Path?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .tags(
                tags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [ThesaurusArgs].
 */
@PulumiTagMarker
public class ThesaurusArgsBuilder internal constructor() {
    private var description: Output<String>? = null

    private var indexId: Output<String>? = null

    private var name: Output<String>? = null

    private var roleArn: Output<String>? = null

    private var sourceS3Path: Output<ThesaurusSourceS3PathArgs>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value The description for a thesaurus.
     */
    @JvmName("repkkltfbumqeygx")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value The identifier of the index for a thesaurus.
     */
    @JvmName("rdrtlaliruxciuew")
    public suspend fun indexId(`value`: Output<String>) {
        this.indexId = value
    }

    /**
     * @param value The name for the thesaurus.
     */
    @JvmName("gqfitsdojdafydbp")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value The IAM (Identity and Access Management) role used to access the thesaurus file in S3.
     */
    @JvmName("fqpaswqkeujmiymh")
    public suspend fun roleArn(`value`: Output<String>) {
        this.roleArn = value
    }

    /**
     * @param value The S3 path where your thesaurus file sits in S3. Detailed below.
     * The `source_s3_path` configuration block supports the following arguments:
     */
    @JvmName("pbunkbebrvxmqbmn")
    public suspend fun sourceS3Path(`value`: Output<ThesaurusSourceS3PathArgs>) {
        this.sourceS3Path = value
    }

    /**
     * @param value Key-value map of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("hayqyeggrdmnfnpo")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value The description for a thesaurus.
     */
    @JvmName("nsasowwdlrgkhyie")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value The identifier of the index for a thesaurus.
     */
    @JvmName("tvalrrfwjpmxohny")
    public suspend fun indexId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.indexId = mapped
    }

    /**
     * @param value The name for the thesaurus.
     */
    @JvmName("gawenxwngigteaau")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value The IAM (Identity and Access Management) role used to access the thesaurus file in S3.
     */
    @JvmName("uvdihlqqpmfjlocy")
    public suspend fun roleArn(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.roleArn = mapped
    }

    /**
     * @param value The S3 path where your thesaurus file sits in S3. Detailed below.
     * The `source_s3_path` configuration block supports the following arguments:
     */
    @JvmName("prjwpkwgdssfwmhp")
    public suspend fun sourceS3Path(`value`: ThesaurusSourceS3PathArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sourceS3Path = mapped
    }

    /**
     * @param argument The S3 path where your thesaurus file sits in S3. Detailed below.
     * The `source_s3_path` configuration block supports the following arguments:
     */
    @JvmName("qojobrocpuaixaab")
    public suspend fun sourceS3Path(argument: suspend ThesaurusSourceS3PathArgsBuilder.() -> Unit) {
        val toBeMapped = ThesaurusSourceS3PathArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.sourceS3Path = mapped
    }

    /**
     * @param value Key-value map of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("dretegdqgqpfiomf")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Key-value map of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("fvcnxbcroptlsjmd")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): ThesaurusArgs = ThesaurusArgs(
        description = description,
        indexId = indexId,
        name = name,
        roleArn = roleArn,
        sourceS3Path = sourceS3Path,
        tags = tags,
    )
}
