@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.kendra.kotlin.inputs

import com.pulumi.aws.kendra.inputs.DataSourceConfigurationS3ConfigurationDocumentsMetadataConfigurationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property s3Prefix A prefix used to filter metadata configuration files in the AWS S3 bucket. The S3 bucket might contain multiple metadata files. Use `s3_prefix` to include only the desired metadata files.
 */
public data class DataSourceConfigurationS3ConfigurationDocumentsMetadataConfigurationArgs(
    public val s3Prefix: Output<String>? = null,
) :
    ConvertibleToJava<com.pulumi.aws.kendra.inputs.DataSourceConfigurationS3ConfigurationDocumentsMetadataConfigurationArgs> {
    override fun toJava():
        com.pulumi.aws.kendra.inputs.DataSourceConfigurationS3ConfigurationDocumentsMetadataConfigurationArgs =
        com.pulumi.aws.kendra.inputs.DataSourceConfigurationS3ConfigurationDocumentsMetadataConfigurationArgs.builder()
            .s3Prefix(s3Prefix?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [DataSourceConfigurationS3ConfigurationDocumentsMetadataConfigurationArgs].
 */
@PulumiTagMarker
public class DataSourceConfigurationS3ConfigurationDocumentsMetadataConfigurationArgsBuilder
internal constructor() {
    private var s3Prefix: Output<String>? = null

    /**
     * @param value A prefix used to filter metadata configuration files in the AWS S3 bucket. The S3 bucket might contain multiple metadata files. Use `s3_prefix` to include only the desired metadata files.
     */
    @JvmName("pmjwomogfhlcxgha")
    public suspend fun s3Prefix(`value`: Output<String>) {
        this.s3Prefix = value
    }

    /**
     * @param value A prefix used to filter metadata configuration files in the AWS S3 bucket. The S3 bucket might contain multiple metadata files. Use `s3_prefix` to include only the desired metadata files.
     */
    @JvmName("rnpsoypreyouruji")
    public suspend fun s3Prefix(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.s3Prefix = mapped
    }

    internal fun build(): DataSourceConfigurationS3ConfigurationDocumentsMetadataConfigurationArgs =
        DataSourceConfigurationS3ConfigurationDocumentsMetadataConfigurationArgs(
            s3Prefix = s3Prefix,
        )
}
