@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.kendra.kotlin.inputs

import com.pulumi.aws.kendra.inputs.DataSourceConfigurationWebCrawlerConfigurationAuthenticationConfigurationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property basicAuthentications The list of configuration information that's required to connect to and crawl a website host using basic authentication credentials. The list includes the name and port number of the website host. Detailed below.
 */
public data class DataSourceConfigurationWebCrawlerConfigurationAuthenticationConfigurationArgs(
    public val basicAuthentications:
    Output<List<DataSourceConfigurationWebCrawlerConfigurationAuthenticationConfigurationBasicAuthenticationArgs>>? =
        null,
) :
    ConvertibleToJava<com.pulumi.aws.kendra.inputs.DataSourceConfigurationWebCrawlerConfigurationAuthenticationConfigurationArgs> {
    override fun toJava():
        com.pulumi.aws.kendra.inputs.DataSourceConfigurationWebCrawlerConfigurationAuthenticationConfigurationArgs =
        com.pulumi.aws.kendra.inputs.DataSourceConfigurationWebCrawlerConfigurationAuthenticationConfigurationArgs.builder()
            .basicAuthentications(
                basicAuthentications?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            ).build()
}

/**
 * Builder for [DataSourceConfigurationWebCrawlerConfigurationAuthenticationConfigurationArgs].
 */
@PulumiTagMarker
public class DataSourceConfigurationWebCrawlerConfigurationAuthenticationConfigurationArgsBuilder
internal constructor() {
    private var basicAuthentications:
        Output<List<DataSourceConfigurationWebCrawlerConfigurationAuthenticationConfigurationBasicAuthenticationArgs>>? =
        null

    /**
     * @param value The list of configuration information that's required to connect to and crawl a website host using basic authentication credentials. The list includes the name and port number of the website host. Detailed below.
     */
    @JvmName("oxiqbmywebptahoq")
    public suspend
    fun basicAuthentications(`value`: Output<List<DataSourceConfigurationWebCrawlerConfigurationAuthenticationConfigurationBasicAuthenticationArgs>>) {
        this.basicAuthentications = value
    }

    @JvmName("hbgilbopgwhyhemx")
    public suspend fun basicAuthentications(
        vararg
        values: Output<DataSourceConfigurationWebCrawlerConfigurationAuthenticationConfigurationBasicAuthenticationArgs>,
    ) {
        this.basicAuthentications = Output.all(values.asList())
    }

    /**
     * @param values The list of configuration information that's required to connect to and crawl a website host using basic authentication credentials. The list includes the name and port number of the website host. Detailed below.
     */
    @JvmName("pkyayiumoxycaduu")
    public suspend
    fun basicAuthentications(values: List<Output<DataSourceConfigurationWebCrawlerConfigurationAuthenticationConfigurationBasicAuthenticationArgs>>) {
        this.basicAuthentications = Output.all(values)
    }

    /**
     * @param value The list of configuration information that's required to connect to and crawl a website host using basic authentication credentials. The list includes the name and port number of the website host. Detailed below.
     */
    @JvmName("msourifaqqewpmsr")
    public suspend
    fun basicAuthentications(`value`: List<DataSourceConfigurationWebCrawlerConfigurationAuthenticationConfigurationBasicAuthenticationArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.basicAuthentications = mapped
    }

    /**
     * @param argument The list of configuration information that's required to connect to and crawl a website host using basic authentication credentials. The list includes the name and port number of the website host. Detailed below.
     */
    @JvmName("olesxbvotnhtqsra")
    public suspend
    fun basicAuthentications(argument: List<suspend DataSourceConfigurationWebCrawlerConfigurationAuthenticationConfigurationBasicAuthenticationArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            DataSourceConfigurationWebCrawlerConfigurationAuthenticationConfigurationBasicAuthenticationArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.basicAuthentications = mapped
    }

    /**
     * @param argument The list of configuration information that's required to connect to and crawl a website host using basic authentication credentials. The list includes the name and port number of the website host. Detailed below.
     */
    @JvmName("obhhbshjrelawguy")
    public suspend fun basicAuthentications(
        vararg
        argument: suspend DataSourceConfigurationWebCrawlerConfigurationAuthenticationConfigurationBasicAuthenticationArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            DataSourceConfigurationWebCrawlerConfigurationAuthenticationConfigurationBasicAuthenticationArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.basicAuthentications = mapped
    }

    /**
     * @param argument The list of configuration information that's required to connect to and crawl a website host using basic authentication credentials. The list includes the name and port number of the website host. Detailed below.
     */
    @JvmName("dbdstgqsfhxeigcj")
    public suspend
    fun basicAuthentications(argument: suspend DataSourceConfigurationWebCrawlerConfigurationAuthenticationConfigurationBasicAuthenticationArgsBuilder.() -> Unit) {
        val toBeMapped =
            listOf(
                DataSourceConfigurationWebCrawlerConfigurationAuthenticationConfigurationBasicAuthenticationArgsBuilder().applySuspend
                    { argument() }.build(),
            )
        val mapped = of(toBeMapped)
        this.basicAuthentications = mapped
    }

    /**
     * @param values The list of configuration information that's required to connect to and crawl a website host using basic authentication credentials. The list includes the name and port number of the website host. Detailed below.
     */
    @JvmName("kogtctrplecgpkxo")
    public suspend fun basicAuthentications(
        vararg
        values: DataSourceConfigurationWebCrawlerConfigurationAuthenticationConfigurationBasicAuthenticationArgs,
    ) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.basicAuthentications = mapped
    }

    internal fun build():
        DataSourceConfigurationWebCrawlerConfigurationAuthenticationConfigurationArgs =
        DataSourceConfigurationWebCrawlerConfigurationAuthenticationConfigurationArgs(
            basicAuthentications = basicAuthentications,
        )
}
