@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.kendra.kotlin.inputs

import com.pulumi.aws.kendra.inputs.DataSourceConfigurationWebCrawlerConfigurationUrlsSeedUrlConfigurationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property seedUrls The list of seed or starting point URLs of the websites you want to crawl. The list can include a maximum of `100` seed URLs. Array Members: Minimum number of `0` items. Maximum number of `100` items. Length Constraints: Minimum length of `1`. Maximum length of `2048`.
 * @property webCrawlerMode The default mode is set to `HOST_ONLY`. You can choose one of the following modes:
 */
public data class DataSourceConfigurationWebCrawlerConfigurationUrlsSeedUrlConfigurationArgs(
    public val seedUrls: Output<List<String>>,
    public val webCrawlerMode: Output<String>? = null,
) :
    ConvertibleToJava<com.pulumi.aws.kendra.inputs.DataSourceConfigurationWebCrawlerConfigurationUrlsSeedUrlConfigurationArgs> {
    override fun toJava():
        com.pulumi.aws.kendra.inputs.DataSourceConfigurationWebCrawlerConfigurationUrlsSeedUrlConfigurationArgs =
        com.pulumi.aws.kendra.inputs.DataSourceConfigurationWebCrawlerConfigurationUrlsSeedUrlConfigurationArgs.builder()
            .seedUrls(seedUrls.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .webCrawlerMode(webCrawlerMode?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [DataSourceConfigurationWebCrawlerConfigurationUrlsSeedUrlConfigurationArgs].
 */
@PulumiTagMarker
public class DataSourceConfigurationWebCrawlerConfigurationUrlsSeedUrlConfigurationArgsBuilder
internal constructor() {
    private var seedUrls: Output<List<String>>? = null

    private var webCrawlerMode: Output<String>? = null

    /**
     * @param value The list of seed or starting point URLs of the websites you want to crawl. The list can include a maximum of `100` seed URLs. Array Members: Minimum number of `0` items. Maximum number of `100` items. Length Constraints: Minimum length of `1`. Maximum length of `2048`.
     */
    @JvmName("qykydsxbkcyaoctx")
    public suspend fun seedUrls(`value`: Output<List<String>>) {
        this.seedUrls = value
    }

    @JvmName("bgeakvdhwgrifukk")
    public suspend fun seedUrls(vararg values: Output<String>) {
        this.seedUrls = Output.all(values.asList())
    }

    /**
     * @param values The list of seed or starting point URLs of the websites you want to crawl. The list can include a maximum of `100` seed URLs. Array Members: Minimum number of `0` items. Maximum number of `100` items. Length Constraints: Minimum length of `1`. Maximum length of `2048`.
     */
    @JvmName("qdeiioafgqujtisp")
    public suspend fun seedUrls(values: List<Output<String>>) {
        this.seedUrls = Output.all(values)
    }

    /**
     * @param value The default mode is set to `HOST_ONLY`. You can choose one of the following modes:
     */
    @JvmName("jblrcpoiedcicfvy")
    public suspend fun webCrawlerMode(`value`: Output<String>) {
        this.webCrawlerMode = value
    }

    /**
     * @param value The list of seed or starting point URLs of the websites you want to crawl. The list can include a maximum of `100` seed URLs. Array Members: Minimum number of `0` items. Maximum number of `100` items. Length Constraints: Minimum length of `1`. Maximum length of `2048`.
     */
    @JvmName("brctftfbmyfaycuv")
    public suspend fun seedUrls(`value`: List<String>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.seedUrls = mapped
    }

    /**
     * @param values The list of seed or starting point URLs of the websites you want to crawl. The list can include a maximum of `100` seed URLs. Array Members: Minimum number of `0` items. Maximum number of `100` items. Length Constraints: Minimum length of `1`. Maximum length of `2048`.
     */
    @JvmName("opecqoircxvreqjq")
    public suspend fun seedUrls(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.seedUrls = mapped
    }

    /**
     * @param value The default mode is set to `HOST_ONLY`. You can choose one of the following modes:
     */
    @JvmName("otbfrjsfatedsyiw")
    public suspend fun webCrawlerMode(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.webCrawlerMode = mapped
    }

    internal fun build(): DataSourceConfigurationWebCrawlerConfigurationUrlsSeedUrlConfigurationArgs =
        DataSourceConfigurationWebCrawlerConfigurationUrlsSeedUrlConfigurationArgs(
            seedUrls = seedUrls ?: throw PulumiNullFieldException("seedUrls"),
            webCrawlerMode = webCrawlerMode,
        )
}
