@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.kendra.kotlin.inputs

import com.pulumi.aws.kendra.inputs.DataSourceCustomDocumentEnrichmentConfigurationInlineConfigurationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 *
 * @property condition Configuration of the condition used for the target document attribute or metadata field when ingesting documents into Amazon Kendra. See condition.
 * @property documentContentDeletion `TRUE` to delete content if the condition used for the target attribute is met.
 * @property target Configuration of the target document attribute or metadata field when ingesting documents into Amazon Kendra. You can also include a value. Detailed below.
 */
public data class DataSourceCustomDocumentEnrichmentConfigurationInlineConfigurationArgs(
    public val condition:
    Output<DataSourceCustomDocumentEnrichmentConfigurationInlineConfigurationConditionArgs>? =
        null,
    public val documentContentDeletion: Output<Boolean>? = null,
    public val target:
    Output<DataSourceCustomDocumentEnrichmentConfigurationInlineConfigurationTargetArgs>? = null,
) :
    ConvertibleToJava<com.pulumi.aws.kendra.inputs.DataSourceCustomDocumentEnrichmentConfigurationInlineConfigurationArgs> {
    override fun toJava():
        com.pulumi.aws.kendra.inputs.DataSourceCustomDocumentEnrichmentConfigurationInlineConfigurationArgs =
        com.pulumi.aws.kendra.inputs.DataSourceCustomDocumentEnrichmentConfigurationInlineConfigurationArgs.builder()
            .condition(condition?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .documentContentDeletion(documentContentDeletion?.applyValue({ args0 -> args0 }))
            .target(target?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [DataSourceCustomDocumentEnrichmentConfigurationInlineConfigurationArgs].
 */
@PulumiTagMarker
public class DataSourceCustomDocumentEnrichmentConfigurationInlineConfigurationArgsBuilder internal
constructor() {
    private var condition:
        Output<DataSourceCustomDocumentEnrichmentConfigurationInlineConfigurationConditionArgs>? =
        null

    private var documentContentDeletion: Output<Boolean>? = null

    private var target:
        Output<DataSourceCustomDocumentEnrichmentConfigurationInlineConfigurationTargetArgs>? = null

    /**
     * @param value Configuration of the condition used for the target document attribute or metadata field when ingesting documents into Amazon Kendra. See condition.
     */
    @JvmName("wlxlhxwaxnxifsbo")
    public suspend
    fun condition(`value`: Output<DataSourceCustomDocumentEnrichmentConfigurationInlineConfigurationConditionArgs>) {
        this.condition = value
    }

    /**
     * @param value `TRUE` to delete content if the condition used for the target attribute is met.
     */
    @JvmName("awyoaycksbuxpums")
    public suspend fun documentContentDeletion(`value`: Output<Boolean>) {
        this.documentContentDeletion = value
    }

    /**
     * @param value Configuration of the target document attribute or metadata field when ingesting documents into Amazon Kendra. You can also include a value. Detailed below.
     */
    @JvmName("uopthgumpdyrtrsg")
    public suspend
    fun target(`value`: Output<DataSourceCustomDocumentEnrichmentConfigurationInlineConfigurationTargetArgs>) {
        this.target = value
    }

    /**
     * @param value Configuration of the condition used for the target document attribute or metadata field when ingesting documents into Amazon Kendra. See condition.
     */
    @JvmName("untljxocmpccgmna")
    public suspend
    fun condition(`value`: DataSourceCustomDocumentEnrichmentConfigurationInlineConfigurationConditionArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.condition = mapped
    }

    /**
     * @param argument Configuration of the condition used for the target document attribute or metadata field when ingesting documents into Amazon Kendra. See condition.
     */
    @JvmName("ynforjnpvxwshogl")
    public suspend
    fun condition(argument: suspend DataSourceCustomDocumentEnrichmentConfigurationInlineConfigurationConditionArgsBuilder.() -> Unit) {
        val toBeMapped =
            DataSourceCustomDocumentEnrichmentConfigurationInlineConfigurationConditionArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.condition = mapped
    }

    /**
     * @param value `TRUE` to delete content if the condition used for the target attribute is met.
     */
    @JvmName("inhblrwkgeyaivvx")
    public suspend fun documentContentDeletion(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.documentContentDeletion = mapped
    }

    /**
     * @param value Configuration of the target document attribute or metadata field when ingesting documents into Amazon Kendra. You can also include a value. Detailed below.
     */
    @JvmName("gjhivmmgawtbaytd")
    public suspend
    fun target(`value`: DataSourceCustomDocumentEnrichmentConfigurationInlineConfigurationTargetArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.target = mapped
    }

    /**
     * @param argument Configuration of the target document attribute or metadata field when ingesting documents into Amazon Kendra. You can also include a value. Detailed below.
     */
    @JvmName("udngmdhgjmiqfnba")
    public suspend
    fun target(argument: suspend DataSourceCustomDocumentEnrichmentConfigurationInlineConfigurationTargetArgsBuilder.() -> Unit) {
        val toBeMapped =
            DataSourceCustomDocumentEnrichmentConfigurationInlineConfigurationTargetArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.target = mapped
    }

    internal fun build(): DataSourceCustomDocumentEnrichmentConfigurationInlineConfigurationArgs =
        DataSourceCustomDocumentEnrichmentConfigurationInlineConfigurationArgs(
            condition = condition,
            documentContentDeletion = documentContentDeletion,
            target = target,
        )
}
