@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.kendra.kotlin.inputs

import com.pulumi.aws.kendra.inputs.DataSourceCustomDocumentEnrichmentConfigurationPreExtractionHookConfigurationInvocationConditionArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 *
 * @property conditionDocumentAttributeKey The identifier of the document attribute used for the condition. For example, `_source_uri` could be an identifier for the attribute or metadata field that contains source URIs associated with the documents. Amazon Kendra currently does not support `_document_body` as an attribute key used for the condition.
 * @property conditionOnValue The value used by the operator. For example, you can specify the value 'financial' for strings in the `_source_uri` field that partially match or contain this value. See condition_on_value.
 * @property operator The condition operator. For example, you can use `Contains` to partially match a string. Valid Values: `GreaterThan` | `GreaterThanOrEquals` | `LessThan` | `LessThanOrEquals` | `Equals` | `NotEquals` | `Contains` | `NotContains` | `Exists` | `NotExists` | `BeginsWith`.
 */
public data class
DataSourceCustomDocumentEnrichmentConfigurationPreExtractionHookConfigurationInvocationConditionArgs(
    public val conditionDocumentAttributeKey: Output<String>,
    public val conditionOnValue:
    Output<DataSourceCustomDocumentEnrichmentConfigurationPreExtractionHookConfigurationInvocationConditionConditionOnValueArgs>? =
        null,
    public val `operator`: Output<String>,
) :
    ConvertibleToJava<com.pulumi.aws.kendra.inputs.DataSourceCustomDocumentEnrichmentConfigurationPreExtractionHookConfigurationInvocationConditionArgs> {
    override fun toJava():
        com.pulumi.aws.kendra.inputs.DataSourceCustomDocumentEnrichmentConfigurationPreExtractionHookConfigurationInvocationConditionArgs =
        com.pulumi.aws.kendra.inputs.DataSourceCustomDocumentEnrichmentConfigurationPreExtractionHookConfigurationInvocationConditionArgs.builder()
            .conditionDocumentAttributeKey(conditionDocumentAttributeKey.applyValue({ args0 -> args0 }))
            .conditionOnValue(conditionOnValue?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .`operator`(`operator`.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [DataSourceCustomDocumentEnrichmentConfigurationPreExtractionHookConfigurationInvocationConditionArgs].
 */
@PulumiTagMarker
public class
DataSourceCustomDocumentEnrichmentConfigurationPreExtractionHookConfigurationInvocationConditionArgsBuilder
internal constructor() {
    private var conditionDocumentAttributeKey: Output<String>? = null

    private var conditionOnValue:
        Output<DataSourceCustomDocumentEnrichmentConfigurationPreExtractionHookConfigurationInvocationConditionConditionOnValueArgs>? =
        null

    private var `operator`: Output<String>? = null

    /**
     * @param value The identifier of the document attribute used for the condition. For example, `_source_uri` could be an identifier for the attribute or metadata field that contains source URIs associated with the documents. Amazon Kendra currently does not support `_document_body` as an attribute key used for the condition.
     */
    @JvmName("hlwfcxrdyrrmoaha")
    public suspend fun conditionDocumentAttributeKey(`value`: Output<String>) {
        this.conditionDocumentAttributeKey = value
    }

    /**
     * @param value The value used by the operator. For example, you can specify the value 'financial' for strings in the `_source_uri` field that partially match or contain this value. See condition_on_value.
     */
    @JvmName("olwmqmiopytelbym")
    public suspend
    fun conditionOnValue(`value`: Output<DataSourceCustomDocumentEnrichmentConfigurationPreExtractionHookConfigurationInvocationConditionConditionOnValueArgs>) {
        this.conditionOnValue = value
    }

    /**
     * @param value The condition operator. For example, you can use `Contains` to partially match a string. Valid Values: `GreaterThan` | `GreaterThanOrEquals` | `LessThan` | `LessThanOrEquals` | `Equals` | `NotEquals` | `Contains` | `NotContains` | `Exists` | `NotExists` | `BeginsWith`.
     */
    @JvmName("ysipdpvkguxhuimj")
    public suspend fun `operator`(`value`: Output<String>) {
        this.`operator` = value
    }

    /**
     * @param value The identifier of the document attribute used for the condition. For example, `_source_uri` could be an identifier for the attribute or metadata field that contains source URIs associated with the documents. Amazon Kendra currently does not support `_document_body` as an attribute key used for the condition.
     */
    @JvmName("gnogpldhbrygityy")
    public suspend fun conditionDocumentAttributeKey(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.conditionDocumentAttributeKey = mapped
    }

    /**
     * @param value The value used by the operator. For example, you can specify the value 'financial' for strings in the `_source_uri` field that partially match or contain this value. See condition_on_value.
     */
    @JvmName("aeexnpkagkbhljbq")
    public suspend
    fun conditionOnValue(`value`: DataSourceCustomDocumentEnrichmentConfigurationPreExtractionHookConfigurationInvocationConditionConditionOnValueArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.conditionOnValue = mapped
    }

    /**
     * @param argument The value used by the operator. For example, you can specify the value 'financial' for strings in the `_source_uri` field that partially match or contain this value. See condition_on_value.
     */
    @JvmName("mwomhecjjtxlyiov")
    public suspend
    fun conditionOnValue(argument: suspend DataSourceCustomDocumentEnrichmentConfigurationPreExtractionHookConfigurationInvocationConditionConditionOnValueArgsBuilder.() -> Unit) {
        val toBeMapped =
            DataSourceCustomDocumentEnrichmentConfigurationPreExtractionHookConfigurationInvocationConditionConditionOnValueArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.conditionOnValue = mapped
    }

    /**
     * @param value The condition operator. For example, you can use `Contains` to partially match a string. Valid Values: `GreaterThan` | `GreaterThanOrEquals` | `LessThan` | `LessThanOrEquals` | `Equals` | `NotEquals` | `Contains` | `NotContains` | `Exists` | `NotExists` | `BeginsWith`.
     */
    @JvmName("rlixwwdqgtktbbbf")
    public suspend fun `operator`(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.`operator` = mapped
    }

    internal fun build():
        DataSourceCustomDocumentEnrichmentConfigurationPreExtractionHookConfigurationInvocationConditionArgs =
        DataSourceCustomDocumentEnrichmentConfigurationPreExtractionHookConfigurationInvocationConditionArgs(
            conditionDocumentAttributeKey = conditionDocumentAttributeKey ?: throw
                PulumiNullFieldException("conditionDocumentAttributeKey"),
            conditionOnValue = conditionOnValue,
            `operator` = `operator` ?: throw PulumiNullFieldException("operator"),
        )
}
