@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.kendra.kotlin.inputs

import com.pulumi.aws.kendra.inputs.ExperienceConfigurationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 *
 * @property contentSourceConfiguration The identifiers of your data sources and FAQs. Or, you can specify that you want to use documents indexed via the `BatchPutDocument API`. The provider will only perform drift detection of its value when present in a configuration. Detailed below.
 * @property userIdentityConfiguration The AWS SSO field name that contains the identifiers of your users, such as their emails. Detailed below.
 */
public data class ExperienceConfigurationArgs(
    public val contentSourceConfiguration:
    Output<ExperienceConfigurationContentSourceConfigurationArgs>? = null,
    public val userIdentityConfiguration:
    Output<ExperienceConfigurationUserIdentityConfigurationArgs>? = null,
) : ConvertibleToJava<com.pulumi.aws.kendra.inputs.ExperienceConfigurationArgs> {
    override fun toJava(): com.pulumi.aws.kendra.inputs.ExperienceConfigurationArgs =
        com.pulumi.aws.kendra.inputs.ExperienceConfigurationArgs.builder()
            .contentSourceConfiguration(
                contentSourceConfiguration?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .userIdentityConfiguration(
                userIdentityConfiguration?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            ).build()
}

/**
 * Builder for [ExperienceConfigurationArgs].
 */
@PulumiTagMarker
public class ExperienceConfigurationArgsBuilder internal constructor() {
    private var contentSourceConfiguration:
        Output<ExperienceConfigurationContentSourceConfigurationArgs>? = null

    private var userIdentityConfiguration:
        Output<ExperienceConfigurationUserIdentityConfigurationArgs>? = null

    /**
     * @param value The identifiers of your data sources and FAQs. Or, you can specify that you want to use documents indexed via the `BatchPutDocument API`. The provider will only perform drift detection of its value when present in a configuration. Detailed below.
     */
    @JvmName("afplchpabyjhbtoy")
    public suspend
    fun contentSourceConfiguration(`value`: Output<ExperienceConfigurationContentSourceConfigurationArgs>) {
        this.contentSourceConfiguration = value
    }

    /**
     * @param value The AWS SSO field name that contains the identifiers of your users, such as their emails. Detailed below.
     */
    @JvmName("xupjjhovunrjleas")
    public suspend
    fun userIdentityConfiguration(`value`: Output<ExperienceConfigurationUserIdentityConfigurationArgs>) {
        this.userIdentityConfiguration = value
    }

    /**
     * @param value The identifiers of your data sources and FAQs. Or, you can specify that you want to use documents indexed via the `BatchPutDocument API`. The provider will only perform drift detection of its value when present in a configuration. Detailed below.
     */
    @JvmName("bnwetmxlhlhuxasq")
    public suspend
    fun contentSourceConfiguration(`value`: ExperienceConfigurationContentSourceConfigurationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.contentSourceConfiguration = mapped
    }

    /**
     * @param argument The identifiers of your data sources and FAQs. Or, you can specify that you want to use documents indexed via the `BatchPutDocument API`. The provider will only perform drift detection of its value when present in a configuration. Detailed below.
     */
    @JvmName("nkmjbgerobsncsyc")
    public suspend
    fun contentSourceConfiguration(argument: suspend ExperienceConfigurationContentSourceConfigurationArgsBuilder.() -> Unit) {
        val toBeMapped = ExperienceConfigurationContentSourceConfigurationArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.contentSourceConfiguration = mapped
    }

    /**
     * @param value The AWS SSO field name that contains the identifiers of your users, such as their emails. Detailed below.
     */
    @JvmName("mdvlidqqosynrfvh")
    public suspend
    fun userIdentityConfiguration(`value`: ExperienceConfigurationUserIdentityConfigurationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.userIdentityConfiguration = mapped
    }

    /**
     * @param argument The AWS SSO field name that contains the identifiers of your users, such as their emails. Detailed below.
     */
    @JvmName("uexfxlhhvrdccrde")
    public suspend
    fun userIdentityConfiguration(argument: suspend ExperienceConfigurationUserIdentityConfigurationArgsBuilder.() -> Unit) {
        val toBeMapped = ExperienceConfigurationUserIdentityConfigurationArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.userIdentityConfiguration = mapped
    }

    internal fun build(): ExperienceConfigurationArgs = ExperienceConfigurationArgs(
        contentSourceConfiguration = contentSourceConfiguration,
        userIdentityConfiguration = userIdentityConfiguration,
    )
}
