@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.kendra.kotlin.inputs

import com.pulumi.aws.kendra.inputs.GetExperiencePlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getExperience.
 * @property experienceId Identifier of the Experience.
 * @property indexId Identifier of the index that contains the Experience.
 */
public data class GetExperiencePlainArgs(
    public val experienceId: String,
    public val indexId: String,
) : ConvertibleToJava<com.pulumi.aws.kendra.inputs.GetExperiencePlainArgs> {
    override fun toJava(): com.pulumi.aws.kendra.inputs.GetExperiencePlainArgs =
        com.pulumi.aws.kendra.inputs.GetExperiencePlainArgs.builder()
            .experienceId(experienceId.let({ args0 -> args0 }))
            .indexId(indexId.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetExperiencePlainArgs].
 */
@PulumiTagMarker
public class GetExperiencePlainArgsBuilder internal constructor() {
    private var experienceId: String? = null

    private var indexId: String? = null

    /**
     * @param value Identifier of the Experience.
     */
    @JvmName("hargxjglyjeasisg")
    public suspend fun experienceId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.experienceId = mapped
    }

    /**
     * @param value Identifier of the index that contains the Experience.
     */
    @JvmName("lueelcfnypfisryn")
    public suspend fun indexId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.indexId = mapped
    }

    internal fun build(): GetExperiencePlainArgs = GetExperiencePlainArgs(
        experienceId = experienceId ?: throw PulumiNullFieldException("experienceId"),
        indexId = indexId ?: throw PulumiNullFieldException("indexId"),
    )
}
