@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.kendra.kotlin.inputs

import com.pulumi.aws.kendra.inputs.GetFaqPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getFaq.
 * @property faqId Identifier of the FAQ.
 * @property indexId Identifier of the index that contains the FAQ.
 * @property tags Metadata that helps organize the FAQs you create.
 */
public data class GetFaqPlainArgs(
    public val faqId: String,
    public val indexId: String,
    public val tags: Map<String, String>? = null,
) : ConvertibleToJava<com.pulumi.aws.kendra.inputs.GetFaqPlainArgs> {
    override fun toJava(): com.pulumi.aws.kendra.inputs.GetFaqPlainArgs =
        com.pulumi.aws.kendra.inputs.GetFaqPlainArgs.builder()
            .faqId(faqId.let({ args0 -> args0 }))
            .indexId(indexId.let({ args0 -> args0 }))
            .tags(tags?.let({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() })).build()
}

/**
 * Builder for [GetFaqPlainArgs].
 */
@PulumiTagMarker
public class GetFaqPlainArgsBuilder internal constructor() {
    private var faqId: String? = null

    private var indexId: String? = null

    private var tags: Map<String, String>? = null

    /**
     * @param value Identifier of the FAQ.
     */
    @JvmName("jvqdkglimiccajcs")
    public suspend fun faqId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.faqId = mapped
    }

    /**
     * @param value Identifier of the index that contains the FAQ.
     */
    @JvmName("bbvdakwhxguenuav")
    public suspend fun indexId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.indexId = mapped
    }

    /**
     * @param value Metadata that helps organize the FAQs you create.
     */
    @JvmName("wfwuuxfyoaixdpbr")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.tags = mapped
    }

    /**
     * @param values Metadata that helps organize the FAQs you create.
     */
    @JvmName("qtqiyqamitclfeux")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.tags = mapped
    }

    internal fun build(): GetFaqPlainArgs = GetFaqPlainArgs(
        faqId = faqId ?: throw PulumiNullFieldException("faqId"),
        indexId = indexId ?: throw PulumiNullFieldException("indexId"),
        tags = tags,
    )
}
