@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.kendra.kotlin.inputs

import com.pulumi.aws.kendra.inputs.IndexDocumentMetadataConfigurationUpdateRelevanceArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.Int
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 *
 * @property duration Specifies the time period that the boost applies to. For more information, refer to [Duration](https://docs.aws.amazon.com/kendra/latest/dg/API_Relevance.html#Kendra-Type-Relevance-Duration).
 * @property freshness Indicates that this field determines how "fresh" a document is. For more information, refer to [Freshness](https://docs.aws.amazon.com/kendra/latest/dg/API_Relevance.html#Kendra-Type-Relevance-Freshness).
 * @property importance The relative importance of the field in the search. Larger numbers provide more of a boost than smaller numbers. Minimum value of 1. Maximum value of 10.
 * @property rankOrder Determines how values should be interpreted. For more information, refer to [RankOrder](https://docs.aws.amazon.com/kendra/latest/dg/API_Relevance.html#Kendra-Type-Relevance-RankOrder).
 * @property valuesImportanceMap A list of values that should be given a different boost when they appear in the result list. For more information, refer to [ValueImportanceMap](https://docs.aws.amazon.com/kendra/latest/dg/API_Relevance.html#Kendra-Type-Relevance-ValueImportanceMap).
 */
public data class IndexDocumentMetadataConfigurationUpdateRelevanceArgs(
    public val duration: Output<String>? = null,
    public val freshness: Output<Boolean>? = null,
    public val importance: Output<Int>? = null,
    public val rankOrder: Output<String>? = null,
    public val valuesImportanceMap: Output<Map<String, Int>>? = null,
) :
    ConvertibleToJava<com.pulumi.aws.kendra.inputs.IndexDocumentMetadataConfigurationUpdateRelevanceArgs> {
    override fun toJava():
        com.pulumi.aws.kendra.inputs.IndexDocumentMetadataConfigurationUpdateRelevanceArgs =
        com.pulumi.aws.kendra.inputs.IndexDocumentMetadataConfigurationUpdateRelevanceArgs.builder()
            .duration(duration?.applyValue({ args0 -> args0 }))
            .freshness(freshness?.applyValue({ args0 -> args0 }))
            .importance(importance?.applyValue({ args0 -> args0 }))
            .rankOrder(rankOrder?.applyValue({ args0 -> args0 }))
            .valuesImportanceMap(
                valuesImportanceMap?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [IndexDocumentMetadataConfigurationUpdateRelevanceArgs].
 */
@PulumiTagMarker
public class IndexDocumentMetadataConfigurationUpdateRelevanceArgsBuilder internal constructor() {
    private var duration: Output<String>? = null

    private var freshness: Output<Boolean>? = null

    private var importance: Output<Int>? = null

    private var rankOrder: Output<String>? = null

    private var valuesImportanceMap: Output<Map<String, Int>>? = null

    /**
     * @param value Specifies the time period that the boost applies to. For more information, refer to [Duration](https://docs.aws.amazon.com/kendra/latest/dg/API_Relevance.html#Kendra-Type-Relevance-Duration).
     */
    @JvmName("kuvgqjdjpfilxfnl")
    public suspend fun duration(`value`: Output<String>) {
        this.duration = value
    }

    /**
     * @param value Indicates that this field determines how "fresh" a document is. For more information, refer to [Freshness](https://docs.aws.amazon.com/kendra/latest/dg/API_Relevance.html#Kendra-Type-Relevance-Freshness).
     */
    @JvmName("tylwtqtglkcjdsso")
    public suspend fun freshness(`value`: Output<Boolean>) {
        this.freshness = value
    }

    /**
     * @param value The relative importance of the field in the search. Larger numbers provide more of a boost than smaller numbers. Minimum value of 1. Maximum value of 10.
     */
    @JvmName("pnfrxfuyipmwjsso")
    public suspend fun importance(`value`: Output<Int>) {
        this.importance = value
    }

    /**
     * @param value Determines how values should be interpreted. For more information, refer to [RankOrder](https://docs.aws.amazon.com/kendra/latest/dg/API_Relevance.html#Kendra-Type-Relevance-RankOrder).
     */
    @JvmName("wfdmypyunnfuweqr")
    public suspend fun rankOrder(`value`: Output<String>) {
        this.rankOrder = value
    }

    /**
     * @param value A list of values that should be given a different boost when they appear in the result list. For more information, refer to [ValueImportanceMap](https://docs.aws.amazon.com/kendra/latest/dg/API_Relevance.html#Kendra-Type-Relevance-ValueImportanceMap).
     */
    @JvmName("idtxtemokqiqwvlh")
    public suspend fun valuesImportanceMap(`value`: Output<Map<String, Int>>) {
        this.valuesImportanceMap = value
    }

    /**
     * @param value Specifies the time period that the boost applies to. For more information, refer to [Duration](https://docs.aws.amazon.com/kendra/latest/dg/API_Relevance.html#Kendra-Type-Relevance-Duration).
     */
    @JvmName("kdqblptloioafmty")
    public suspend fun duration(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.duration = mapped
    }

    /**
     * @param value Indicates that this field determines how "fresh" a document is. For more information, refer to [Freshness](https://docs.aws.amazon.com/kendra/latest/dg/API_Relevance.html#Kendra-Type-Relevance-Freshness).
     */
    @JvmName("uhrqekwrnckvbelu")
    public suspend fun freshness(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.freshness = mapped
    }

    /**
     * @param value The relative importance of the field in the search. Larger numbers provide more of a boost than smaller numbers. Minimum value of 1. Maximum value of 10.
     */
    @JvmName("nahkafvggqosymxk")
    public suspend fun importance(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.importance = mapped
    }

    /**
     * @param value Determines how values should be interpreted. For more information, refer to [RankOrder](https://docs.aws.amazon.com/kendra/latest/dg/API_Relevance.html#Kendra-Type-Relevance-RankOrder).
     */
    @JvmName("doaueregmvpdakxt")
    public suspend fun rankOrder(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.rankOrder = mapped
    }

    /**
     * @param value A list of values that should be given a different boost when they appear in the result list. For more information, refer to [ValueImportanceMap](https://docs.aws.amazon.com/kendra/latest/dg/API_Relevance.html#Kendra-Type-Relevance-ValueImportanceMap).
     */
    @JvmName("wwkblqatkhsrnmwd")
    public suspend fun valuesImportanceMap(`value`: Map<String, Int>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.valuesImportanceMap = mapped
    }

    /**
     * @param values A list of values that should be given a different boost when they appear in the result list. For more information, refer to [ValueImportanceMap](https://docs.aws.amazon.com/kendra/latest/dg/API_Relevance.html#Kendra-Type-Relevance-ValueImportanceMap).
     */
    @JvmName("oavuthnyhwbdxhlo")
    public fun valuesImportanceMap(vararg values: Pair<String, Int>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.valuesImportanceMap = mapped
    }

    internal fun build(): IndexDocumentMetadataConfigurationUpdateRelevanceArgs =
        IndexDocumentMetadataConfigurationUpdateRelevanceArgs(
            duration = duration,
            freshness = freshness,
            importance = importance,
            rankOrder = rankOrder,
            valuesImportanceMap = valuesImportanceMap,
        )
}
