@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.kendra.kotlin.inputs

import com.pulumi.aws.kendra.inputs.IndexDocumentMetadataConfigurationUpdateSearchArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property displayable Determines whether the field is returned in the query response. The default is `true`.
 * @property facetable Indicates that the field can be used to create search facets, a count of results for each value in the field. The default is `false`.
 * @property searchable Determines whether the field is used in the search. If the Searchable field is true, you can use relevance tuning to manually tune how Amazon Kendra weights the field in the search. The default is `true` for `string` fields and `false` for `number` and `date` fields.
 * @property sortable Determines whether the field can be used to sort the results of a query. If you specify sorting on a field that does not have Sortable set to true, Amazon Kendra returns an exception. The default is `false`.
 */
public data class IndexDocumentMetadataConfigurationUpdateSearchArgs(
    public val displayable: Output<Boolean>? = null,
    public val facetable: Output<Boolean>? = null,
    public val searchable: Output<Boolean>? = null,
    public val sortable: Output<Boolean>? = null,
) :
    ConvertibleToJava<com.pulumi.aws.kendra.inputs.IndexDocumentMetadataConfigurationUpdateSearchArgs> {
    override fun toJava():
        com.pulumi.aws.kendra.inputs.IndexDocumentMetadataConfigurationUpdateSearchArgs =
        com.pulumi.aws.kendra.inputs.IndexDocumentMetadataConfigurationUpdateSearchArgs.builder()
            .displayable(displayable?.applyValue({ args0 -> args0 }))
            .facetable(facetable?.applyValue({ args0 -> args0 }))
            .searchable(searchable?.applyValue({ args0 -> args0 }))
            .sortable(sortable?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [IndexDocumentMetadataConfigurationUpdateSearchArgs].
 */
@PulumiTagMarker
public class IndexDocumentMetadataConfigurationUpdateSearchArgsBuilder internal constructor() {
    private var displayable: Output<Boolean>? = null

    private var facetable: Output<Boolean>? = null

    private var searchable: Output<Boolean>? = null

    private var sortable: Output<Boolean>? = null

    /**
     * @param value Determines whether the field is returned in the query response. The default is `true`.
     */
    @JvmName("tfqrhguciilehsgi")
    public suspend fun displayable(`value`: Output<Boolean>) {
        this.displayable = value
    }

    /**
     * @param value Indicates that the field can be used to create search facets, a count of results for each value in the field. The default is `false`.
     */
    @JvmName("llrlnpnspagjojyq")
    public suspend fun facetable(`value`: Output<Boolean>) {
        this.facetable = value
    }

    /**
     * @param value Determines whether the field is used in the search. If the Searchable field is true, you can use relevance tuning to manually tune how Amazon Kendra weights the field in the search. The default is `true` for `string` fields and `false` for `number` and `date` fields.
     */
    @JvmName("lpvtrbxwbhxmvbis")
    public suspend fun searchable(`value`: Output<Boolean>) {
        this.searchable = value
    }

    /**
     * @param value Determines whether the field can be used to sort the results of a query. If you specify sorting on a field that does not have Sortable set to true, Amazon Kendra returns an exception. The default is `false`.
     */
    @JvmName("rydayjifaarfgupd")
    public suspend fun sortable(`value`: Output<Boolean>) {
        this.sortable = value
    }

    /**
     * @param value Determines whether the field is returned in the query response. The default is `true`.
     */
    @JvmName("rmyrieiualrgugfl")
    public suspend fun displayable(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.displayable = mapped
    }

    /**
     * @param value Indicates that the field can be used to create search facets, a count of results for each value in the field. The default is `false`.
     */
    @JvmName("nqnekmktohhlduxc")
    public suspend fun facetable(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.facetable = mapped
    }

    /**
     * @param value Determines whether the field is used in the search. If the Searchable field is true, you can use relevance tuning to manually tune how Amazon Kendra weights the field in the search. The default is `true` for `string` fields and `false` for `number` and `date` fields.
     */
    @JvmName("snlgetbosuolhjsn")
    public suspend fun searchable(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.searchable = mapped
    }

    /**
     * @param value Determines whether the field can be used to sort the results of a query. If you specify sorting on a field that does not have Sortable set to true, Amazon Kendra returns an exception. The default is `false`.
     */
    @JvmName("sqijbptuyjomixqy")
    public suspend fun sortable(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sortable = mapped
    }

    internal fun build(): IndexDocumentMetadataConfigurationUpdateSearchArgs =
        IndexDocumentMetadataConfigurationUpdateSearchArgs(
            displayable = displayable,
            facetable = facetable,
            searchable = searchable,
            sortable = sortable,
        )
}
