@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.kendra.kotlin.inputs

import com.pulumi.aws.kendra.inputs.IndexServerSideEncryptionConfigurationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property kmsKeyId The identifier of the AWS KMScustomer master key (CMK). Amazon Kendra doesn't support asymmetric CMKs.
 */
public data class IndexServerSideEncryptionConfigurationArgs(
    public val kmsKeyId: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.kendra.inputs.IndexServerSideEncryptionConfigurationArgs> {
    override fun toJava(): com.pulumi.aws.kendra.inputs.IndexServerSideEncryptionConfigurationArgs =
        com.pulumi.aws.kendra.inputs.IndexServerSideEncryptionConfigurationArgs.builder()
            .kmsKeyId(kmsKeyId?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [IndexServerSideEncryptionConfigurationArgs].
 */
@PulumiTagMarker
public class IndexServerSideEncryptionConfigurationArgsBuilder internal constructor() {
    private var kmsKeyId: Output<String>? = null

    /**
     * @param value The identifier of the AWS KMScustomer master key (CMK). Amazon Kendra doesn't support asymmetric CMKs.
     */
    @JvmName("dpjtiagflabqgvhr")
    public suspend fun kmsKeyId(`value`: Output<String>) {
        this.kmsKeyId = value
    }

    /**
     * @param value The identifier of the AWS KMScustomer master key (CMK). Amazon Kendra doesn't support asymmetric CMKs.
     */
    @JvmName("tryitesrkhbfnddd")
    public suspend fun kmsKeyId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.kmsKeyId = mapped
    }

    internal fun build(): IndexServerSideEncryptionConfigurationArgs =
        IndexServerSideEncryptionConfigurationArgs(
            kmsKeyId = kmsKeyId,
        )
}
