@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.kendra.kotlin.inputs

import com.pulumi.aws.kendra.inputs.IndexUserGroupResolutionConfigurationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property userGroupResolutionMode The identity store provider (mode) you want to use to fetch access levels of groups and users. AWS Single Sign-On is currently the only available mode. Your users and groups must exist in an AWS SSO identity source in order to use this mode. Valid Values are `AWS_SSO` or `NONE`.
 */
public data class IndexUserGroupResolutionConfigurationArgs(
    public val userGroupResolutionMode: Output<String>,
) : ConvertibleToJava<com.pulumi.aws.kendra.inputs.IndexUserGroupResolutionConfigurationArgs> {
    override fun toJava(): com.pulumi.aws.kendra.inputs.IndexUserGroupResolutionConfigurationArgs =
        com.pulumi.aws.kendra.inputs.IndexUserGroupResolutionConfigurationArgs.builder()
            .userGroupResolutionMode(userGroupResolutionMode.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [IndexUserGroupResolutionConfigurationArgs].
 */
@PulumiTagMarker
public class IndexUserGroupResolutionConfigurationArgsBuilder internal constructor() {
    private var userGroupResolutionMode: Output<String>? = null

    /**
     * @param value The identity store provider (mode) you want to use to fetch access levels of groups and users. AWS Single Sign-On is currently the only available mode. Your users and groups must exist in an AWS SSO identity source in order to use this mode. Valid Values are `AWS_SSO` or `NONE`.
     */
    @JvmName("advvdwkutnuolmui")
    public suspend fun userGroupResolutionMode(`value`: Output<String>) {
        this.userGroupResolutionMode = value
    }

    /**
     * @param value The identity store provider (mode) you want to use to fetch access levels of groups and users. AWS Single Sign-On is currently the only available mode. Your users and groups must exist in an AWS SSO identity source in order to use this mode. Valid Values are `AWS_SSO` or `NONE`.
     */
    @JvmName("nuumudpqhxdfhqhy")
    public suspend fun userGroupResolutionMode(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.userGroupResolutionMode = mapped
    }

    internal fun build(): IndexUserGroupResolutionConfigurationArgs =
        IndexUserGroupResolutionConfigurationArgs(
            userGroupResolutionMode = userGroupResolutionMode ?: throw
                PulumiNullFieldException("userGroupResolutionMode"),
        )
}
