@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.kendra.kotlin.inputs

import com.pulumi.aws.kendra.inputs.IndexUserTokenConfigurationsArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 *
 * @property jsonTokenTypeConfiguration A block that specifies the information about the JSON token type configuration. Detailed below.
 * @property jwtTokenTypeConfiguration A block that specifies the information about the JWT token type configuration. Detailed below.
 */
public data class IndexUserTokenConfigurationsArgs(
    public val jsonTokenTypeConfiguration:
    Output<IndexUserTokenConfigurationsJsonTokenTypeConfigurationArgs>? = null,
    public val jwtTokenTypeConfiguration:
    Output<IndexUserTokenConfigurationsJwtTokenTypeConfigurationArgs>? = null,
) : ConvertibleToJava<com.pulumi.aws.kendra.inputs.IndexUserTokenConfigurationsArgs> {
    override fun toJava(): com.pulumi.aws.kendra.inputs.IndexUserTokenConfigurationsArgs =
        com.pulumi.aws.kendra.inputs.IndexUserTokenConfigurationsArgs.builder()
            .jsonTokenTypeConfiguration(
                jsonTokenTypeConfiguration?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .jwtTokenTypeConfiguration(
                jwtTokenTypeConfiguration?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            ).build()
}

/**
 * Builder for [IndexUserTokenConfigurationsArgs].
 */
@PulumiTagMarker
public class IndexUserTokenConfigurationsArgsBuilder internal constructor() {
    private var jsonTokenTypeConfiguration:
        Output<IndexUserTokenConfigurationsJsonTokenTypeConfigurationArgs>? = null

    private var jwtTokenTypeConfiguration:
        Output<IndexUserTokenConfigurationsJwtTokenTypeConfigurationArgs>? = null

    /**
     * @param value A block that specifies the information about the JSON token type configuration. Detailed below.
     */
    @JvmName("gxogaeeemsmfopmy")
    public suspend
    fun jsonTokenTypeConfiguration(`value`: Output<IndexUserTokenConfigurationsJsonTokenTypeConfigurationArgs>) {
        this.jsonTokenTypeConfiguration = value
    }

    /**
     * @param value A block that specifies the information about the JWT token type configuration. Detailed below.
     */
    @JvmName("rdjxjnhurxsqbmgi")
    public suspend
    fun jwtTokenTypeConfiguration(`value`: Output<IndexUserTokenConfigurationsJwtTokenTypeConfigurationArgs>) {
        this.jwtTokenTypeConfiguration = value
    }

    /**
     * @param value A block that specifies the information about the JSON token type configuration. Detailed below.
     */
    @JvmName("dvfimmmgnbgbgrfe")
    public suspend
    fun jsonTokenTypeConfiguration(`value`: IndexUserTokenConfigurationsJsonTokenTypeConfigurationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.jsonTokenTypeConfiguration = mapped
    }

    /**
     * @param argument A block that specifies the information about the JSON token type configuration. Detailed below.
     */
    @JvmName("gylyjwcqnlhynuyv")
    public suspend
    fun jsonTokenTypeConfiguration(argument: suspend IndexUserTokenConfigurationsJsonTokenTypeConfigurationArgsBuilder.() -> Unit) {
        val toBeMapped =
            IndexUserTokenConfigurationsJsonTokenTypeConfigurationArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.jsonTokenTypeConfiguration = mapped
    }

    /**
     * @param value A block that specifies the information about the JWT token type configuration. Detailed below.
     */
    @JvmName("qirupakyglwqmtti")
    public suspend
    fun jwtTokenTypeConfiguration(`value`: IndexUserTokenConfigurationsJwtTokenTypeConfigurationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.jwtTokenTypeConfiguration = mapped
    }

    /**
     * @param argument A block that specifies the information about the JWT token type configuration. Detailed below.
     */
    @JvmName("vkikrenivogdqyol")
    public suspend
    fun jwtTokenTypeConfiguration(argument: suspend IndexUserTokenConfigurationsJwtTokenTypeConfigurationArgsBuilder.() -> Unit) {
        val toBeMapped =
            IndexUserTokenConfigurationsJwtTokenTypeConfigurationArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.jwtTokenTypeConfiguration = mapped
    }

    internal fun build(): IndexUserTokenConfigurationsArgs = IndexUserTokenConfigurationsArgs(
        jsonTokenTypeConfiguration = jsonTokenTypeConfiguration,
        jwtTokenTypeConfiguration = jwtTokenTypeConfiguration,
    )
}
