@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.kendra.kotlin.inputs

import com.pulumi.aws.kendra.inputs.IndexUserTokenConfigurationsJsonTokenTypeConfigurationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property groupAttributeField The group attribute field. Minimum length of 1. Maximum length of 2048.
 * @property userNameAttributeField The user name attribute field. Minimum length of 1. Maximum length of 2048.
 */
public data class IndexUserTokenConfigurationsJsonTokenTypeConfigurationArgs(
    public val groupAttributeField: Output<String>,
    public val userNameAttributeField: Output<String>,
) :
    ConvertibleToJava<com.pulumi.aws.kendra.inputs.IndexUserTokenConfigurationsJsonTokenTypeConfigurationArgs> {
    override fun toJava():
        com.pulumi.aws.kendra.inputs.IndexUserTokenConfigurationsJsonTokenTypeConfigurationArgs =
        com.pulumi.aws.kendra.inputs.IndexUserTokenConfigurationsJsonTokenTypeConfigurationArgs.builder()
            .groupAttributeField(groupAttributeField.applyValue({ args0 -> args0 }))
            .userNameAttributeField(userNameAttributeField.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [IndexUserTokenConfigurationsJsonTokenTypeConfigurationArgs].
 */
@PulumiTagMarker
public class IndexUserTokenConfigurationsJsonTokenTypeConfigurationArgsBuilder internal
constructor() {
    private var groupAttributeField: Output<String>? = null

    private var userNameAttributeField: Output<String>? = null

    /**
     * @param value The group attribute field. Minimum length of 1. Maximum length of 2048.
     */
    @JvmName("wqccsbbjsarapual")
    public suspend fun groupAttributeField(`value`: Output<String>) {
        this.groupAttributeField = value
    }

    /**
     * @param value The user name attribute field. Minimum length of 1. Maximum length of 2048.
     */
    @JvmName("eprrowwepafodtoo")
    public suspend fun userNameAttributeField(`value`: Output<String>) {
        this.userNameAttributeField = value
    }

    /**
     * @param value The group attribute field. Minimum length of 1. Maximum length of 2048.
     */
    @JvmName("nvwysshcaaqdtkdx")
    public suspend fun groupAttributeField(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.groupAttributeField = mapped
    }

    /**
     * @param value The user name attribute field. Minimum length of 1. Maximum length of 2048.
     */
    @JvmName("wktolhfrcsgthnto")
    public suspend fun userNameAttributeField(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.userNameAttributeField = mapped
    }

    internal fun build(): IndexUserTokenConfigurationsJsonTokenTypeConfigurationArgs =
        IndexUserTokenConfigurationsJsonTokenTypeConfigurationArgs(
            groupAttributeField = groupAttributeField ?: throw PulumiNullFieldException("groupAttributeField"),
            userNameAttributeField = userNameAttributeField ?: throw
                PulumiNullFieldException("userNameAttributeField"),
        )
}
