@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.kendra.kotlin.inputs

import com.pulumi.aws.kendra.inputs.QuerySuggestionsBlockListSourceS3PathArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property bucket Name of the S3 bucket that contains the file.
 * @property key Name of the file.
 * The following arguments are optional:
 */
public data class QuerySuggestionsBlockListSourceS3PathArgs(
    public val bucket: Output<String>,
    public val key: Output<String>,
) : ConvertibleToJava<com.pulumi.aws.kendra.inputs.QuerySuggestionsBlockListSourceS3PathArgs> {
    override fun toJava(): com.pulumi.aws.kendra.inputs.QuerySuggestionsBlockListSourceS3PathArgs =
        com.pulumi.aws.kendra.inputs.QuerySuggestionsBlockListSourceS3PathArgs.builder()
            .bucket(bucket.applyValue({ args0 -> args0 }))
            .key(key.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [QuerySuggestionsBlockListSourceS3PathArgs].
 */
@PulumiTagMarker
public class QuerySuggestionsBlockListSourceS3PathArgsBuilder internal constructor() {
    private var bucket: Output<String>? = null

    private var key: Output<String>? = null

    /**
     * @param value Name of the S3 bucket that contains the file.
     */
    @JvmName("pxrhbjwcnjdaxolq")
    public suspend fun bucket(`value`: Output<String>) {
        this.bucket = value
    }

    /**
     * @param value Name of the file.
     * The following arguments are optional:
     */
    @JvmName("ygrympqjlepsxmjd")
    public suspend fun key(`value`: Output<String>) {
        this.key = value
    }

    /**
     * @param value Name of the S3 bucket that contains the file.
     */
    @JvmName("apixbyuapcaepyre")
    public suspend fun bucket(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.bucket = mapped
    }

    /**
     * @param value Name of the file.
     * The following arguments are optional:
     */
    @JvmName("iyexyrmmdkcdnnis")
    public suspend fun key(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.key = mapped
    }

    internal fun build(): QuerySuggestionsBlockListSourceS3PathArgs =
        QuerySuggestionsBlockListSourceS3PathArgs(
            bucket = bucket ?: throw PulumiNullFieldException("bucket"),
            key = key ?: throw PulumiNullFieldException("key"),
        )
}
