@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.kendra.kotlin.inputs

import com.pulumi.aws.kendra.inputs.ThesaurusSourceS3PathArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property bucket The name of the S3 bucket that contains the file.
 * @property key The name of the file.
 * The following arguments are optional:
 */
public data class ThesaurusSourceS3PathArgs(
    public val bucket: Output<String>,
    public val key: Output<String>,
) : ConvertibleToJava<com.pulumi.aws.kendra.inputs.ThesaurusSourceS3PathArgs> {
    override fun toJava(): com.pulumi.aws.kendra.inputs.ThesaurusSourceS3PathArgs =
        com.pulumi.aws.kendra.inputs.ThesaurusSourceS3PathArgs.builder()
            .bucket(bucket.applyValue({ args0 -> args0 }))
            .key(key.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ThesaurusSourceS3PathArgs].
 */
@PulumiTagMarker
public class ThesaurusSourceS3PathArgsBuilder internal constructor() {
    private var bucket: Output<String>? = null

    private var key: Output<String>? = null

    /**
     * @param value The name of the S3 bucket that contains the file.
     */
    @JvmName("jgqkpwidrsitmxsw")
    public suspend fun bucket(`value`: Output<String>) {
        this.bucket = value
    }

    /**
     * @param value The name of the file.
     * The following arguments are optional:
     */
    @JvmName("uivpytowrxomalaa")
    public suspend fun key(`value`: Output<String>) {
        this.key = value
    }

    /**
     * @param value The name of the S3 bucket that contains the file.
     */
    @JvmName("vtqideofiqrhjvis")
    public suspend fun bucket(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.bucket = mapped
    }

    /**
     * @param value The name of the file.
     * The following arguments are optional:
     */
    @JvmName("xetwpwajstkppioh")
    public suspend fun key(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.key = mapped
    }

    internal fun build(): ThesaurusSourceS3PathArgs = ThesaurusSourceS3PathArgs(
        bucket = bucket ?: throw PulumiNullFieldException("bucket"),
        key = key ?: throw PulumiNullFieldException("key"),
    )
}
