@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.kendra.kotlin.outputs

import kotlin.Suppress

/**
 *
 * @property s3Configuration A block that provides the configuration information to connect to an Amazon S3 bucket as your data source. Detailed below.
 * @property webCrawlerConfiguration A block that provides the configuration information required for Amazon Kendra Web Crawler. Detailed below.
 */
public data class DataSourceConfiguration(
    public val s3Configuration: DataSourceConfigurationS3Configuration? = null,
    public val webCrawlerConfiguration: DataSourceConfigurationWebCrawlerConfiguration? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.kendra.outputs.DataSourceConfiguration):
            DataSourceConfiguration = DataSourceConfiguration(
            s3Configuration = javaType.s3Configuration().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.kendra.kotlin.outputs.DataSourceConfigurationS3Configuration.Companion.toKotlin(args0)
                })
            }).orElse(null),
            webCrawlerConfiguration = javaType.webCrawlerConfiguration().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.kendra.kotlin.outputs.DataSourceConfigurationWebCrawlerConfiguration.Companion.toKotlin(args0)
                })
            }).orElse(null),
        )
    }
}
