@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.kendra.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property s3Prefix A prefix used to filter metadata configuration files in the AWS S3 bucket. The S3 bucket might contain multiple metadata files. Use `s3_prefix` to include only the desired metadata files.
 */
public data class DataSourceConfigurationS3ConfigurationDocumentsMetadataConfiguration(
    public val s3Prefix: String? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.aws.kendra.outputs.DataSourceConfigurationS3ConfigurationDocumentsMetadataConfiguration):
            DataSourceConfigurationS3ConfigurationDocumentsMetadataConfiguration =
            DataSourceConfigurationS3ConfigurationDocumentsMetadataConfiguration(
                s3Prefix = javaType.s3Prefix().map({ args0 -> args0 }).orElse(null),
            )
    }
}
