@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.kendra.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property credentials Your secret ARN, which you can create in AWS Secrets Manager. You use a secret if basic authentication credentials are required to connect to a website. The secret stores your credentials of user name and password.
 * @property host The name of the website host you want to connect to using authentication credentials. For example, the host name of `https://a.example.com/page1.html` is `"a.example.com"`.
 * @property port The port number of the website host you want to connect to using authentication credentials. For example, the port for `https://a.example.com/page1.html` is `443`, the standard port for HTTPS.
 */
public data class
DataSourceConfigurationWebCrawlerConfigurationAuthenticationConfigurationBasicAuthentication(
    public val credentials: String,
    public val host: String,
    public val port: Int,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.aws.kendra.outputs.DataSourceConfigurationWebCrawlerConfigurationAuthenticationConfigurationBasicAuthentication):
            DataSourceConfigurationWebCrawlerConfigurationAuthenticationConfigurationBasicAuthentication =
            DataSourceConfigurationWebCrawlerConfigurationAuthenticationConfigurationBasicAuthentication(
                credentials = javaType.credentials(),
                host = javaType.host(),
                port = javaType.port(),
            )
    }
}
