@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.kendra.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property seedUrls The list of seed or starting point URLs of the websites you want to crawl. The list can include a maximum of `100` seed URLs. Array Members: Minimum number of `0` items. Maximum number of `100` items. Length Constraints: Minimum length of `1`. Maximum length of `2048`.
 * @property webCrawlerMode The default mode is set to `HOST_ONLY`. You can choose one of the following modes:
 */
public data class DataSourceConfigurationWebCrawlerConfigurationUrlsSeedUrlConfiguration(
    public val seedUrls: List<String>,
    public val webCrawlerMode: String? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.aws.kendra.outputs.DataSourceConfigurationWebCrawlerConfigurationUrlsSeedUrlConfiguration):
            DataSourceConfigurationWebCrawlerConfigurationUrlsSeedUrlConfiguration =
            DataSourceConfigurationWebCrawlerConfigurationUrlsSeedUrlConfiguration(
                seedUrls = javaType.seedUrls().map({ args0 -> args0 }),
                webCrawlerMode = javaType.webCrawlerMode().map({ args0 -> args0 }).orElse(null),
            )
    }
}
