@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.kendra.kotlin.outputs

import kotlin.Boolean
import kotlin.Suppress

/**
 *
 * @property condition Configuration of the condition used for the target document attribute or metadata field when ingesting documents into Amazon Kendra. See condition.
 * @property documentContentDeletion `TRUE` to delete content if the condition used for the target attribute is met.
 * @property target Configuration of the target document attribute or metadata field when ingesting documents into Amazon Kendra. You can also include a value. Detailed below.
 */
public data class DataSourceCustomDocumentEnrichmentConfigurationInlineConfiguration(
    public val condition: DataSourceCustomDocumentEnrichmentConfigurationInlineConfigurationCondition? =
        null,
    public val documentContentDeletion: Boolean? = null,
    public val target: DataSourceCustomDocumentEnrichmentConfigurationInlineConfigurationTarget? =
        null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.aws.kendra.outputs.DataSourceCustomDocumentEnrichmentConfigurationInlineConfiguration):
            DataSourceCustomDocumentEnrichmentConfigurationInlineConfiguration =
            DataSourceCustomDocumentEnrichmentConfigurationInlineConfiguration(
                condition = javaType.condition().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.kendra.kotlin.outputs.DataSourceCustomDocumentEnrichmentConfigurationInlineConfigurationCondition.Companion.toKotlin(args0)
                    })
                }).orElse(null),
                documentContentDeletion = javaType.documentContentDeletion().map({ args0 -> args0 }).orElse(null),
                target = javaType.target().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.kendra.kotlin.outputs.DataSourceCustomDocumentEnrichmentConfigurationInlineConfigurationTarget.Companion.toKotlin(args0)
                    })
                }).orElse(null),
            )
    }
}
