@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.kendra.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property invocationCondition A block that specifies the condition used for when a Lambda function should be invoked. For example, you can specify a condition that if there are empty date-time values, then Amazon Kendra should invoke a function that inserts the current date-time. See invocation_condition.
 * @property lambdaArn The Amazon Resource Name (ARN) of a Lambda Function that can manipulate your document metadata fields or attributes and content.
 * @property s3Bucket Stores the original, raw documents or the structured, parsed documents before and after altering them. For more information, see [Data contracts for Lambda functions](https://docs.aws.amazon.com/kendra/latest/dg/custom-document-enrichment.html#cde-data-contracts-lambda).
 */
public data class DataSourceCustomDocumentEnrichmentConfigurationPreExtractionHookConfiguration(
    public val invocationCondition:
    DataSourceCustomDocumentEnrichmentConfigurationPreExtractionHookConfigurationInvocationCondition? =
        null,
    public val lambdaArn: String,
    public val s3Bucket: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.aws.kendra.outputs.DataSourceCustomDocumentEnrichmentConfigurationPreExtractionHookConfiguration):
            DataSourceCustomDocumentEnrichmentConfigurationPreExtractionHookConfiguration =
            DataSourceCustomDocumentEnrichmentConfigurationPreExtractionHookConfiguration(
                invocationCondition = javaType.invocationCondition().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.kendra.kotlin.outputs.DataSourceCustomDocumentEnrichmentConfigurationPreExtractionHookConfigurationInvocationCondition.Companion.toKotlin(args0)
                    })
                }).orElse(null),
                lambdaArn = javaType.lambdaArn(),
                s3Bucket = javaType.s3Bucket(),
            )
    }
}
