@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.kendra.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property dataSourceIds The identifiers of the data sources you want to use for your Amazon Kendra experience. Maximum number of 100 items.
 * @property directPutContent Whether to use documents you indexed directly using the `BatchPutDocument API`. Defaults to `false`.
 * @property faqIds The identifier of the FAQs that you want to use for your Amazon Kendra experience. Maximum number of 100 items.
 */
public data class ExperienceConfigurationContentSourceConfiguration(
    public val dataSourceIds: List<String>? = null,
    public val directPutContent: Boolean? = null,
    public val faqIds: List<String>? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.aws.kendra.outputs.ExperienceConfigurationContentSourceConfiguration):
            ExperienceConfigurationContentSourceConfiguration =
            ExperienceConfigurationContentSourceConfiguration(
                dataSourceIds = javaType.dataSourceIds().map({ args0 -> args0 }),
                directPutContent = javaType.directPutContent().map({ args0 -> args0 }).orElse(null),
                faqIds = javaType.faqIds().map({ args0 -> args0 }),
            )
    }
}
