@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.kendra.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property endpoint The endpoint of your Amazon Kendra experience.
 * @property endpointType The type of endpoint for your Amazon Kendra experience.
 */
public data class ExperienceEndpoint(
    public val endpoint: String? = null,
    public val endpointType: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.kendra.outputs.ExperienceEndpoint):
            ExperienceEndpoint = ExperienceEndpoint(
            endpoint = javaType.endpoint().map({ args0 -> args0 }).orElse(null),
            endpointType = javaType.endpointType().map({ args0 -> args0 }).orElse(null),
        )
    }
}
