@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.kendra.kotlin.outputs

import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property contentSourceConfigurations The identifiers of your data sources and FAQs. This is the content you want to use for your Amazon Kendra Experience. Documented below.
 * @property userIdentityConfigurations The AWS SSO field name that contains the identifiers of your users, such as their emails. Documented below.
 */
public data class GetExperienceConfiguration(
    public val contentSourceConfigurations:
    List<GetExperienceConfigurationContentSourceConfiguration>,
    public val userIdentityConfigurations: List<GetExperienceConfigurationUserIdentityConfiguration>,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.kendra.outputs.GetExperienceConfiguration):
            GetExperienceConfiguration = GetExperienceConfiguration(
            contentSourceConfigurations = javaType.contentSourceConfigurations().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.kendra.kotlin.outputs.GetExperienceConfigurationContentSourceConfiguration.Companion.toKotlin(args0)
                })
            }),
            userIdentityConfigurations = javaType.userIdentityConfigurations().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.kendra.kotlin.outputs.GetExperienceConfigurationUserIdentityConfiguration.Companion.toKotlin(args0)
                })
            }),
        )
    }
}
