@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.kendra.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property dataSourceIds Identifiers of the data sources you want to use for your Amazon Kendra Experience.
 * @property directPutContent Whether to use documents you indexed directly using the `BatchPutDocument API`.
 * @property faqIds Identifier of the FAQs that you want to use for your Amazon Kendra Experience.
 */
public data class GetExperienceConfigurationContentSourceConfiguration(
    public val dataSourceIds: List<String>,
    public val directPutContent: Boolean,
    public val faqIds: List<String>,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.aws.kendra.outputs.GetExperienceConfigurationContentSourceConfiguration):
            GetExperienceConfigurationContentSourceConfiguration =
            GetExperienceConfigurationContentSourceConfiguration(
                dataSourceIds = javaType.dataSourceIds().map({ args0 -> args0 }),
                directPutContent = javaType.directPutContent(),
                faqIds = javaType.faqIds().map({ args0 -> args0 }),
            )
    }
}
