@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.kendra.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property endpoint Endpoint of your Amazon Kendra Experience.
 * @property endpointType Type of endpoint for your Amazon Kendra Experience.
 */
public data class GetExperienceEndpoint(
    public val endpoint: String,
    public val endpointType: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.kendra.outputs.GetExperienceEndpoint):
            GetExperienceEndpoint = GetExperienceEndpoint(
            endpoint = javaType.endpoint(),
            endpointType = javaType.endpointType(),
        )
    }
}
